/*
 * Decompiled with CFR 0.152.
 */
package com.ds.config;

import com.ds.config.ActivityDefImpl;
import com.ds.config.BPDPlugin;
import com.ds.config.BPDProjectConfig;
import com.ds.config.CAJDSService;
import com.ds.config.CApplication;
import com.ds.config.CBPDBrowserElement;
import com.ds.config.CExtendedAttribute;
import com.ds.config.CFormula;
import com.ds.config.CListener;
import com.ds.config.CParameter;
import com.ds.config.PluginType;
import com.ds.esb.config.formula.FormulaType;
import com.ds.server.OrgManagerFactory;
import com.ds.server.SubSystem;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.input.SAXBuilder;
import org.xml.sax.InputSource;

public class AppConfig
implements Serializable {
    private CApplication application;
    public static final String FLOWTYPENAME = "FlowType";

    public AppConfig(InputSource is) {
        if (is == null) {
            throw new IllegalArgumentException("Parameter 'is' can't be null.");
        }
        try {
            SAXBuilder builder = new SAXBuilder();
            this.init(builder.build(is));
        }
        catch (Exception e) {
            System.out.println("Error parsing XML stream file.");
            e.printStackTrace();
        }
    }

    private void init(Document doc) {
        Element root = doc.getRootElement();
        String appcode = root.getAttributeValue("code");
        String appname = root.getAttributeValue("name");
        this.application = new CApplication();
        this.application.setConfigCode(appcode);
        this.application.setName(appname);
        Element element = root.getChild("ProcessClassification");
        if (element != null) {
            this.application.setProcessClassification(element.getTextTrim());
        }
        List elements = root.getChildren();
        element = root.getChild("RightEngine");
        if (element != null) {
            CAJDSService rightEngine = new CAJDSService();
            rightEngine.setImplementation(element.getText());
            this.application.setRightEngine(rightEngine);
        }
        if ((element = root.getChild("DataEngine")) != null) {
            CAJDSService dataEngine = new CAJDSService();
            dataEngine.setImplementation(element.getText());
            this.application.setDataEngine(dataEngine);
        }
        if ((element = root.getChild("FileEngine")) != null) {
            CAJDSService fileEngine = new CAJDSService();
            fileEngine.setImplementation(element.getText());
            this.application.setFileEngine(fileEngine);
        }
        if ((element = root.getChild("AdminService")) != null) {
            CAJDSService adminService = new CAJDSService();
            adminService.setImplementation(element.getText());
            this.application.setAdminService(adminService);
        }
        if ((element = root.getChild("VFSService")) != null) {
            CAJDSService vfsService = new CAJDSService();
            vfsService.setImplementation(element.getText());
            this.application.setVfsService(vfsService);
        }
        if ((element = root.getChild("MsgEngine")) != null) {
            CAJDSService bssEngine = new CAJDSService();
            bssEngine.setImplementation(element.getText());
            this.application.setMsgEngine(bssEngine);
        }
        if ((element = root.getChild("MsgService")) != null) {
            CAJDSService bssService = new CAJDSService();
            bssService.setImplementation(element.getText());
            this.application.setMsgService(bssService);
        }
        if ((element = root.getChild("GWService")) != null) {
            CAJDSService gwService = new CAJDSService();
            gwService.setImplementation(element.getText());
            this.application.setGwService(gwService);
        }
        if ((element = root.getChild("AppService")) != null) {
            CAJDSService appService = new CAJDSService();
            appService.setImplementation(element.getText());
            this.application.setAppService(appService);
        }
        if ((element = root.getChild("GWEngine")) != null) {
            CAJDSService gwEngine = new CAJDSService();
            gwEngine.setImplementation(element.getText());
            this.application.setGwEngine(gwEngine);
        }
        if ((element = root.getChild("WorkflowService")) != null) {
            CAJDSService workflowService = new CAJDSService();
            workflowService.setImplementation(element.getText());
            this.application.setWorkflowService(workflowService);
        }
        if ((element = root.getChild("JDSService")) != null) {
            CAJDSService jdsService = new CAJDSService();
            jdsService.setImplementation(element.getText());
            this.application.setJdsService(jdsService);
        }
        if ((element = root.getChild("ConnectionHandle")) != null) {
            CAJDSService connectionHandle = new CAJDSService();
            connectionHandle.setImplementation(element.getText());
            this.application.setConnectionHandle(connectionHandle);
        }
        List flowTypes = root.getChildren(FLOWTYPENAME);
        HashMap<BPDProjectConfig, String> refMap = new HashMap<BPDProjectConfig, String>();
        for (int k = 0; k < flowTypes.size(); ++k) {
            Element flowTypeElement = (Element)flowTypes.get(k);
            BPDProjectConfig cFlowType = new BPDProjectConfig();
            String code = flowTypeElement.getAttributeValue("code");
            String name = flowTypeElement.getAttributeValue("name");
            String esbkeylist = flowTypeElement.getAttributeValue("esbKeyList");
            cFlowType.setEsbkeylist(esbkeylist);
            cFlowType.setSysId(appcode);
            cFlowType.setCode(code);
            cFlowType.setName(name);
            Element ref = flowTypeElement.getChild("ref");
            if (ref != null && !ref.getValue().equals("")) {
                refMap.put(cFlowType, ref.getValue());
                continue;
            }
            Map<String, BPDPlugin> bpdElementMap = this.fromXMLBPDElement(flowTypeElement, code);
            bpdElementMap.forEach((key, value) -> cFlowType.getBpdElementsList().add((BPDPlugin)value));
            cFlowType.setProcessListeners(this.fromXMLWPListener(flowTypeElement, code));
            cFlowType.setBpdListeners(this.fromXMLBPDListener(flowTypeElement, code));
            cFlowType.setRightListeners(this.fromXMLRightListener(flowTypeElement, code));
            cFlowType.setActivityListeners(this.fromXMLActListener(flowTypeElement, code));
            this.application.getBPDProjectConfigMap().put(code, cFlowType);
        }
        List<SubSystem> systems = OrgManagerFactory.getInstance().getSystems();
        for (SubSystem system : systems) {
            String defauleType = system.getConfigname().getType();
            if (defauleType == null || defauleType.equals("")) {
                defauleType = "default";
            }
            BPDProjectConfig flowType = new BPDProjectConfig();
            BPDProjectConfig sourceflowType = this.application.getBPDProjectConfigMap().get(defauleType);
            if (sourceflowType == null || !system.getConfigname().equals(this.application.getConfigCode())) continue;
            flowType.setSysId(system.getSysId());
            flowType.setCode(system.getSysId());
            flowType.setName(system.getName());
            flowType.setActivityListeners(sourceflowType.getActivityListeners());
            flowType.setProcessListeners(sourceflowType.getProcessListeners());
            flowType.getBpdElementsList().addAll(sourceflowType.getBpdElementsList());
            this.application.getBPDProjectConfigMap().put(flowType.getCode(), flowType);
        }
    }

    private Map<String, BPDPlugin> fromXMLBPDElement(Element flowTypeElement, String code) {
        HashMap<String, BPDPlugin> bpdElementMap = new HashMap<String, BPDPlugin>();
        Element bpdXMLElements = flowTypeElement.getChild("BPDElements");
        if (bpdXMLElements != null) {
            List pdtElementList = bpdXMLElements.getChildren();
            for (int i = 0; i < pdtElementList.size(); ++i) {
                String width;
                Element bpdXMLElement = (Element)pdtElementList.get(i);
                BPDPlugin bpdElement = new BPDPlugin();
                bpdElement.setName(bpdXMLElement.getAttributeValue("name"));
                String type = bpdXMLElement.getAttributeValue("type");
                bpdElement.setActivityType(ActivityDefImpl.fromType(type));
                String plugintype = bpdXMLElement.getAttributeValue("plugintype");
                bpdElement.setPluginType(PluginType.fromType(plugintype));
                bpdElement.setDisplayname(bpdXMLElement.getAttributeValue("displayname"));
                String height = bpdXMLElement.getAttributeValue("height");
                if (height != null) {
                    bpdElement.setHeight(Integer.parseInt(bpdXMLElement.getAttributeValue("height")));
                }
                if ((width = bpdXMLElement.getAttributeValue("width")) != null) {
                    bpdElement.setWidth(Integer.parseInt(bpdXMLElement.getAttributeValue("width")));
                }
                bpdElement.setImplementation(bpdXMLElement.getAttributeValue("implementation"));
                List paramList = bpdXMLElement.getChildren("Parameter");
                for (int j = 0; j < paramList.size(); ++j) {
                    Element paramXMLElement = (Element)paramList.get(j);
                    CParameter param = new CParameter();
                    param.setName(paramXMLElement.getAttributeValue("name"));
                    param.setParameterValue(paramXMLElement.getAttributeValue("value"));
                    param.setParameterId(UUID.randomUUID().toString());
                    bpdElement.putParameter(param.getName(), param);
                }
                List formulaList = bpdXMLElement.getChildren("Formula");
                for (int j = 0; j < formulaList.size(); ++j) {
                    Element paramXMLElement = (Element)formulaList.get(j);
                    CFormula param = new CFormula();
                    param.setParameterId(UUID.randomUUID().toString());
                    param.setName(paramXMLElement.getAttributeValue("name"));
                    param.setParameterValue(FormulaType.fromType(paramXMLElement.getAttributeValue("value")));
                    bpdElement.putFormula(param.getName(), param);
                }
                bpdElement.setExtendedAttributes(this.fromXMLExtendedAttribute(bpdXMLElement, bpdElement.getPluginId()));
                bpdElement.setBrowserElements(this.fromXMLBrowser(bpdXMLElement, bpdElement.getPluginId()));
                bpdElementMap.put(bpdElement.getName(), bpdElement);
            }
        }
        return bpdElementMap;
    }

    private List<CBPDBrowserElement> fromXMLBrowser(Element bpdXMLElement, String pluginId) {
        ArrayList<CBPDBrowserElement> borwserlist = new ArrayList<CBPDBrowserElement>();
        List urlConfigList = bpdXMLElement.getChildren("BrowserConfig");
        for (int j = 0; j < urlConfigList.size(); ++j) {
            Element uiConfigXMLElement = (Element)urlConfigList.get(j);
            CBPDBrowserElement browser = new CBPDBrowserElement();
            browser.setName(uiConfigXMLElement.getAttributeValue("name"));
            browser.setBaseurl(uiConfigXMLElement.getAttributeValue("baseurl"));
            browser.setDisplayname(uiConfigXMLElement.getAttributeValue("displayname"));
            browser.setToxml(uiConfigXMLElement.getAttributeValue("toxml"));
            browser.setPluginId(pluginId);
            List urlParamList = uiConfigXMLElement.getChildren("Parameter");
            for (int f = 0; f < urlParamList.size(); ++f) {
                Element urlParamXMLElement = (Element)urlParamList.get(f);
                CParameter param = new CParameter();
                param.setName(urlParamXMLElement.getAttributeValue("name"));
                param.setParameterValue(urlParamXMLElement.getAttributeValue("value"));
                browser.putParameter(param.getName(), param);
            }
            borwserlist.add(browser);
        }
        return borwserlist;
    }

    private Map<String, CExtendedAttribute> fromXMLExtendedAttribute(Element bpdXMLElement, String pluginId) {
        HashMap<String, CExtendedAttribute> extendedAttributeMap = new HashMap<String, CExtendedAttribute>();
        List extendedAttributeList = bpdXMLElement.getChildren("ExtendedAttribute");
        for (int j = 0; j < extendedAttributeList.size(); ++j) {
            Element extendedXMLelement = (Element)extendedAttributeList.get(j);
            CExtendedAttribute extendedAttribute = new CExtendedAttribute();
            extendedAttribute.setName(extendedXMLelement.getAttributeValue("name"));
            extendedAttribute.setValue(extendedXMLelement.getAttributeValue("value"));
            extendedAttribute.setType(extendedXMLelement.getAttributeValue("type"));
            extendedAttributeMap.put(extendedAttribute.getName(), extendedAttribute);
        }
        return extendedAttributeMap;
    }

    private List<CListener> fromXMLWPListener(Element flowTypeElement, String code) {
        ArrayList<CListener> listenerList = new ArrayList<CListener>();
        Element listenerPXMLElement = flowTypeElement.getChild("ProcessListeners");
        if (listenerPXMLElement != null) {
            List listeners = listenerPXMLElement.getChildren();
            CListener defaultlistener = new CListener();
            defaultlistener.setImplementation("com.ds.bpm.engine.event.DefaultProcessListenerExpressionPar");
            defaultlistener.setName("\u8868\u8fbe\u5f0f\u89e3\u6790");
            listenerList.add(defaultlistener);
            for (int i = 0; i < listeners.size(); ++i) {
                Element element = (Element)listeners.get(i);
                CListener listener = new CListener();
                listener.setProjectId(code);
                listener.setName(element.getAttributeValue("name"));
                listener.setImplementation(element.getText());
                listenerList.add(listener);
            }
        }
        return listenerList;
    }

    private List<CListener> fromXMLBPDListener(Element flowTypeElement, String code) {
        ArrayList<CListener> listenerList = new ArrayList<CListener>();
        Element listenerPXMLElement = flowTypeElement.getChild("BPDListeners");
        if (listenerPXMLElement != null) {
            List listeners = listenerPXMLElement.getChildren();
            for (int i = 0; i < listeners.size(); ++i) {
                Element element = (Element)listeners.get(i);
                CListener listener = new CListener();
                listener.setProjectId(code);
                listener.setName(element.getAttributeValue("name"));
                listener.setImplementation(element.getText());
                listenerList.add(listener);
            }
        }
        return listenerList;
    }

    private List<CListener> fromXMLRightListener(Element flowTypeElement, String code) {
        ArrayList<CListener> listenerList = new ArrayList<CListener>();
        Element listenerPXMLElement = flowTypeElement.getChild("RightListeners");
        if (listenerPXMLElement != null) {
            List listeners = listenerPXMLElement.getChildren();
            for (int i = 0; i < listeners.size(); ++i) {
                Element element = (Element)listeners.get(i);
                CListener listener = new CListener();
                listener.setProjectId(code);
                listener.setName(element.getAttributeValue("name"));
                listener.setImplementation(element.getText());
                listenerList.add(listener);
            }
        }
        return listenerList;
    }

    private List<CListener> fromXMLActListener(Element flowTypeElement, String code) {
        ArrayList<CListener> activityListenerList = new ArrayList<CListener>();
        Element listenerAXMLElement = flowTypeElement.getChild("ProcessListeners");
        if (listenerAXMLElement != null) {
            List listeners = listenerAXMLElement.getChildren();
            CListener defaultlistener = new CListener();
            defaultlistener.setImplementation("com.ds.bpm.engine.event.DefaultActivityListenerExpressionPar");
            defaultlistener.setName("\u8868\u8fbe\u5f0f\u89e3\u6790");
            activityListenerList.add(defaultlistener);
            for (int i = 0; i < listeners.size(); ++i) {
                Element element = (Element)listeners.get(i);
                CListener listener = new CListener();
                listener.setProjectId(code);
                listener.setName(element.getAttributeValue("name"));
                listener.setImplementation(element.getText());
                activityListenerList.add(listener);
            }
        }
        return activityListenerList;
    }

    public CApplication getApplication() {
        return this.application;
    }

    public String getRightEngine() {
        return this.application.getRightEngine() == null ? null : this.application.getRightEngine().getImplementation();
    }

    public String getDataEngine() {
        return this.application.getDataEngine() == null ? null : this.application.getDataEngine().getImplementation();
    }

    public String getFileEngine() {
        return this.application.getFileEngine() == null ? null : this.application.getFileEngine().getImplementation();
    }

    public String getVFSEngine() {
        return this.application.getVfsEngine() == null ? null : this.application.getVfsEngine().getImplementation();
    }

    public String getVFSService() {
        return this.application.getVfsService() == null ? null : this.application.getVfsService().getImplementation();
    }

    public String getAdminService() {
        return this.application.getAdminService() == null ? null : this.application.getAdminService().getImplementation();
    }
}

