/*
 * Decompiled with CFR 0.152.
 */
package com.ds.common.util.java;

import com.ds.common.util.ClassUtility;
import com.ds.common.util.IOUtility;
import com.ds.common.util.java.TmpJavaFileObject;
import java.io.File;
import java.io.IOException;

public class DynamicClassLoader
extends ClassLoader {
    private byte[] bytes;

    public DynamicClassLoader(TmpJavaFileObject myJavaFileObject) {
        this.bytes = myJavaFileObject.getCompiledBytes();
    }

    public void dumpFile(File file) throws IOException {
        IOUtility.writeBytesToNewFile(this.bytes, file);
    }

    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        Class clazz = null;
        try {
            clazz = super.loadClass(name);
        }
        catch (Throwable e) {
            clazz = ClassUtility.loadClass(name);
        }
        return clazz;
    }

    @Override
    public Package[] getPackages() {
        return super.getPackages();
    }

    @Override
    public Class<?> findClass(String name) throws ClassNotFoundException {
        Class<?> clazz = null;
        try {
            clazz = super.findClass(name);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        if (clazz == null) {
            try {
                clazz = Class.forName(name);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        try {
            if (clazz == null) {
                clazz = this.defineClass(name, this.bytes, 0, this.bytes.length);
            }
            if (clazz.getPackage() == null) {
                String packageName = name.substring(0, name.lastIndexOf("."));
                this.definePackage(packageName, "ESDDynPackage", "1.0.0", "ESD", null, null, null, null);
            }
        }
        catch (Throwable e) {
            throw new ClassNotFoundException();
        }
        return clazz;
    }

    public void setTmpJavaFileObject(TmpJavaFileObject myJavaFileObject) {
        super.clearAssertionStatus();
        this.bytes = myJavaFileObject.getCompiledBytes();
    }
}

