/*
 * Decompiled with CFR 0.152.
 */
package com.ds.common.util;

import com.ds.common.util.IOUtility;
import com.ds.common.util.StringUtility;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;
import java.util.jar.JarOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public class ZipUtil {
    public static void zip(String src, String des) throws IOException {
        ZipUtil.zip(src, des, false);
    }

    public static void jar(String src, String des) throws IOException {
        ZipUtil.zip(src, des, true);
    }

    private static void zip(String src, String des, boolean flag) throws IOException {
        String extName;
        File srcFile = new File(src);
        File desFile = new File(des);
        if (desFile.isDirectory()) {
            desFile = new File(desFile, srcFile.getName());
        }
        String name = desFile.getName();
        File parent = desFile.getParentFile();
        String string = extName = flag ? ".jar" : ".zip";
        if (!name.endsWith(extName)) {
            desFile = new File(parent, name + extName);
        }
        if (!parent.exists()) {
            parent.mkdirs();
        }
        if (desFile.exists()) {
            desFile.delete();
        }
        desFile.createNewFile();
        ZipOutputStream zos = flag ? new JarOutputStream(new FileOutputStream(desFile)) : new ZipOutputStream(new FileOutputStream(desFile));
        String absPath = null;
        if (srcFile.isDirectory() && !(absPath = srcFile.getCanonicalPath()).endsWith(File.separator)) {
            absPath = absPath + File.separator;
        }
        ZipUtil.zipFile(srcFile, zos, absPath);
        zos.close();
    }

    private static void zipFile(File file, ZipOutputStream zos, String absPath) throws IOException {
        if (file.isDirectory()) {
            File[] fs = file.listFiles();
            for (int i = 0; i < fs.length; ++i) {
                File f = fs[i];
                ZipUtil.zipFile(f, zos, absPath);
            }
        } else {
            BufferedInputStream is = new BufferedInputStream(new FileInputStream(file));
            String name = null;
            name = absPath == null ? file.getName() : file.getCanonicalPath().replace(absPath, "");
            name = StringUtility.replace(name, File.separator, "/");
            zos.putNextEntry(new ZipEntry(name));
            IOUtility.write(is, zos);
            ((InputStream)is).close();
            zos.closeEntry();
        }
    }

    public static void unzip(String src, String des) throws IOException {
        ZipUtil.unzip(src, des, false);
    }

    public static void unjar(String src, String des) throws IOException {
        ZipUtil.unzip(src, des, true);
    }

    private static void unzip(String src, String des, boolean flag) throws IOException {
        String extName;
        File srcFile = new File(src);
        File desDir = new File(des);
        String string = extName = flag ? ".jar" : ".zip";
        if (!srcFile.getName().endsWith(extName)) {
            throw new IllegalArgumentException("\u6e90\u6587\u4ef6\u4e0d\u6b63\u786e");
        }
        if (!desDir.exists()) {
            desDir.mkdirs();
        }
        ZipInputStream zis = flag ? new JarInputStream(new FileInputStream(srcFile)) : new ZipInputStream(new FileInputStream(srcFile));
        ZipEntry entry = null;
        while ((entry = zis.getNextEntry()) != null) {
            if (entry.isDirectory()) continue;
            File file = new File(desDir, entry.getName());
            File parent = file.getParentFile();
            if (!parent.exists()) {
                parent.mkdirs();
            }
            if (file.exists()) {
                file.delete();
            }
            file.createNewFile();
            FileOutputStream fos = new FileOutputStream(file);
            IOUtility.write(zis, fos);
        }
    }

    public static byte[] getBytesFromJar(String jarPath, String contentPath) throws IOException {
        JarFile jarFile = new JarFile(jarPath);
        JarEntry entry = (JarEntry)jarFile.getEntry(contentPath);
        InputStream is = jarFile.getInputStream(entry);
        byte[] bs = IOUtility.getBytesFromInputStream(is);
        is.close();
        return bs;
    }

    public static void getJarContentToFile(String jarPath, String contentPath, File desFile) throws IOException {
        IOUtility.writeBytesToNewFile(ZipUtil.getBytesFromJar(jarPath, contentPath), desFile);
    }

    public static void main(String[] args) throws IOException {
        ZipUtil.ziptest();
    }

    private static void unziptest() throws IOException {
        String src = "E:\\mywork\\tcyx\\javaPro\\test\\src.zip";
        String des = "E:\\mywork\\tcyx\\javaPro\\test\\out";
        ZipUtil.unzip(src, des);
    }

    private static void ziptest() throws IOException {
        String src = "E:\\mywork\\tcyx\\javaPro\\test\\src";
        String des = "E:\\mywork\\tcyx\\javaPro\\test";
        ZipUtil.jar(src, des);
    }
}

