/*
 * Decompiled with CFR 0.152.
 */
package com.ds.common.util;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.StringTokenizer;

public final class StringUtility {
    private static final char[] newLine = new char[2];
    private static final String newLineString;
    private static final String[] htmlSpecial;
    private static final String[] htmlESC;
    private static final String[] jsSpecial;
    private static final String[] jsESC;
    private static final String[] sqlSpecial;
    private static final String[] sqlESC;

    private StringUtility() {
    }

    public static String convertSingleQuot(String src) {
        if (src == null || src.equals("")) {
            return src;
        }
        int length = src.length();
        StringBuffer tmp = new StringBuffer();
        for (int i = 0; i < length; ++i) {
            if (src.charAt(i) == '\'') {
                tmp.append("''");
                continue;
            }
            tmp.append(src.charAt(i));
        }
        return tmp.toString();
    }

    public static String createRandom(boolean numberFlag, int length) {
        String retStr = "";
        String strTable = numberFlag ? "1234567890" : "1234567890abcdefghijkmnpqrstuvwxyz";
        int len = strTable.length();
        boolean bDone = true;
        do {
            retStr = "";
            int count = 0;
            for (int i = 0; i < length; ++i) {
                double dblR = Math.random() * (double)len;
                int intR = (int)Math.floor(dblR);
                char c = strTable.charAt(intR);
                if ('0' <= c && c <= '9') {
                    ++count;
                }
                retStr = retStr + strTable.charAt(intR);
            }
            if (count < 2) continue;
            bDone = false;
        } while (bDone);
        return retStr;
    }

    public static String convertCastChar(String src) {
        if (src == null || src.equals("")) {
            return src;
        }
        int length = src.length();
        StringBuffer tmp = new StringBuffer();
        for (int i = 0; i < length; ++i) {
            switch (src.charAt(i)) {
                case '%': 
                case '\\': 
                case '_': {
                    tmp.append("\\");
                }
            }
            tmp.append(src.charAt(i));
        }
        return tmp.toString();
    }

    public static String convertForHtml(String src) {
        if (src == null || src.equals("")) {
            return src;
        }
        int length = src.length();
        StringBuffer tmp = new StringBuffer();
        block9: for (int i = 0; i < length; ++i) {
            switch (src.charAt(i)) {
                case '<': {
                    tmp.append("&lt;");
                    continue block9;
                }
                case '>': {
                    tmp.append("&gt;");
                    continue block9;
                }
                case '\"': {
                    tmp.append("&quot;");
                    continue block9;
                }
                case ' ': {
                    int spaceCount = 0;
                    while (src.charAt(i) == ' ') {
                        ++i;
                        ++spaceCount;
                    }
                    for (int j = 0; j < spaceCount / 2; ++j) {
                        tmp.append("\u3000");
                    }
                    if (spaceCount % 2 != 0) {
                        tmp.append("&#160;");
                    }
                    --i;
                    continue block9;
                }
                case '\n': {
                    tmp.append("<br/>");
                    continue block9;
                }
                case '&': {
                    tmp.append("&amp;");
                    continue block9;
                }
                case '\r': {
                    continue block9;
                }
                default: {
                    tmp.append(src.charAt(i));
                }
            }
        }
        return tmp.toString();
    }

    public static String convertForXml(String src) {
        if (src == null || src.equals("")) {
            return src;
        }
        int length = src.length();
        StringBuffer tmp = new StringBuffer();
        block8: for (int i = 0; i < length; ++i) {
            switch (src.charAt(i)) {
                case '<': {
                    tmp.append("&lt;");
                    continue block8;
                }
                case '>': {
                    tmp.append("&gt;");
                    continue block8;
                }
                case '\"': {
                    tmp.append("&quot;");
                    continue block8;
                }
                case ' ': {
                    int spaceCount = 0;
                    while (src.charAt(i) == ' ') {
                        ++i;
                        ++spaceCount;
                    }
                    for (int j = 0; j < spaceCount / 2; ++j) {
                        tmp.append("\u3000");
                    }
                    if (spaceCount % 2 != 0) {
                        tmp.append("&#160;");
                    }
                    --i;
                    continue block8;
                }
                case '&': {
                    tmp.append("&amp;");
                    continue block8;
                }
                case '\r': {
                    continue block8;
                }
                default: {
                    tmp.append(src.charAt(i));
                }
            }
        }
        return tmp.toString();
    }

    public static String filterNull(String str) {
        if (str == null) {
            return new String();
        }
        return str;
    }

    public static String filterNullObject(Object obj) {
        if (obj == null) {
            return new String();
        }
        return obj.toString();
    }

    public static String replace(String original, String oldString, String newString) {
        return StringUtility.replace(original, oldString, newString, 0);
    }

    public static String replace(String original, String oldString, String newString, int counts) {
        if (original == null || oldString == null || newString == null) {
            return "";
        }
        if (counts < 0) {
            throw new IllegalArgumentException("parameter counts can not be negative");
        }
        StringBuffer sb = new StringBuffer();
        int end = original.indexOf(oldString);
        int start = 0;
        int stringSize = oldString.length();
        for (int currentCount = 0; end != -1 && (counts == 0 || currentCount < counts); ++currentCount) {
            sb.append(original.substring(start, end));
            sb.append(newString);
            start = end + stringSize;
            end = original.indexOf(oldString, start);
        }
        end = original.length();
        sb.append(original.substring(start, end));
        return sb.toString();
    }

    public static String escapeHTMLSpecial(String str) {
        return StringUtility.escapeSpecial(str, htmlSpecial, htmlESC);
    }

    public static String escapeJSSpecial(String str) {
        return StringUtility.escapeSpecial(str, jsSpecial, jsESC);
    }

    public static String escapeSQLSpecial(String str) {
        return StringUtility.escapeSpecial(str, sqlSpecial, sqlESC);
    }

    public static String getMoreString(String str, int maxByteLength, String more) {
        if (str == null) {
            return "";
        }
        int len = 0;
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            byte[] bytes = StringUtility.charToByte(c);
            len = bytes[0] == 0 ? ++len : (len += 2);
            if (len > maxByteLength) {
                buf.append(more == null ? "..." : more);
                break;
            }
            buf.append(c);
        }
        return buf.toString();
    }

    public static String[] split(String sourceString, String delim) {
        if (sourceString == null || delim == null) {
            return new String[0];
        }
        StringTokenizer st = new StringTokenizer(sourceString, delim);
        ArrayList<String> stringList = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            stringList.add(st.nextToken());
        }
        return stringList.toArray(new String[stringList.size()]);
    }

    public static byte[] intToByte(int number) {
        int temp = number;
        byte[] b = new byte[4];
        for (int i = b.length - 1; i > -1; --i) {
            b[i] = new Integer(temp & 0xFF).byteValue();
            temp >>= 8;
        }
        return b;
    }

    public static int byteToInt(byte[] b) {
        int s = 0;
        for (int i = 0; i < 3; ++i) {
            s = b[i] >= 0 ? (s += b[i]) : s + 256 + b[i];
            s *= 256;
        }
        s = b[3] >= 0 ? (s += b[3]) : s + 256 + b[3];
        return s;
    }

    public static byte[] charToByte(char ch) {
        int temp = ch;
        byte[] b = new byte[2];
        for (int i = b.length - 1; i > -1; --i) {
            b[i] = new Integer(temp & 0xFF).byteValue();
            temp >>= 8;
        }
        return b;
    }

    public static char byteToChar(byte[] b) {
        int s = 0;
        s = b[0] > 0 ? (s += b[0]) : (s += 256 + b[0]);
        s *= 256;
        s = b[1] > 0 ? (s += b[1]) : (s += 256 + b[1]);
        char ch = (char)s;
        return ch;
    }

    public static byte[] doubleToByte(double d) {
        byte[] b = new byte[8];
        long l = Double.doubleToLongBits(d);
        for (int i = 0; i < b.length; ++i) {
            b[i] = new Long(l).byteValue();
            l >>= 8;
        }
        return b;
    }

    public static double byteToDouble(byte[] b) {
        long l = b[0];
        l &= 0xFFL;
        l |= (long)b[1] << 8;
        l &= 0xFFFFL;
        l |= (long)b[2] << 16;
        l &= 0xFFFFFFL;
        l |= (long)b[3] << 24;
        l &= 0xFFFFFFFFL;
        l |= (long)b[4] << 32;
        l &= 0xFFFFFFFFFFL;
        l |= (long)b[5] << 40;
        l &= 0xFFFFFFFFFFFFL;
        l |= (long)b[6] << 48;
        return Double.longBitsToDouble(l |= (long)b[7] << 56);
    }

    private static String escapeSpecial(String str, String[] special, String[] esc) {
        String result = str;
        for (int i = 0; i < special.length; ++i) {
            result = StringUtility.replace(result, special[i], esc[i]);
        }
        return result;
    }

    private static final int base64Int(char c) {
        if (c >= 'a') {
            if (c <= 'z') {
                return c - 97 + 26;
            }
            return -1;
        }
        if (c >= 'A') {
            if (c <= 'Z') {
                return c - 65 + 0;
            }
            return -1;
        }
        if (c >= '0') {
            if (c <= '9') {
                return c - 48 + 52;
            }
            return c != '=' ? -1 : 0;
        }
        if (c == '+') {
            return 62;
        }
        return c != '/' ? -1 : 63;
    }

    private static final char base64Char(int i) {
        if (i >= 52) {
            if (i < 62) {
                return (char)(i - 52 + 48);
            }
            if (i == 62) {
                return '+';
            }
            return i != 63 ? (char)'?' : '/';
        }
        if (i >= 26) {
            return (char)(i - 26 + 97);
        }
        if (i >= 0) {
            return (char)(i - 0 + 65);
        }
        return '?';
    }

    public static final byte[] base64ToBytes(String s) {
        int k = 0;
        char[] ac = s.toCharArray();
        int i = ac.length;
        int j = 0;
        if (ac[i - 1] == '=') {
            ++j;
        }
        if (ac[i - 2] == '=') {
            ++j;
        }
        i = i / 4 * 3 - j;
        byte[] abyte0 = new byte[i];
        int l = 0;
        int i1 = 0;
        while (l + 3 < ac.length) {
            k = StringUtility.base64Int(ac[l + 0]) << 18 | StringUtility.base64Int(ac[l + 1]) << 12 | StringUtility.base64Int(ac[l + 2]) << 6 | StringUtility.base64Int(ac[l + 3]);
            l += 4;
            if (i1 >= i - 2) break;
            abyte0[i1++] = (byte)(k >> 16 & 0xFF);
            abyte0[i1++] = (byte)(k >> 8 & 0xFF);
            abyte0[i1++] = (byte)(k & 0xFF);
        }
        if (i1 < abyte0.length) {
            abyte0[i1++] = (byte)(k >> 16 & 0xFF);
        }
        if (i1 < abyte0.length) {
            abyte0[i1++] = (byte)(k >> 8 & 0xFF);
        }
        return abyte0;
    }

    public static final String bytesToBase64(byte[] abyte0) {
        int j1;
        int k1 = 0;
        int i = (abyte0.length + 3 - 1) / 3 * 4;
        char[] ac = new char[i];
        int j = abyte0.length - 2;
        for (j1 = 0; j1 < j; j1 += 3) {
            int k = (abyte0[j1 + 0] & 0xFF) << 16 | (abyte0[j1 + 1] & 0xFF) << 8 | abyte0[j1 + 2] & 0xFF;
            ac[k1++] = StringUtility.base64Char(k >> 18 & 0x3F);
            ac[k1++] = StringUtility.base64Char(k >> 12 & 0x3F);
            ac[k1++] = StringUtility.base64Char(k >> 6 & 0x3F);
            ac[k1++] = StringUtility.base64Char(k & 0x3F);
        }
        if (j1 < abyte0.length - 1) {
            int l = (abyte0[j1 + 0] & 0xFF) << 16 | (abyte0[j1 + 1] & 0xFF) << 8;
            ac[k1++] = StringUtility.base64Char(l >> 18 & 0x3F);
            ac[k1++] = StringUtility.base64Char(l >> 12 & 0x3F);
            ac[k1++] = StringUtility.base64Char(l >> 6 & 0x3F);
            ac[k1++] = 61;
        } else if (j1 < abyte0.length) {
            int i1 = (abyte0[j1 + 0] & 0xFF) << 16;
            ac[k1++] = StringUtility.base64Char(i1 >> 18 & 0x3F);
            ac[k1++] = StringUtility.base64Char(i1 >> 12 & 0x3F);
            ac[k1++] = 61;
            ac[k1++] = 61;
        }
        return new String(ac, 0, k1);
    }

    public static String formatNumber(double number, int decimalDigits) {
        String result;
        if (decimalDigits < 0) {
            throw new IllegalArgumentException("\u5c0f\u6570\u4f4d\u6570decimalDigits\u4e0d\u80fd\u4e3a\u8d1f\u3002");
        }
        if (decimalDigits == 0) {
            result = String.valueOf(Math.round(number));
        } else {
            StringBuffer format = new StringBuffer("0.");
            long l = 1L;
            for (int i = 0; i < decimalDigits; ++i) {
                format.append("0");
                l *= 10L;
            }
            StringBuffer d = new StringBuffer();
            d.append(l).append(".");
            for (int i = 0; i < decimalDigits; ++i) {
                d.append("0");
            }
            d.append("d");
            DecimalFormat decimalFormat = new DecimalFormat(format.toString());
            result = decimalFormat.format((double)Math.round(number * (double)l) / Double.parseDouble(d.toString()));
        }
        return result;
    }

    public static String formatNumber(float number, int decimalDigits) {
        String result;
        if (decimalDigits < 0) {
            throw new IllegalArgumentException("\u5c0f\u6570\u4f4d\u6570decimalDigits\u4e0d\u80fd\u4e3a\u8d1f\u3002");
        }
        if (decimalDigits == 0) {
            result = String.valueOf(Math.round(number));
        } else {
            StringBuffer format = new StringBuffer("0.");
            long l = 1L;
            for (int i = 0; i < decimalDigits; ++i) {
                format.append("0");
                l *= 10L;
            }
            StringBuffer d = new StringBuffer();
            d.append(l).append(".");
            for (int i = 0; i < decimalDigits; ++i) {
                d.append("0");
            }
            d.append("d");
            DecimalFormat decimalFormat = new DecimalFormat(format.toString());
            result = decimalFormat.format((double)Math.round(number * (float)l) / Double.parseDouble(d.toString()));
        }
        return result;
    }

    public static String formatNumber(String number, int decimalDigits) {
        return StringUtility.formatNumber(Double.parseDouble(number), decimalDigits);
    }

    public static final String formatJavaName(String name, boolean firstCharUpperCase) {
        if (name == null || name.length() <= 1) {
            return name;
        }
        StringTokenizer tokenizer = new StringTokenizer(name, "-_");
        StringBuffer tmp = new StringBuffer();
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            tmp.append(Character.toUpperCase(token.charAt(0))).append(token.substring(1));
        }
        if (!firstCharUpperCase) {
            String ch = String.valueOf(Character.toLowerCase(tmp.charAt(0)));
            tmp.replace(0, 1, ch);
        }
        return tmp.toString();
    }

    public static final String getGetMethodName(String name) {
        return "get" + StringUtility.formatJavaName(name, true);
    }

    public static final String getIsMethodName(String name) {
        return "is" + StringUtility.formatJavaName(name, true);
    }

    public static final String getSetMethodName(String name) {
        return "set" + StringUtility.formatJavaName(name, true);
    }

    static {
        StringUtility.newLine[0] = 13;
        StringUtility.newLine[1] = 10;
        newLineString = new String(newLine);
        htmlSpecial = new String[]{"&", "\u00a9", "\u00ae", "\u2122", "\"", "<", ">", newLineString};
        htmlESC = new String[]{"&amp;", "&copy;", "&reg;", "&trade;", "&quot;", "&lt;", "&gt;", "<br>"};
        jsSpecial = new String[]{"\\", "'", "\"", newLineString};
        jsESC = new String[]{"\\\\", "\\'", "\\\"", "\\n"};
        sqlSpecial = new String[]{"'"};
        sqlESC = new String[]{"''"};
    }
}

