/*
 * Decompiled with CFR 0.152.
 */
package com.ds.common.util;

import com.ds.common.logging.ChromeProxy;
import com.ds.common.logging.LogSetpLog;
import com.ds.common.util.CompileJava;
import com.ds.common.util.IOUtility;
import com.ds.common.util.ZipUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;

public class JarCompile {
    public static void compileAndZip(String src, String des, String name, File cfg, List<String> jarContentPath, ChromeProxy log) throws IOException {
        Properties prop = new Properties();
        prop.load(new FileInputStream(cfg));
        String reg = prop.getProperty("reg");
        JarCompile.compileAndZip(src, des, name, reg, jarContentPath, log);
    }

    public static void compileAndZip(String src, String des, String name, String regex, List<String> jarContentPath, ChromeProxy log) throws IOException {
        if (log == null) {
            log = new LogSetpLog();
        }
        File srcDir = new File(src);
        File desDir = new File(des);
        if (!srcDir.isDirectory() || !desDir.isDirectory()) {
            log.printError("\u6e90\u6216\u76ee\u6807\u4f4d\u7f6e\u5fc5\u987b\u662f\u76ee\u5f55");
            throw new IllegalArgumentException("\u6e90\u6216\u76ee\u6807\u4f4d\u7f6e\u5fc5\u987b\u662f\u76ee\u5f55");
        }
        LinkedHashSet<File> notJava = new LinkedHashSet<File>();
        LinkedHashSet<File> javas = new LinkedHashSet<File>();
        log.printLog("\u8bfb\u53d6JAR\u6587\u4ef6", true);
        String tmpSrc = src;
        if (!tmpSrc.endsWith(File.separator)) {
            tmpSrc = tmpSrc + File.separator;
        }
        if (jarContentPath != null) {
            int c = jarContentPath.size();
            for (int i = 0; i < c; ++i) {
                try {
                    String p = jarContentPath.get(i);
                    String[] ss = p.split("!");
                    File newFile = new File(tmpSrc + ss[1]);
                    ZipUtil.getJarContentToFile(ss[0], ss[1], newFile);
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        JarCompile.getFiles(srcDir, notJava, javas, regex);
        File tmpDir = new File(System.getProperty("java.io.tmpdir"), UUID.randomUUID().toString());
        tmpDir.mkdirs();
        log.printLog("\u5f00\u59cb\u7f16\u8bd1...", true);
        HashSet<String> pathSet = new HashSet<String>();
        pathSet.add(tmpDir.getCanonicalPath());
        CompileJava.compile(javas, pathSet, pathSet, log);
        JarCompile.copy(notJava, tmpDir, srcDir.getCanonicalPath());
        ZipUtil.jar(tmpDir.getCanonicalPath(), des + "/" + name);
        log.printLog("\u538b\u7f29\u5b8c\u6210..." + des + "/" + name, true);
        tmpDir.delete();
    }

    private static void copy(Set<File> list, File dir, String srcPre) throws IOException {
        String dirPath = dir.getCanonicalPath();
        for (File f : list) {
            String name = f.getCanonicalPath();
            name = name.replace(srcPre, "");
            File newFile = new File(dirPath + name);
            IOUtility.xcopy(f, newFile);
        }
    }

    private static void getFiles(File file, Set<File> notJava, Set<File> javas, String regex) throws IOException {
        String name = file.getCanonicalPath();
        if (regex == null || "".equals(regex) || name.matches(regex)) {
            if (file.isDirectory()) {
                File[] fs = file.listFiles();
                for (int i = 0; i < fs.length; ++i) {
                    JarCompile.getFiles(fs[i], notJava, javas, regex);
                }
            } else if (file.getName().endsWith(".java")) {
                javas.add(file);
            } else {
                notJava.add(file);
            }
        }
    }

    public static void main(String[] args) throws IOException {
        String src = "E:\\mywork\\tcyx\\javaPro\\test\\src";
        String des = "E:\\mywork\\tcyx\\javaPro\\test\\out";
        File f = new File(src, "abc.properties");
        JarCompile.compileAndZip(src, des, "out.jar", f, null, null);
    }
}

