/*
 * Decompiled with CFR 0.152.
 */
package com.ds.common.util;

import com.ds.config.JDSUtil;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

public class FileClassLoader
extends ClassLoader {
    public String classPath;

    public FileClassLoader(String classPath) {
        this.classPath = classPath;
    }

    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        Class<?> c = null;
        try {
            c = super.loadClass(name);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return c;
    }

    public Class findClass(String className) throws ClassNotFoundException {
        Class<?> theClass = null;
        try {
            theClass = this.loadClass(className);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        if (theClass == null) {
            try {
                String fileName;
                File classFile;
                if (this.classPath == null) {
                    this.classPath = JDSUtil.getJdsRealPath() + "classes";
                }
                if (!(classFile = new File(this.classPath, fileName = className.replace(".", "/") + ".class")).exists()) {
                    throw new ClassNotFoundException(classFile.getPath() + " \u4e0d\u5b58\u5728");
                }
                try {
                    byte[] bs = this.getEntryBytes(classFile);
                    theClass = super.defineClass(className, bs, 0, bs.length);
                    if (theClass.getPackage() == null) {
                        String packageName = className.substring(0, className.lastIndexOf("."));
                        this.definePackage(packageName, "ESDDynPackage", "1.0.0", "ESD", null, null, null, null);
                    }
                }
                catch (Exception ee) {
                    ee.printStackTrace();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return theClass;
    }

    private byte[] getEntryBytes(File file) throws IOException {
        FileInputStream is = new FileInputStream(file);
        ByteArrayOutputStream bos = new ByteArrayOutputStream(((InputStream)is).available());
        int c = 0;
        byte[] buff = new byte[10240];
        while ((c = ((InputStream)is).read(buff)) > 0) {
            bos.write(buff, 0, c);
        }
        ((InputStream)is).close();
        return bos.toByteArray();
    }
}

