/*
 * Decompiled with CFR 0.152.
 */
package com.ds.common.util;

import com.ds.common.cache.Cacheable;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class CaselessStringKeyHashMap<T, K>
extends HashMap<T, K>
implements Cacheable,
Serializable {
    @Override
    public K get(Object key) {
        if (key instanceof String) {
            return (K)super.get(((String)key).toUpperCase());
        }
        return (K)super.get(key);
    }

    @Override
    public void putAll(Map<? extends T, ? extends K> m) {
        for (Map.Entry<T, K> e : m.entrySet()) {
            this.put(e.getKey(), e.getValue());
        }
    }

    @Override
    public K put(T key, K value) {
        if (key instanceof String) {
            return super.put(key.toString().toUpperCase(), value);
        }
        return super.put(key, value);
    }

    @Override
    public boolean containsKey(Object key) {
        if (key instanceof String) {
            return super.containsKey(((String)key).toUpperCase());
        }
        return super.containsKey(key);
    }

    @Override
    public K remove(Object key) {
        if (key instanceof String) {
            return (K)super.remove(key.toString().toUpperCase());
        }
        return (K)super.remove(key);
    }

    @Override
    public int getCachedSize() {
        int size = 0;
        return size += this.toString().length();
    }
}

