/*
 * Decompiled with CFR 0.152.
 */
package com.ds.common.property;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.input.SAXBuilder;
import org.jdom2.output.XMLOutputter;

public class XMLProperties {
    private File file;
    private Document doc;
    private Map propertyCache = new HashMap();
    private Map propertiesCache = new HashMap();

    public void reLoad() {
        this.propertyCache.clear();
        this.propertiesCache.clear();
        try {
            this.init(new FileInputStream(this.file));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    XMLProperties(File file) throws FileNotFoundException {
        this.file = file;
        this.init(new FileInputStream(file));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(InputStream xmlStream) {
        if (xmlStream == null) {
            throw new IllegalArgumentException("Parameter 'xmlStream' can't be null.");
        }
        Reader reader = null;
        try {
            reader = new InputStreamReader(xmlStream, "UTF-8");
            SAXBuilder builder = new SAXBuilder();
            this.doc = builder.build(reader);
        }
        catch (Exception e) {
            System.out.println("Error parsing XML stream file.");
            e.printStackTrace();
        }
        finally {
            try {
                reader.close();
            }
            catch (Exception exception) {}
        }
    }

    XMLProperties() {
    }

    public synchronized String getProperty(String name) {
        String value = (String)this.propertyCache.get(name);
        if (value == null && (value = System.getProperty(name)) != null) {
            this.propertyCache.put(value, name);
        }
        if (value != null) {
            return value;
        }
        String[] propName = this.parsePropertyName(name);
        Element element = this.doc.getRootElement();
        for (int i = 0; i < propName.length; ++i) {
            if ((element = element.getChild(propName[i])) != null) continue;
            return null;
        }
        value = element.getText();
        if ("".equals(value)) {
            return null;
        }
        value = value.trim();
        this.propertyCache.put(name, value);
        return value;
    }

    public synchronized String[] getProperties(String name) {
        String[] values = (String[])this.propertiesCache.get(name);
        if (values != null) {
            return values;
        }
        ArrayList<String> valueList = new ArrayList<String>();
        String[] propName = this.parsePropertyName(name);
        Element element = this.doc.getRootElement();
        for (int i = 0; i < propName.length; ++i) {
            if (i == propName.length - 1) {
                List elements = element.getChildren(propName[i]);
                for (int j = 0; j < elements.size(); ++j) {
                    element = (Element)elements.get(j);
                    String text = element.getText();
                    if ("".equals(text)) continue;
                    text = text.trim();
                    valueList.add(text);
                }
                continue;
            }
            if ((element = element.getChild(propName[i])) != null) continue;
            return null;
        }
        values = valueList.toArray(new String[valueList.size()]);
        this.propertiesCache.put(name, values);
        return values;
    }

    public String[] getChildrenProperties(String parent) {
        String[] propName = this.parsePropertyName(parent);
        Element element = this.doc.getRootElement();
        for (int i = 0; i < propName.length; ++i) {
            if ((element = element.getChild(propName[i])) != null) continue;
            return new String[0];
        }
        List children = element.getChildren();
        int childCount = children.size();
        String[] childrenNames = new String[childCount];
        for (int i = 0; i < childCount; ++i) {
            childrenNames[i] = ((Element)children.get(i)).getName();
        }
        return childrenNames;
    }

    public synchronized void setProperty(String name, String value) {
        if (this.file == null) {
            throw new IllegalArgumentException("XML property can not be modified");
        }
        this.propertyCache.put(name, value);
        String[] propName = this.parsePropertyName(name);
        Element element = this.doc.getRootElement();
        for (int i = 0; i < propName.length; ++i) {
            if (element.getChild(propName[i]) == null) {
                element.addContent((Content)new Element(propName[i]));
            }
            element = element.getChild(propName[i]);
        }
        element.setText(value);
        this.saveProperties();
    }

    public synchronized void deleteProperty(String name) {
        if (this.file == null) {
            throw new IllegalArgumentException("XML property can not be modified");
        }
        this.propertyCache.remove(name);
        String[] propName = this.parsePropertyName(name);
        Element element = this.doc.getRootElement();
        for (int i = 0; i < propName.length - 1; ++i) {
            if ((element = element.getChild(propName[i])) != null) continue;
            return;
        }
        element.removeChild(propName[propName.length - 1]);
        this.saveProperties();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void saveProperties() {
        XMLOutputter outputter;
        Writer writer = null;
        boolean error = false;
        File tempFile = null;
        try {
            tempFile = new File(this.file.getParentFile(), this.file.getName() + ".tmp");
            outputter = new XMLOutputter();
            writer = new OutputStreamWriter((OutputStream)new FileOutputStream(tempFile), "UTF-8");
            outputter.output(this.doc, writer);
        }
        catch (Exception e) {
            e.printStackTrace();
            error = true;
        }
        finally {
            try {
                writer.close();
            }
            catch (Exception e) {
                e.printStackTrace();
                error = true;
            }
        }
        if (!error) {
            error = false;
            if (this.file.exists() && !this.file.delete()) {
                System.out.println("Error deleting property file: " + this.file.getAbsolutePath());
                return;
            }
            try {
                outputter = new XMLOutputter();
                writer = new OutputStreamWriter((OutputStream)new FileOutputStream(this.file), "UTF-8");
                outputter.output(this.doc, writer);
            }
            catch (Exception e) {
                e.printStackTrace();
                error = true;
            }
            finally {
                try {
                    writer.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    error = true;
                }
            }
            if (!error) {
                tempFile.delete();
            }
        }
    }

    private String[] parsePropertyName(String name) {
        ArrayList<String> propName = new ArrayList<String>(5);
        StringTokenizer tokenizer = new StringTokenizer(name, ".");
        while (tokenizer.hasMoreTokens()) {
            propName.add(tokenizer.nextToken());
        }
        return propName.toArray(new String[propName.size()]);
    }
}

