/*
 * Decompiled with CFR 0.152.
 */
package com.ds.common.property;

import com.ds.common.property.XMLProperties;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.HashMap;
import java.util.Map;

public class ConfigFactory {
    private static Map<String, XMLProperties> fileCache = new HashMap<String, XMLProperties>();

    public static XMLProperties getXML(String path) {
        XMLProperties xml = fileCache.get(path);
        if (xml == null) {
            try {
                xml = new XMLProperties(new File(path));
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            fileCache.put(path, xml);
        }
        return xml;
    }

    public static void reLoad() {
        for (String path : fileCache.keySet()) {
            XMLProperties xml = ConfigFactory.getXML(path);
            if (xml == null) continue;
            xml.reLoad();
        }
    }
}

