/*
 * Decompiled with CFR 0.152.
 */
package com.ds.common.expression.function.math;

import com.ds.common.expression.ParseException;
import com.ds.common.expression.function.Function;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;

public class Modulus
extends Function {
    public Modulus() {
        this.numberOfParameters = 2;
    }

    @Override
    public void run(Stack stack) throws ParseException {
        this.checkStack(stack);
        Object param2 = stack.pop();
        Object param1 = stack.pop();
        stack.push(this.mod(param1, param2));
    }

    protected Object mod(Object param1, Object param2) throws ParseException {
        if (param1 == null || param2 == null) {
            return null;
        }
        if (param1 instanceof Number && param2 instanceof Number) {
            double divisor = ((Number)param2).doubleValue();
            double dividend = ((Number)param1).doubleValue();
            double result = dividend % divisor;
            return new Double(result);
        }
        if (param1 instanceof List && param2 instanceof Number) {
            List list = (List)param1;
            ArrayList<Object> result = new ArrayList<Object>();
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                result.add(this.mod(list.get(i), param2));
            }
            return result;
        }
        if (param1 instanceof Number && param2 instanceof List) {
            List list = (List)param2;
            ArrayList<Object> result = new ArrayList<Object>();
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                result.add(this.mod(param1, list.get(i)));
            }
            return result;
        }
        if (param1 instanceof List && param2 instanceof List) {
            List list1 = (List)param1;
            List list2 = (List)param2;
            int n = list1.size();
            ArrayList<Object> temp = new ArrayList<Object>(n);
            if (n != list2.size()) {
                throw new ParseException("Unmatched List parameter size");
            }
            for (int i = 0; i < n; ++i) {
                temp.add(this.mod(list1.get(i), list2.get(i)));
            }
            return temp;
        }
        throw new ParseException("Invalid parameter type");
    }
}

