/*
 * Decompiled with CFR 0.152.
 */
package com.ds.common.expression.function.logical;

import com.ds.common.expression.ParseException;
import com.ds.common.expression.function.Function;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;

public class Comparative
extends Function {
    int id;
    double tolerance;

    public Comparative(int id_in) {
        this.id = id_in;
        this.numberOfParameters = 2;
    }

    @Override
    public void run(Stack stack) throws ParseException {
        this.checkStack(stack);
        Object param2 = stack.pop();
        Object param1 = stack.pop();
        stack.push(this.cmp(param1, param2));
    }

    protected Object cmp(Object param1, Object param2) throws ParseException {
        if (param1 == null || param2 == null) {
            return null;
        }
        if (param1 instanceof Number && param2 instanceof Number) {
            double x = ((Number)param1).doubleValue();
            double y = ((Number)param2).doubleValue();
            return this.cmp(x, y);
        }
        if (param1 instanceof String && param2 instanceof String) {
            return this.cmp((String)param1, (String)param2);
        }
        if (param1 instanceof Number && param2 instanceof List) {
            return this.cmp(((Number)param1).doubleValue(), (List)param2);
        }
        if (param1 instanceof List && param2 instanceof Number) {
            return this.cmp((List)param1, ((Number)param2).doubleValue());
        }
        if (param1 instanceof String && param2 instanceof List) {
            return this.cmp((String)param1, (List)param2);
        }
        if (param1 instanceof List && param2 instanceof String) {
            return this.cmp((List)param1, (String)param2);
        }
        if (param1 instanceof List && param2 instanceof List) {
            return this.cmp((List)param1, (List)param2);
        }
        throw new ParseException("Invalid parameter type");
    }

    protected Object cmp(double x, double y) throws ParseException {
        boolean b;
        switch (this.id) {
            case 0: {
                b = x < y;
                break;
            }
            case 1: {
                b = x > y;
                break;
            }
            case 2: {
                b = x <= y;
                break;
            }
            case 3: {
                b = x >= y;
                break;
            }
            case 4: {
                b = x != y;
                break;
            }
            case 5: {
                b = x == y;
                break;
            }
            default: {
                throw new ParseException("Unknown relational operator");
            }
        }
        return new Boolean(b);
    }

    protected Object cmp(String x, String y) throws ParseException {
        boolean b;
        switch (this.id) {
            case 0: {
                b = x.compareTo(y) < 0;
                break;
            }
            case 1: {
                b = x.compareTo(y) > 0;
                break;
            }
            case 2: {
                b = x.compareTo(y) <= 0;
                break;
            }
            case 3: {
                b = x.compareTo(y) >= 0;
                break;
            }
            case 4: {
                b = !x.equals(y);
                break;
            }
            case 5: {
                b = x.equals(y);
                break;
            }
            default: {
                throw new ParseException("Relational operator type error");
            }
        }
        return new Boolean(b);
    }

    protected List cmp(List x, String y) throws ParseException {
        ArrayList<Object> result = new ArrayList<Object>();
        int n = x.size();
        for (int i = 0; i < n; ++i) {
            Object o = x.get(i);
            if (!(o instanceof String)) {
                throw new ParseException("Invalid parameter type");
            }
            result.add(this.cmp((String)o, y));
        }
        return result;
    }

    protected List cmp(String x, List y) throws ParseException {
        ArrayList<Object> result = new ArrayList<Object>();
        int n = y.size();
        for (int i = 0; i < n; ++i) {
            Object o = y.get(i);
            if (!(o instanceof String)) {
                throw new ParseException("Invalid parameter type");
            }
            result.add(this.cmp(x, (String)o));
        }
        return result;
    }

    protected List cmp(List x, double y) throws ParseException {
        ArrayList<Object> result = new ArrayList<Object>();
        int n = x.size();
        for (int i = 0; i < n; ++i) {
            Object o = x.get(i);
            if (!(o instanceof Number)) {
                throw new ParseException("Invalid parameter type");
            }
            result.add(this.cmp(((Number)o).doubleValue(), y));
        }
        return result;
    }

    protected List cmp(double x, List y) throws ParseException {
        ArrayList<Object> result = new ArrayList<Object>();
        int n = y.size();
        for (int i = 0; i < n; ++i) {
            Object o = y.get(i);
            if (!(o instanceof Number)) {
                throw new ParseException("Invalid parameter type");
            }
            result.add(this.cmp(x, ((Number)o).doubleValue()));
        }
        return result;
    }

    protected List cmp(List x, List y) throws ParseException {
        if (x.size() != y.size()) {
            throw new ParseException("Unmatched List parameter size");
        }
        ArrayList<Object> result = new ArrayList<Object>();
        int n = x.size();
        for (int i = 0; i < n; ++i) {
            Object o = x.get(i);
            Object oo = y.get(i);
            result.add(this.cmp(o, oo));
        }
        return result;
    }
}

