/*
 * Decompiled with CFR 0.152.
 */
package com.ds.common.expression.function;

import com.ds.common.expression.ParseException;
import com.ds.common.expression.function.Function;
import java.lang.reflect.Method;
import java.util.Stack;

public abstract class AbstractFunction<T>
extends Function {
    private static final String METHODNAME = "perform";
    public Method method;

    public Method getPerformMethod() {
        return this.method;
    }

    public AbstractFunction() {
        Method[] methods = this.getClass().getDeclaredMethods();
        for (int k = 0; k < methods.length; ++k) {
            Method method = methods[k];
            if (!method.getName().equals(METHODNAME)) continue;
            this.method = methods[k];
            this.numberOfParameters = method.getParameterTypes().length;
        }
    }

    @Override
    public void run(Stack stack) throws ParseException {
        if (this.method == null) {
            throw new ParseException("[" + this.getClass().getName() + "]\u9700\u8981\u5b9e\u73b0[" + METHODNAME + "]\u65b9\u6cd5");
        }
        this.checkStack(stack);
        Object[] objs = new Object[this.method.getParameterTypes().length];
        for (int k = objs.length; k > 0; --k) {
            objs[k - 1] = stack.pop();
        }
        try {
            Object obj = this.method.invoke((Object)this, objs);
            stack.push(obj);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

