/*
 * Decompiled with CFR 0.152.
 */
package com.ds.common.expression;

import com.ds.common.expression.Token;
import java.io.PrintStream;
import java.io.PrintWriter;

public class ParseException
extends Exception {
    private Throwable cause;
    protected boolean specialConstructor;
    public Token currentToken;
    public int[][] expectedTokenSequences;
    public String[] tokenImage;
    protected String eol = System.getProperty("line.separator", "\n");

    public ParseException(Token currentTokenVal, int[][] expectedTokenSequencesVal, String[] tokenImageVal) {
        super("");
        this.specialConstructor = true;
        this.currentToken = currentTokenVal;
        this.expectedTokenSequences = expectedTokenSequencesVal;
        this.tokenImage = tokenImageVal;
    }

    public ParseException() {
        this.specialConstructor = false;
    }

    public ParseException(String message) {
        super(message);
        this.specialConstructor = false;
    }

    public ParseException(String message, Throwable t) {
        super(message);
        this.cause = t;
    }

    public ParseException(Throwable t) {
        this.cause = t;
    }

    @Override
    public String getMessage() {
        if (this.cause != null) {
            return super.getMessage() + "\r\n" + this.cause.getMessage();
        }
        if (!this.specialConstructor) {
            return super.getMessage();
        }
        String expected = "";
        int maxSize = 0;
        for (int i = 0; i < this.expectedTokenSequences.length; ++i) {
            if (maxSize < this.expectedTokenSequences[i].length) {
                maxSize = this.expectedTokenSequences[i].length;
            }
            for (int j = 0; j < this.expectedTokenSequences[i].length; ++j) {
                expected = expected + this.tokenImage[this.expectedTokenSequences[i][j]] + " ";
            }
            if (this.expectedTokenSequences[i][this.expectedTokenSequences[i].length - 1] != 0) {
                expected = expected + "...";
            }
            expected = expected + this.eol + "    ";
        }
        String retval = "Encountered \"";
        Token tok = this.currentToken.next;
        for (int i = 0; i < maxSize; ++i) {
            if (i != 0) {
                retval = retval + " ";
            }
            if (tok.kind == 0) {
                retval = retval + this.tokenImage[0];
                break;
            }
            retval = retval + this.add_escapes(tok.image);
            tok = tok.next;
        }
        retval = retval + "\" at line " + this.currentToken.next.beginLine + ", column " + this.currentToken.next.beginColumn;
        retval = retval + "." + this.eol;
        retval = this.expectedTokenSequences.length == 1 ? retval + "Was expecting:" + this.eol + "    " : retval + "Was expecting one of:" + this.eol + "    ";
        retval = retval + expected;
        return retval;
    }

    public String getErrorInfo() {
        if (!this.specialConstructor) {
            try {
                return super.getMessage() + " at column " + this.currentToken.next.beginColumn + ".";
            }
            catch (Exception e) {
                return super.getMessage();
            }
        }
        String expected = "";
        int maxSize = 0;
        for (int i = 0; i < this.expectedTokenSequences.length; ++i) {
            if (maxSize < this.expectedTokenSequences[i].length) {
                maxSize = this.expectedTokenSequences[i].length;
            }
            for (int j = 0; j < this.expectedTokenSequences[i].length; ++j) {
                expected = expected + this.tokenImage[this.expectedTokenSequences[i][j]] + " ";
            }
            if (this.expectedTokenSequences[i][this.expectedTokenSequences[i].length - 1] != 0) {
                expected = expected + "...";
            }
            expected = expected + this.eol + "    ";
        }
        String retval = "Unexpected \"";
        Token tok = this.currentToken.next;
        for (int i = 0; i < maxSize; ++i) {
            if (i != 0) {
                retval = retval + " ";
            }
            if (tok.kind == 0) {
                retval = retval + this.tokenImage[0];
                break;
            }
            retval = retval + this.add_escapes(tok.image);
            tok = tok.next;
        }
        retval = retval + "\" at column " + this.currentToken.next.beginColumn + ".";
        return retval;
    }

    public int getColumn() {
        try {
            return this.currentToken.next.beginColumn;
        }
        catch (Exception e) {
            return 0;
        }
    }

    public int getLine() {
        try {
            return this.currentToken.next.beginLine;
        }
        catch (Exception e) {
            return 0;
        }
    }

    protected String add_escapes(String str) {
        StringBuffer retval = new StringBuffer();
        block11: for (int i = 0; i < str.length(); ++i) {
            switch (str.charAt(i)) {
                case '\u0000': {
                    continue block11;
                }
                case '\b': {
                    retval.append("\\b");
                    continue block11;
                }
                case '\t': {
                    retval.append("\\t");
                    continue block11;
                }
                case '\n': {
                    retval.append("\\n");
                    continue block11;
                }
                case '\f': {
                    retval.append("\\f");
                    continue block11;
                }
                case '\r': {
                    retval.append("\\r");
                    continue block11;
                }
                case '\"': {
                    retval.append("\\\"");
                    continue block11;
                }
                case '\'': {
                    retval.append("\\'");
                    continue block11;
                }
                case '\\': {
                    retval.append("\\\\");
                    continue block11;
                }
                default: {
                    char ch = str.charAt(i);
                    if (ch < ' ' || ch > '~') {
                        String s = "0000" + Integer.toString(ch, 16);
                        retval.append("\\u" + s.substring(s.length() - 4, s.length()));
                        continue block11;
                    }
                    retval.append(ch);
                }
            }
        }
        return retval.toString();
    }

    @Override
    public String toString() {
        return this.getMessage();
    }

    @Override
    public void printStackTrace() {
        this.printStackTrace(System.err);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void printStackTrace(PrintStream ps) {
        PrintStream printStream = ps;
        synchronized (printStream) {
            super.printStackTrace(ps);
            if (this.cause != null) {
                ps.println("--- Nested Exception ---");
                this.cause.printStackTrace(ps);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void printStackTrace(PrintWriter pw) {
        PrintWriter printWriter = pw;
        synchronized (printWriter) {
            super.printStackTrace(pw);
            if (this.cause != null) {
                pw.println("--- Nested Exception ---");
                this.cause.printStackTrace(pw);
            }
        }
    }
}

