/*
 * Decompiled with CFR 0.152.
 */
package com.ds.common.cache.redis;

import com.ds.common.cache.Cache;
import com.ds.common.cache.CacheSizes;
import com.ds.common.cache.Cacheable;
import com.ds.common.cache.redis.RedisPoolUtil;
import com.ds.common.logging.Log;
import com.ds.common.logging.LogFactory;
import com.ds.common.util.Constants;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import redis.clients.jedis.Jedis;

public class RedisCache<K, V>
implements Cache<K, V> {
    private final Log logger = LogFactory.getLog(Constants.COMMON_CONFIGKEY, RedisCache.class);
    private final String configKey;
    protected int maxCacheSize;
    protected int cacheSize = 0;
    protected long maxLifetime = 1800000L;
    protected long cacheHits;
    protected long cacheMisses = 0L;
    protected String name;
    private boolean isFull;
    protected boolean isStopPutWhenFull;
    private final String serverURL = "192.168.80.64";

    public RedisCache(String configKey, String name, int maxSize, Long maxLifetime) {
        this.name = name;
        this.configKey = configKey;
        if (name.length() > 64) {
            Throwable thrwo = new Throwable("name length >64!");
            thrwo.printStackTrace();
        }
        this.maxCacheSize = maxSize;
        if (maxLifetime != null) {
            this.maxLifetime = maxLifetime;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void clear() {
        Set keySet = this.keySet();
        if (keySet.size() > 0) {
            Jedis jedis = null;
            try {
                jedis = this.getClient();
                this.logger.info("clear cache [" + this.configKey + "]" + this.getName() + " size=" + keySet.size());
                jedis.del(keySet.toArray(new String[keySet.size()]));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                RedisPoolUtil.getInstance(this.configKey).closeConn(jedis);
            }
        }
    }

    @Override
    public long getCacheHits() {
        return 0L;
    }

    @Override
    public long getCacheMisses() {
        return 0L;
    }

    @Override
    public int getCacheSize() {
        return 0;
    }

    @Override
    public int getMaxCacheSize() {
        return this.maxCacheSize;
    }

    @Override
    public long getMaxLifetime() {
        return this.maxLifetime;
    }

    @Override
    public K getName() {
        return (K)this.name;
    }

    @Override
    public void setMaxCacheSize(int maxSize) {
        Throwable thrwo = new Throwable();
        thrwo.printStackTrace();
    }

    @Override
    public void setMaxLifetime(long maxLifetime) {
        this.maxLifetime = maxLifetime;
    }

    @Override
    public void setStopPutWhenFull(boolean flag) {
        Throwable thrwo = new Throwable();
        thrwo.printStackTrace();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsKey(Object key) {
        Jedis jedis = this.getClient();
        try {
            String object = jedis.get(key.toString());
            boolean bl = object != null;
            return bl;
        }
        catch (Exception e) {
            e.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            RedisPoolUtil.getInstance(this.configKey).closeConn(jedis);
        }
    }

    @Override
    public boolean containsValue(Object value) {
        Throwable thrwo = new Throwable("\u672a\u5b9e\u73b0\uff01");
        thrwo.printStackTrace();
        return false;
    }

    @Override
    public Set entrySet() {
        Throwable thrwo = new Throwable();
        thrwo.printStackTrace();
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V get(Object key) {
        Object object = key;
        synchronized (object) {
            Object obj = null;
            if (key != null) {
                String realkey = key.toString();
                if (!realkey.startsWith(this.name + "[")) {
                    realkey = this.name + "[" + key.toString() + "]";
                }
                Jedis jedis = this.getClient();
                try {
                    byte[] byt = jedis.get(realkey.getBytes());
                    if (byt != null) {
                        obj = this.unserizlize(byt);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.logger.error("get key faild,key is " + key);
                }
                finally {
                    RedisPoolUtil.getInstance(this.configKey).closeConn(jedis);
                }
            }
            return (V)obj;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isEmpty() {
        boolean empty = true;
        Jedis jedis = this.getClient();
        try {
            Set keySet = jedis.keys("*");
            empty = keySet.isEmpty();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            RedisPoolUtil.getInstance(this.configKey).closeConn(jedis);
        }
        return empty;
    }

    @Override
    public synchronized Set keySet() {
        HashSet<String> keySet = new HashSet<String>();
        keySet.addAll(this.getKeys());
        return keySet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized V put(K key, V value) {
        if (null == key) {
            return null;
        }
        if (key != null) {
            String realkey = key.toString();
            if (!realkey.startsWith(this.name + "[")) {
                realkey = this.name + "[" + key.toString() + "]";
            }
            if (value != null) {
                Jedis jedis = this.getClient();
                try {
                    jedis.psetex(realkey.getBytes(), this.maxLifetime, this.serialize(value));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                finally {
                    RedisPoolUtil.getInstance(this.configKey).closeConn(jedis);
                }
            } else {
                this.remove(realkey);
            }
        }
        return value;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        for (K key : map.keySet()) {
            if (key == null) continue;
            V value = map.get(key);
            this.put(key, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V remove(Object key) {
        Object obj = null;
        if (key != null) {
            Jedis jedis = this.getClient();
            try {
                String realkey = key.toString();
                obj = jedis.get(realkey);
                if (obj != null) {
                    obj = jedis.del(realkey);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                RedisPoolUtil.getInstance(this.configKey).closeConn(jedis);
            }
        }
        return (V)obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size() {
        int size = 0;
        Jedis jedis = this.getClient();
        try {
            Set keys = jedis.keys("*");
            size = keys.size();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            RedisPoolUtil.getInstance(this.configKey).closeConn(jedis);
        }
        return size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection values() {
        this.logger.info("----- RedisCache-values()--in -----");
        ArrayList<Object> values = new ArrayList<Object>();
        Set keySet = this.keySet();
        Jedis jedis = this.getClient();
        try {
            for (String key : keySet) {
                Object obj;
                try {
                    obj = this.unserizlize(jedis.get(key.getBytes()));
                }
                catch (Exception e) {
                    e.printStackTrace();
                    continue;
                }
                values.add(obj);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            RedisPoolUtil.getInstance(this.configKey).closeConn(jedis);
        }
        return values;
    }

    public Jedis getClient() {
        try {
            return RedisPoolUtil.getInstance(this.configKey).getClient();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.error("-----getJedisClient from RedisUtil failed");
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getKeys() {
        HashSet<String> stringKeys = null;
        Jedis jedis = this.getClient();
        try {
            Set keys = jedis.keys(this.name + "\\[*");
            stringKeys = new HashSet<String>();
            if (!keys.isEmpty()) {
                for (String k : keys) {
                    stringKeys.add(k);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            RedisPoolUtil.getInstance(this.configKey).closeConn(jedis);
        }
        return stringKeys;
    }

    protected int calculateSize(Object object) {
        if (object instanceof Cacheable) {
            return ((Cacheable)object).getCachedSize();
        }
        if (object instanceof DataInputStream) {
            int size = 1;
            try {
                size = ((DataInputStream)object).available();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return size;
        }
        if (object instanceof Long) {
            return CacheSizes.sizeOfLong();
        }
        if (object instanceof Integer) {
            return CacheSizes.sizeOfObject() + CacheSizes.sizeOfInt();
        }
        if (object instanceof Boolean) {
            return CacheSizes.sizeOfObject() + CacheSizes.sizeOfBoolean();
        }
        if (object instanceof long[]) {
            long[] array = (long[])object;
            return CacheSizes.sizeOfObject() + array.length * CacheSizes.sizeOfLong();
        }
        int size = 1;
        try {
            NullOutputStream out = new NullOutputStream();
            ObjectOutputStream outObj = new ObjectOutputStream(out);
            outObj.writeObject(object);
            size = out.size();
        }
        catch (IOException ioe) {
            size = 1024;
        }
        return size;
    }

    public byte[] serialize(Object obj) {
        ObjectOutputStream oos = null;
        ByteArrayOutputStream bos = null;
        if (obj == null) {
            return null;
        }
        try {
            bos = new ByteArrayOutputStream();
            oos = new ObjectOutputStream(bos);
            oos.writeObject(obj);
            byte[] byt = bos.toByteArray();
            return byt;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public Object unserizlize(byte[] byt) {
        if (byt == null) {
            return null;
        }
        ObjectInputStream oii = null;
        ByteArrayInputStream bis = null;
        bis = new ByteArrayInputStream(byt);
        try {
            oii = new ObjectInputStream(bis);
            Object obj = oii.readObject();
            return obj;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static class NullOutputStream
    extends OutputStream {
        int size = 0;

        private NullOutputStream() {
        }

        @Override
        public void write(int b) throws IOException {
            ++this.size;
        }

        @Override
        public void write(byte[] b) throws IOException {
            this.size += b.length;
        }

        @Override
        public void write(byte[] b, int off, int len) {
            this.size += len;
        }

        public int size() {
            return this.size;
        }
    }
}

