/*
 * Decompiled with CFR 0.152.
 */
package com.ds.cluster.udp;

import com.ds.cluster.udp.ClusterClient;
import com.ds.common.logging.Log;
import com.ds.common.logging.LogFactory;
import com.ds.jds.core.esb.util.ActionContext;
import com.ds.jds.core.esb.util.CompoundRoot;
import com.ds.msg.Msg;
import com.ds.server.JDSServer;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class CMDControl
implements Callable<JDSServer> {
    private static Map<String, Msg> msgMap = new HashMap<String, Msg>();
    private Msg msg;
    private static final Log logger = LogFactory.getLog("JDS", CMDControl.class);
    static ReadWriteLock lock = new ReentrantReadWriteLock();

    public CMDControl(Msg msg) {
        this.msg = msg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JDSServer call() throws Exception {
        JDSServer server = JDSServer.getInstance();
        if (!msgMap.containsKey(this.msg.getId())) {
            try {
                ClusterClient client = JDSServer.getClusterClient();
                if (lock.readLock().tryLock(30L, TimeUnit.SECONDS)) {
                    CompoundRoot root = ActionContext.getContext().getValueStack().getRoot();
                    if (!root.contains(client)) {
                        root.push(client);
                    }
                    client.updateTaskStatus(this.msg.getId(), "READED");
                } else {
                    client.reboot();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                lock.readLock().unlock();
                msgMap.put(this.msg.getId(), this.msg);
            }
            if (this.msg != null) {
                // empty if block
            }
        }
        return server;
    }
}

