/*
 * Decompiled with CFR 0.152.
 */
package com.ds.cluster.event;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ds.cluster.event.ClusterEventTypeEnums;
import com.ds.cluster.event.ServerEvent;
import com.ds.cluster.event.ServerListener;
import com.ds.cluster.event.ServiceEvent;
import com.ds.cluster.event.ServiceEventEnums;
import com.ds.cluster.event.ServiceListener;
import com.ds.cluster.udp.ClusterEvent;
import com.ds.common.JDSException;
import com.ds.common.cache.CacheManagerFactory;
import com.ds.common.logging.Log;
import com.ds.common.logging.LogFactory;
import com.ds.common.util.ClassUtility;
import com.ds.context.JDSActionContext;
import com.ds.engine.event.JDSEvent;
import com.ds.engine.event.JDSEventDispatcher;
import com.ds.engine.event.JDSListener;
import com.ds.enums.ServerEventEnums;
import com.ds.esb.config.manager.EsbBeanFactory;
import com.ds.esb.config.manager.ExpressionTempBean;
import com.ds.esb.config.manager.ServiceBean;
import com.ds.server.JDSServer;
import com.ds.server.SubSystem;
import com.ds.server.ct.CtSubSystem;
import com.ds.vfs.VFSException;
import com.ds.web.JSONGenSetInvocationHandler;
import com.ds.web.client.ListenerTempAnnotationProxy;
import com.ds.web.util.JSONGenUtil;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.cglib.proxy.Callback;
import net.sf.cglib.proxy.Enhancer;

public class ClusterEventControl
implements JDSEventDispatcher {
    private static final Log logger = LogFactory.getLog("JDS", ClusterEventControl.class);
    private static ClusterEventControl instance = null;
    public static Map<Class, List<ExpressionTempBean>> listenerMap = new HashMap<Class, List<ExpressionTempBean>>();
    public static Map<String, Long> dataEventMap = CacheManagerFactory.createCache("org", "ClusterEventTiemMap", 0xA00000, 86400000L);
    public static Map<String, ExpressionTempBean> listenerBeanMap = new HashMap<String, ExpressionTempBean>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ClusterEventControl getInstance() {
        if (instance != null) return instance;
        Class<ClusterEventControl> clazz = ClusterEventControl.class;
        synchronized (ClusterEventControl.class) {
            if (instance != null) return instance;
            instance = new ClusterEventControl();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    protected ClusterEventControl() {
        listenerBeanMap.putAll(ListenerTempAnnotationProxy.getListenerBeanMap());
        List<? extends ServiceBean> esbBeans = EsbBeanFactory.getInstance().loadAllServiceBean();
        for (ServiceBean serviceBean : esbBeans) {
            if (!(serviceBean instanceof ExpressionTempBean)) continue;
            listenerBeanMap.put(serviceBean.getId(), (ExpressionTempBean)serviceBean);
        }
        ClusterEventControl.getListenerByType(ServiceListener.class);
        ClusterEventControl.getListenerByType(ServerListener.class);
    }

    public void dispatchEvent(JDSEvent event) throws JDSException {
        if (event instanceof ServerEvent) {
            this.dispatchServerEvent((ServerEvent)event);
        } else if (event instanceof ServiceEvent) {
            this.dispatchServiceEvent((ServiceEvent)event);
        }
    }

    public void dispatchServerEvent(ServerEvent event) throws JDSException {
        ServerEvent fe = event;
        Object server = fe.getSource();
        if (server != null) {
            String key = event.getID().getMethod() + server.getSysId();
            Long checkOutTime = dataEventMap.get(key);
            if (checkOutTime == null || System.currentTimeMillis() - checkOutTime > 1000L) {
                dataEventMap.put(key, System.currentTimeMillis());
                this.repeatEvent(event, key);
            }
            List<JDSListener> listeners = ClusterEventControl.getListenerByType(ServerListener.class);
            for (int k = 0; k < listeners.size(); ++k) {
                ServerListener serverListener = (ServerListener)listeners.get(k);
                ClusterEventControl.dispatchServerEvent(event, (ServerListener)listeners.get(k));
            }
        }
    }

    public void dispatchServiceEvent(ServiceEvent event) throws JDSException {
        if (event.getSource() != null) {
            String key = event.getID().getMethod() + event.getSource().getId();
            Long checkOutTime = dataEventMap.get(key);
            if (checkOutTime == null || System.currentTimeMillis() - checkOutTime > 500L) {
                dataEventMap.put(key, System.currentTimeMillis());
                this.repeatEvent(event, key);
            }
            List<JDSListener> listeners = ClusterEventControl.getListenerByType(ServiceListener.class);
            for (int k = 0; k < listeners.size(); ++k) {
                ServiceListener ServiceListener2 = (ServiceListener)listeners.get(k);
                ClusterEventControl.dispatchServiceEvent(event, (ServiceListener)listeners.get(k));
            }
            ServiceListener customerServiceListener = (ServiceListener)event.getContextMap().get("ServiceListener");
            if (customerServiceListener != null) {
                ClusterEventControl.dispatchServiceEvent(event, customerServiceListener);
            }
        }
    }

    public boolean repeatEvent(JDSEvent event, String msgId) throws JDSException {
        Boolean isSend = false;
        if (JDSServer.getInstance().getCurrServerBean().getId().equals(event.getSystemCode())) {
            ClusterEventTypeEnums type = ClusterEventTypeEnums.fromEventClass(event.getClass());
            ClusterEvent clusterEvent = new ClusterEvent();
            clusterEvent.setEventId(event.getID().getMethod());
            if (event.getSource() instanceof String || event.getSource() instanceof Integer || event.getSource() instanceof Double) {
                clusterEvent.setSourceJson(event.getSource().toString());
            } else {
                String source = JSON.toJSONString(event.getSource());
                clusterEvent.setSourceJson(source);
            }
            clusterEvent.setMsgId(msgId);
            clusterEvent.setSessionId(JDSServer.getInstance().getAdminUser().getSessionId());
            clusterEvent.setSystemCode(JDSServer.getInstance().getCurrServerBean().getId());
            clusterEvent.setEventName(type.getEventName());
            clusterEvent.setExpression("$RepeatClusterEvent");
            String eventStr = JSON.toJSONString((Object)clusterEvent);
            isSend = JDSServer.getClusterClient().getUDPClient().send(eventStr);
            logger.info("success repeatEvent [" + isSend + "]" + event.getID());
        }
        return isSend;
    }

    public <T> void dispatchClusterEvent(String objStr, String eventName, String event, String systemCode) throws JDSException {
        ClusterEventTypeEnums type = ClusterEventTypeEnums.fromName(eventName);
        switch (type) {
            case ServiceEvent: {
                Class jsonClass = JSONGenUtil.fillSetMethod(ServiceBean.class);
                Object inst = JSONObject.parseObject((String)objStr, (Class)jsonClass);
                ServiceBean proxyObj = (ServiceBean)Enhancer.create(Object.class, (Class[])new Class[]{ServiceBean.class}, (Callback)new JSONGenSetInvocationHandler(inst));
                ServiceEvent<ServiceBean> ServiceEvent2 = new ServiceEvent<ServiceBean>(proxyObj, ServiceEventEnums.fromMethod(event), systemCode);
                this.dispatchServiceEvent(ServiceEvent2);
                break;
            }
            case ServerEvent: {
                Class jsonClass = JSONGenUtil.fillSetMethod(SubSystem.class);
                Object inst = JSONObject.parseObject((String)objStr, (Class)jsonClass);
                SubSystem systemObj = (SubSystem)Enhancer.create(Object.class, (Class[])new Class[]{SubSystem.class}, (Callback)new JSONGenSetInvocationHandler(inst));
                CtSubSystem system = new CtSubSystem(systemObj);
                ServerEvent<CtSubSystem> ServerEvent2 = new ServerEvent<CtSubSystem>(system, ServerEventEnums.fromMethod(event), systemCode);
                this.dispatchServerEvent(ServerEvent2);
                break;
            }
        }
    }

    public static List<ExpressionTempBean> getListenerTempBeanByType(Class<? extends EventListener> listenerClass) {
        ArrayList listeners = new ArrayList();
        Set<Map.Entry<String, ExpressionTempBean>> tempEntry = listenerBeanMap.entrySet();
        List<ExpressionTempBean> tempLst = listenerMap.get(listenerClass);
        if (tempLst == null || tempLst.isEmpty()) {
            tempLst = new ArrayList<ExpressionTempBean>();
            for (Map.Entry<String, ExpressionTempBean> entry : tempEntry) {
                ExpressionTempBean bean = entry.getValue();
                String classType = bean.getClazz();
                Class clazz = null;
                try {
                    clazz = ClassUtility.loadClass(classType);
                }
                catch (ClassNotFoundException e) {
                    continue;
                }
                if (!listenerClass.isAssignableFrom(clazz)) continue;
                tempLst.add(bean);
            }
            listenerMap.put(listenerClass, tempLst);
        }
        return tempLst;
    }

    private static List<JDSListener> getListenerByType(Class<? extends EventListener> listenerClass) {
        List<ExpressionTempBean> tempLst = ClusterEventControl.getListenerTempBeanByType(listenerClass);
        ArrayList<JDSListener> listeners = new ArrayList<JDSListener>();
        for (ExpressionTempBean tempBean : tempLst) {
            JDSListener listener = (JDSListener)JDSActionContext.getActionContext().Par("$" + tempBean.getId());
            if (listener == null) continue;
            listeners.add(listener);
        }
        return listeners;
    }

    private static void dispatchServiceEvent(ServiceEvent event, ServiceListener listener) {
        try {
            switch (event.getID()) {
                case addService: {
                    listener.addService(event);
                    break;
                }
                case delService: {
                    listener.delService(event);
                    break;
                }
                case updateService: {
                    listener.updateService(event);
                    break;
                }
                case addJar: {
                    listener.addJar(event);
                    break;
                }
                default: {
                    throw new JDSException("Unsupport file event type: " + event.getID(), 33);
                }
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
            logger.warn("Listener execute failed!", e);
        }
    }

    private static void dispatchServerEvent(ServerEvent event, ServerListener listener) {
        try {
            switch (event.getID()) {
                case serverStarting: {
                    listener.serverStarting(event);
                    break;
                }
                case serverStarted: {
                    listener.serverStarted(event);
                    break;
                }
                case serverStopping: {
                    listener.serverStopping(event);
                    break;
                }
                case serverStopped: {
                    listener.serverStopped(event);
                    break;
                }
                case systemActivating: {
                    listener.systemActivating(event);
                    break;
                }
                case systemActivated: {
                    listener.systemActivated(event);
                    break;
                }
                case systemFreezing: {
                    listener.systemFreezing(event);
                    break;
                }
                case systemFreezed: {
                    listener.systemFreezed(event);
                    break;
                }
                case systemSaving: {
                    listener.systemSaving(event);
                    break;
                }
                case systemSaved: {
                    listener.systemSaved(event);
                    break;
                }
                case systemDeleting: {
                    listener.systemDeleting(event);
                    break;
                }
                case systemDeleted: {
                    listener.systemDeleted(event);
                    break;
                }
                default: {
                    throw new VFSException("Unsupport folder event type: " + event.getID(), 33);
                }
            }
        }
        catch (Throwable e) {
            logger.warn("Listener execute failed!", e);
        }
    }
}

