/*
 * Decompiled with CFR 0.152.
 */
package com.ds.cluster;

import com.ds.common.property.ConfigFactory;
import com.ds.common.property.XMLProperties;
import com.ds.config.JDSConfig;
import java.io.File;

public class ServerServiceConfig {
    private XMLProperties properties = null;
    private String fileName = "expressiontemplet_config.xml";
    private static ServerServiceConfig serviceConfig;

    public static ServerServiceConfig getServiceConfig(String fileName) {
        if (serviceConfig == null || !ServerServiceConfig.serviceConfig.fileName.equals(fileName)) {
            serviceConfig = new ServerServiceConfig(fileName);
        }
        return serviceConfig;
    }

    public void reLoad() {
        this.properties = null;
        this.init();
    }

    public ServerServiceConfig(String fileName) {
        if (fileName != null) {
            this.fileName = fileName;
        }
        this.properties = null;
    }

    public String getValue(String name) {
        this.init();
        if (this.properties != null) {
            return this.properties.getProperty(name);
        }
        return null;
    }

    public String[] getValues(String name) {
        this.init();
        if (this.properties != null) {
            return this.properties.getProperties(name);
        }
        return new String[0];
    }

    private void init() {
        if (this.properties == null) {
            File engineConfigFile = new File(this.fileName);
            if (!engineConfigFile.exists()) {
                engineConfigFile = new File(JDSConfig.Config.configPath(), this.fileName);
            }
            if (!engineConfigFile.exists()) {
                engineConfigFile = new File(JDSConfig.Config.publicConfigPath(), this.fileName);
            }
            if (!engineConfigFile.exists()) {
                String path = JDSConfig.getAbsolutePath(File.separator);
                engineConfigFile = new File(path + this.fileName);
            }
            this.properties = ConfigFactory.getXML(engineConfigFile.getAbsolutePath());
        }
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }
}

