/*
 * Decompiled with CFR 0.152.
 */
package com.ds.cluster;

import com.alibaba.fastjson.annotation.JSONField;
import com.ds.context.JDSActionContext;
import com.ds.esb.config.ContextType;
import com.ds.esb.config.manager.EsbBeanFactory;
import com.ds.esb.config.manager.ServiceBean;
import com.ds.server.SubSystem;
import com.ds.server.eumus.ConfigCode;
import com.ds.server.eumus.SystemNodeType;
import com.ds.server.eumus.SystemStatus;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class ServerNode {
    String maxconnection = "2000";
    String minconnection = "200";
    String timeout = "60";
    public SystemStatus status = SystemStatus.ONLINE;
    public Integer checkTimes = 0;
    public List<String> onLinePersonIds;
    public List<String> defPersonIds;
    public Set<String> adminPersonIds;
    public String id;
    public String name;
    public String url;
    public String desc;
    SystemNodeType type = SystemNodeType.SUB;
    ConfigCode configCode;
    String userexpression = "true";
    @JSONField(serialize=false)
    public Set<ServiceBean> services;

    public ServerNode() {
    }

    public ServerNode(SubSystem subSystem) {
        this.id = subSystem.getSysId();
        this.url = subSystem.getUrl();
        this.name = subSystem.getName();
        this.adminPersonIds = new HashSet<String>();
        String adminPersonId = subSystem.getAdminId();
        if (adminPersonId == null) {
            adminPersonId = subSystem.getEnname() + "admin";
        }
        if (adminPersonId.indexOf(";") > -1) {
            String[] personIds;
            for (String personId : personIds = adminPersonId.split(";")) {
                this.adminPersonIds.add(personId);
            }
        } else {
            this.adminPersonIds.add(adminPersonId);
        }
        this.configCode = subSystem.getConfigname();
    }

    public ConfigCode getConfigCode() {
        return this.configCode;
    }

    public void setConfigCode(ConfigCode configCode) {
        this.configCode = configCode;
    }

    public Set<? extends ServiceBean> getServices() {
        if (this.services == null) {
            this.services = new HashSet<ServiceBean>();
            List<? extends ServiceBean> allservices = EsbBeanFactory.getInstance().loadAllServiceBean();
            for (ServiceBean serviceBean : allservices) {
                if (!serviceBean.getDataType().equals(ContextType.Server) || serviceBean.getServerUrl() == null || !serviceBean.getServerUrl().equals(this.getUrl())) continue;
                this.services.add(serviceBean);
            }
        }
        return this.services;
    }

    public void setAdminPersonIds(Set<String> adminPersonIds) {
        this.adminPersonIds = adminPersonIds;
    }

    public void setServices(Set<ServiceBean> services) {
        this.services = services;
    }

    public Set<String> getAdminPersonIds() {
        return this.adminPersonIds;
    }

    public String getDesc() {
        return this.desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public String getAdminPersonId() {
        if (this.getAdminPersonIds().size() > 0) {
            return this.getAdminPersonIds().iterator().next();
        }
        return null;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getMaxconnection() {
        return this.maxconnection;
    }

    public void setMaxconnection(String maxconnection) {
        this.maxconnection = maxconnection;
    }

    public String getTimeout() {
        return this.timeout;
    }

    public void setTimeout(String timeout) {
        this.timeout = timeout;
    }

    public String getMinconnection() {
        return this.minconnection;
    }

    public void setMinconnection(String minconnection) {
        this.minconnection = minconnection;
    }

    public String getName() {
        return this.name;
    }

    public String getUrl() {
        return this.url;
    }

    public SystemStatus getStatus() {
        return this.status;
    }

    public SystemNodeType getType() {
        return this.type;
    }

    public List<String> getOnLinePersonIds() {
        if (this.onLinePersonIds == null) {
            this.onLinePersonIds = new ArrayList<String>();
        }
        return this.onLinePersonIds;
    }

    public void setOnLinePersonIds(List<String> onLinePersonIds) {
        this.onLinePersonIds = onLinePersonIds;
    }

    public List<String> par() {
        if (this.defPersonIds == null) {
            Object obj;
            String expressStr = this.getUserexpression();
            this.defPersonIds = new ArrayList<String>();
            if (expressStr != null && !expressStr.equals("") && (obj = JDSActionContext.getActionContext().Par(expressStr)) != null && obj.getClass().isArray()) {
                this.defPersonIds = (List)obj;
            }
        }
        return this.defPersonIds;
    }

    public void setStatus(SystemStatus status) {
        this.status = status;
    }

    public void setCheckTimes(Integer checkTimes) {
        this.checkTimes = checkTimes;
    }

    public List<String> getDefPersonIds() {
        return this.defPersonIds;
    }

    public void setUserexpression(String userexpression) {
        this.userexpression = userexpression;
    }

    public void setType(SystemNodeType type) {
        this.type = type;
    }

    public String getUserexpression() {
        return this.userexpression;
    }

    public void setDefPersonIds(List<String> defPersonIds) {
        this.defPersonIds = defPersonIds;
    }

    public Integer getCheckTimes() {
        return this.checkTimes;
    }

    public void addCheckTimes() {
        ServerNode serverNode = this;
        Integer n = serverNode.checkTimes;
        Integer n2 = serverNode.checkTimes = Integer.valueOf(serverNode.checkTimes + 1);
    }

    public void resetCheckTimes() {
        this.checkTimes = 0;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setUrl(String url) {
        this.url = url;
    }
}

