/*
 * Decompiled with CFR 0.152.
 */
package com.ds.cluster;

import com.alibaba.fastjson.util.TypeUtils;
import com.ds.cluster.ServerNode;
import com.ds.cluster.ServerNodeList;
import com.ds.cluster.ServerServiceConfig;
import com.ds.common.logging.Log;
import com.ds.common.logging.LogFactory;
import com.ds.server.SubSystem;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import net.sf.cglib.beans.BeanMap;

public class ServerBeanManager {
    private static final Log logger = LogFactory.getLog("JDS", ServerBeanManager.class);
    private static final String configId = "configid";
    public static Map<String, ServerNodeList> esbBeanListBeanmap = new HashMap<String, ServerNodeList>();

    public static ServerNodeList getEsbBeanList(String configName, SubSystem subSystem) {
        ServerNodeList esbBeanListBean = esbBeanListBeanmap.get(configName);
        if (esbBeanListBean == null || esbBeanListBean.getReload().equals("true")) {
            esbBeanListBean = ServerBeanManager.newEsbBeanList(configName, subSystem);
            esbBeanListBeanmap.put(configName, esbBeanListBean);
        }
        return esbBeanListBean;
    }

    private static ServerNodeList newEsbBeanList(String configName, SubSystem subSystem) {
        ServerServiceConfig config = new ServerServiceConfig(configName);
        ServerNodeList esbbeanlist = new ServerNodeList();
        BeanMap esbbeanListMap = BeanMap.create((Object)esbbeanlist);
        for (String key : esbbeanListMap.keySet()) {
            Class clazz = esbbeanListMap.getPropertyType(key);
            if (clazz.isAssignableFrom(String.class)) {
                esbbeanListMap.put((Object)key, (Object)config.getValue(key));
                continue;
            }
            LinkedHashMap<String, ServerNode> esbBeanMap = new LinkedHashMap<String, ServerNode>();
            String[] esbbeanIds = config.getValues(configId);
            for (int i = 0; esbbeanIds.length > i; ++i) {
                ServerNode eabBean = new ServerNode(subSystem);
                BeanMap beanmap = BeanMap.create((Object)eabBean);
                for (String esbkey : beanmap.keySet()) {
                    String value = config.getValue(esbbeanIds[i] + "." + esbkey);
                    if (value == null) continue;
                    beanmap.put((Object)esbkey, TypeUtils.cast((Object)value, (Class)beanmap.getPropertyType(esbkey), null));
                }
                esbBeanMap.put(esbbeanIds[i], eabBean);
            }
            esbbeanListMap.put((Object)key, esbBeanMap);
        }
        return esbbeanlist;
    }
}

