/*
 * Decompiled with CFR 0.152.
 */
package com.ds.cluster;

import com.ds.common.CommonConfig;

public class DBConfig {
    String configKey;
    String driver;
    String serverURL;
    String username;
    String password;
    Boolean mysqlUseUnicode;
    Integer minConnections;
    int maxConnections;
    int connectionTimeout;
    String encoding;
    int maxIdleTime;
    int checkIdlePeriod;
    int checkoutTimeout;

    public String getConfigKey() {
        return this.configKey;
    }

    public void setConfigKey(String configKey) {
        this.configKey = configKey;
    }

    public String getDriver() {
        return this.driver;
    }

    public void setDriver(String driver) {
        this.driver = driver;
    }

    public String getServerURL() {
        return this.serverURL;
    }

    public void setServerURL(String serverURL) {
        this.serverURL = serverURL;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public Boolean getMysqlUseUnicode() {
        return this.mysqlUseUnicode;
    }

    public void setMysqlUseUnicode(Boolean mysqlUseUnicode) {
        this.mysqlUseUnicode = mysqlUseUnicode;
    }

    public Integer getMinConnections() {
        return this.minConnections;
    }

    public void setMinConnections(Integer minConnections) {
        this.minConnections = minConnections;
    }

    public int getMaxConnections() {
        return this.maxConnections;
    }

    public void setMaxConnections(int maxConnections) {
        this.maxConnections = maxConnections;
    }

    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public void setConnectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public int getMaxIdleTime() {
        return this.maxIdleTime;
    }

    public void setMaxIdleTime(int maxIdleTime) {
        this.maxIdleTime = maxIdleTime;
    }

    public int getCheckIdlePeriod() {
        return this.checkIdlePeriod;
    }

    public void setCheckIdlePeriod(int checkIdlePeriod) {
        this.checkIdlePeriod = checkIdlePeriod;
    }

    public int getCheckoutTimeout() {
        return this.checkoutTimeout;
    }

    public void setCheckoutTimeout(int checkoutTimeout) {
        this.checkoutTimeout = checkoutTimeout;
    }

    DBConfig(String configKey) {
        this.configKey = configKey;
        this.loadProperties();
    }

    private void loadProperties() {
        this.driver = CommonConfig.getValue(this.configKey + ".database.driver");
        this.serverURL = CommonConfig.getValue(this.configKey + ".database.serverURL");
        this.username = CommonConfig.getValue(this.configKey + ".database.username");
        this.password = CommonConfig.getValue(this.configKey + ".database.password");
        String minCons = CommonConfig.getValue(this.configKey + ".database.minConnections");
        String maxCons = CommonConfig.getValue(this.configKey + ".database.maxConnections");
        String conTimeout = CommonConfig.getValue(this.configKey + ".database.connectionTimeout");
        String mit = CommonConfig.getValue(this.configKey + ".database.maxIdleTime");
        String cip = CommonConfig.getValue(this.configKey + ".database.checkIdlePeriod");
        String coto = CommonConfig.getValue(this.configKey + ".database.checkOutTimeOut");
        this.mysqlUseUnicode = (boolean)Boolean.valueOf(CommonConfig.getValue(this.configKey + ".database.mysql.useUnicode"));
        this.encoding = CommonConfig.getValue(this.configKey + ".database.mysql.characterEncoding");
        try {
            if (minCons != null) {
                this.minConnections = Integer.parseInt(minCons);
            }
            if (maxCons != null) {
                this.maxConnections = Integer.parseInt(maxCons);
            }
            if (conTimeout != null) {
                this.connectionTimeout = Integer.parseInt(conTimeout);
            }
            if (mit != null) {
                this.maxIdleTime = Integer.parseInt(mit);
            }
            if (cip != null) {
                this.checkIdlePeriod = Integer.parseInt(cip);
            }
            if (coto != null) {
                this.checkoutTimeout = Integer.parseInt(coto);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

