/*
 * Decompiled with CFR 0.152.
 */
package com.ds.cluster;

import com.ds.cluster.ClusterMananer;
import com.ds.cluster.ServerNode;
import com.ds.common.logging.Log;
import com.ds.common.logging.LogFactory;
import com.ds.jds.core.esb.util.ActionContext;
import com.ds.server.JDSServer;
import com.ds.server.eumus.ConfigCode;
import com.ds.server.eumus.SystemStatus;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClusterManagerImpl
implements ClusterMananer {
    private static final Logger logger = LoggerFactory.getLogger(ClusterManagerImpl.class);
    protected static Log log = LogFactory.getLog("JDS", ClusterManagerImpl.class);
    private static Map<String, List<String>> allIpMap = new LinkedHashMap<String, List<String>>();

    @Override
    public ServerNode getSubServer(String personId, ConfigCode configCode) {
        logger.info("\u96c6\u7fa4\u670d\u52a1\u67e5\u8be2:id={},systemCode={}", (Object)personId, (Object)configCode);
        Collection<ServerNode> collect = this.getServerMap(configCode).values();
        ArrayList<ServerNode> serverNodeList = new ArrayList<ServerNode>(collect.size());
        for (ServerNode serverNode : collect) {
            if (!SystemStatus.ONLINE.equals(serverNode.getStatus())) continue;
            serverNodeList.add(serverNode);
        }
        int count = serverNodeList.size();
        int index = Math.abs(personId.hashCode() % count);
        ServerNode ServerNode2 = (ServerNode)serverNodeList.get(index);
        logger.info("\u96c6\u7fa4\u670d\u52a1\u67e5\u8be2:id={},systemCode={},serverCount={}, ServerNode={}", new Object[]{personId, configCode, serverNodeList.size(), ServerNode2.getUrl()});
        return ServerNode2;
    }

    public ServerNode getSubServerOLd(String personId, ConfigCode configCode) {
        List<ServerNode> serverNodeList = this.getServerNodeListOrderByPersonCount(configCode);
        logger.info("\u96c6\u7fa4\u670d\u52a1\u67e5\u8be2:personId={},systemCode={},serverCount={}", new Object[]{personId, configCode, serverNodeList.size()});
        ServerNode serverNode = serverNodeList.get(0);
        for (int k = 0; k < serverNodeList.size(); ++k) {
            List<Object> iplist;
            serverNode = serverNodeList.get(k);
            if (allIpMap.containsKey(serverNode.getId())) {
                iplist = allIpMap.get(serverNode.getId());
            } else {
                iplist = new ArrayList();
                allIpMap.put(serverNode.getId(), iplist);
            }
            Integer size = allIpMap.get(serverNode.getId()).size();
            if (Integer.valueOf(serverNode.getMinconnection()) <= size) continue;
            if (!iplist.contains(personId)) {
                iplist.add(personId);
                allIpMap.put(serverNode.getId(), iplist);
            }
            return serverNode;
        }
        return serverNode;
    }

    public Map<String, List<String>> getAllIpMap() {
        return allIpMap;
    }

    @Override
    public Map<String, ServerNode> getServerMap(ConfigCode configCode) {
        return JDSServer.getClusterClient().getServerNodeListByConfigCode(configCode).getEsbBeanMap();
    }

    @Override
    public List<ServerNode> getServerNodeListOrderByPersonCount(ConfigCode configCode) {
        ArrayList<ServerNode> serverNodeList = new ArrayList<ServerNode>();
        LinkedHashMap<String, ServerNode> map = new LinkedHashMap<String, ServerNode>();
        map.putAll(this.getServerMap(configCode));
        for (String key : map.keySet()) {
            ServerNode serverNode = this.getServerMap(configCode).get(key);
            if (!serverNode.getStatus().equals(SystemStatus.ONLINE)) continue;
            serverNodeList.add(serverNode);
        }
        Collections.sort(serverNodeList, new Comparator(){

            public int compare(Object o1, Object o2) {
                ServerNode server1 = (ServerNode)o1;
                ServerNode server2 = (ServerNode)o2;
                if (!allIpMap.containsKey(server1.getId())) {
                    return 1;
                }
                if (!allIpMap.containsKey(server2.getId())) {
                    return -1;
                }
                if (((List)allIpMap.get(server1.getId())).size() > ((List)allIpMap.get(server2.getId())).size()) {
                    return -1;
                }
                return 1;
            }
        });
        return serverNodeList;
    }

    @Override
    public boolean experssPar(String expressStr) {
        ActionContext context = ActionContext.getContext();
        if (expressStr == null || expressStr.equals("")) {
            return true;
        }
        Object result = true;
        try {
            result = context.getValueStack().findValue(expressStr, Boolean.TYPE);
        }
        catch (Exception e) {
            return false;
        }
        if (result instanceof Boolean) {
            return (Boolean)result;
        }
        return true;
    }

    public String getLocalIp() {
        String localIp = null;
        try {
            localIp = InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        return localIp;
    }

    @Override
    public void clearUser(String personId) {
        Map<String, List<String>> allIpMap = this.getAllIpMap();
        for (String key : allIpMap.keySet()) {
            List<String> personList = allIpMap.get(key);
            if (!personList.contains(personId)) continue;
            personList.remove(personId);
        }
    }

    @Override
    public String getServerIdBySessionId(String personId) {
        Map<String, List<String>> allIpMap = this.getAllIpMap();
        for (String key : allIpMap.keySet()) {
            List<String> personList = allIpMap.get(key);
            if (!personList.contains(personId)) continue;
            return key;
        }
        return null;
    }
}

