/*
 * Decompiled with CFR 0.152.
 */
package com.ds.cluster;

import com.ds.common.CommonConfig;
import java.util.List;

public class CacheConfig {
    private String configKey;
    private String cacheName;
    Boolean enable = true;
    long size;
    long lifeTime;
    List<CacheConfig> cacheList;

    CacheConfig(String configKey) {
        this.configKey = configKey;
        this.loadProperties();
    }

    CacheConfig(String configKey, String cacheName) {
        this.configKey = configKey;
        this.cacheName = cacheName;
        this.loadProperties();
    }

    private void loadProperties() {
        String enableStr = CommonConfig.getValue(this.configKey + ".cache.enable");
        String lifeTimeStr = CommonConfig.getValue(this.configKey + ".cache.lifeTime");
        String sizeStr = CommonConfig.getValue(this.configKey + ".cache.size");
        if (this.cacheName != null) {
            enableStr = CommonConfig.getValue(this.configKey + ".cache." + this.cacheName + ".enable");
            lifeTimeStr = CommonConfig.getValue(this.configKey + ".cache." + this.cacheName + ".lifeTime");
            sizeStr = CommonConfig.getValue(this.configKey + ".cache." + this.cacheName + ".size");
        }
        try {
            if (enableStr != null) {
                this.enable = Boolean.valueOf(enableStr);
            }
            if (lifeTimeStr != null) {
                this.lifeTime = Integer.parseInt(lifeTimeStr);
            }
            if (sizeStr != null) {
                this.size = Integer.parseInt(sizeStr);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

