/*
 * Decompiled with CFR 0.152.
 */
package com.ds.client;

import com.ds.client.JDSSessionFactory;
import com.ds.common.JDSException;
import com.ds.common.expression.function.AbstractFunction;
import com.ds.common.logging.Log;
import com.ds.common.logging.LogFactory;
import com.ds.common.md5.MD5;
import com.ds.context.JDSActionContext;
import com.ds.context.JDSContext;
import com.ds.engine.ConnectInfo;
import com.ds.engine.JDSSessionHandle;
import com.ds.esb.config.ContextType;
import com.ds.esb.config.EsbBeanAnnotation;
import com.ds.jds.core.User;
import com.ds.jds.core.esb.util.ActionContext;
import com.ds.org.OrgManager;
import com.ds.org.Person;
import com.ds.org.PersonNotFoundException;
import com.ds.server.JDSClientService;
import com.ds.server.JDSServer;
import com.ds.server.OrgManagerFactory;
import com.ds.server.eumus.ConfigCode;
import java.util.ArrayList;
import java.util.Set;

@EsbBeanAnnotation(id="JDSC", name="\u83b7\u53d6\u57fa\u7840\u670d\u52a1", expressionArr="GetJDSClient()", desc="\u83b7\u53d6\u57fa\u7840\u670d\u52a1", dataType=ContextType.Action)
public class GetJDSClient
extends AbstractFunction {
    private static final Log logger = LogFactory.getLog("JDS", GetJDSClient.class);

    public JDSClientService perform() {
        ConnectInfo connectInfo;
        JDSContext context = JDSActionContext.getActionContext();
        JDSSessionFactory factory = new JDSSessionFactory(context);
        String systemCode = JDSActionContext.getActionContext().getSystemCode();
        ConfigCode configCode = JDSActionContext.getActionContext().getConfigCode();
        if (configCode == null) {
            configCode = ConfigCode.org;
        }
        String sessionId = JDSActionContext.getActionContext().getSessionId();
        String userid = (String)JDSActionContext.getActionContext().getParams("JDSUSERID");
        JDSClientService client = null;
        try {
            client = factory.getClientService(configCode);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (client == null && sessionId != null) {
            try {
                client = factory.getJDSClientBySessionId(sessionId, configCode);
            }
            catch (JDSException jDSException) {
                // empty catch block
            }
        }
        try {
            if (client == null) {
                connectInfo = null;
                if (userid != null && !userid.equals("") && !userid.equals("null")) {
                    connectInfo = this.getConnectInfo(userid);
                } else if (JDSServer.getClusterClient().getUDPClient().getUser() != null) {
                    connectInfo = this.getConnectInfo(JDSServer.getClusterClient().getUDPClient().getUser().getId());
                }
            }
        }
        catch (JDSException e) {
            e.printStackTrace();
        }
        if (client != null && client.getConnectInfo() == null) {
            try {
                connectInfo = JDSServer.getInstance().getConnectInfo(client.getSessionHandle());
                if (connectInfo != null) {
                    client.connect(connectInfo);
                } else if (userid != null && !userid.equals("") && !userid.equals("null")) {
                    connectInfo = this.getConnectInfo(userid);
                    client.connect(connectInfo);
                } else if (JDSServer.getClusterClient().getUDPClient().getUser() != null) {
                    User user = JDSServer.getInstance().getAdminUser();
                    connectInfo = new ConnectInfo(user.getId(), user.getAccount(), user.getPassword());
                    client.connect(connectInfo);
                }
                if (connectInfo == null) {
                    throw new JDSException("\u767b\u5f55\u5931\u8d25\uff01", 200);
                }
            }
            catch (JDSException e) {
                e.printStackTrace();
            }
        }
        if (!(client == null || client.getConnectInfo() == null || userid == null || client.getConnectInfo().getUserID() != null && client.getConnectInfo().getUserID().equals(userid))) {
            connectInfo = null;
            try {
                connectInfo = this.getConnectInfo(userid);
                client.connect(connectInfo);
            }
            catch (JDSException e) {
                userid = client.getConnectInfo().getUserID();
                e.printStackTrace();
            }
        }
        return client;
    }

    private JDSClientService newJdsClient(ConnectInfo connectInfo) throws JDSException {
        JDSClientService client = null;
        JDSSessionFactory factory = new JDSSessionFactory(JDSActionContext.getActionContext());
        JDSSessionHandle sessionHandle = factory.getSessionHandle();
        try {
            Set<JDSSessionHandle> sessionHandleList = JDSServer.getInstance().getSessionHandleList(connectInfo);
            ArrayList<JDSSessionHandle> newsessionHandleList = new ArrayList<JDSSessionHandle>();
            if (sessionHandleList != null) {
                newsessionHandleList.addAll(sessionHandleList);
                for (JDSSessionHandle handle : newsessionHandleList) {
                    Long connectionTime = (Long)JDSServer.getInstance().getConnectTimeCache().get(handle);
                    if (connectionTime != null && System.currentTimeMillis() - connectionTime <= 1800000L) continue;
                    JDSServer.getInstance().disconnect(handle);
                }
            }
            client = factory.newClientService(sessionHandle, JDSActionContext.getActionContext().getConfigCode());
            client.connect(connectInfo);
        }
        catch (JDSException e) {
            e.printStackTrace();
            throw new JDSException("\u767b\u5f55\u5931\u8d25", 200);
        }
        return client;
    }

    private ConnectInfo getConnectInfo(String personId) throws JDSException {
        ActionContext.getContext().put("JDSUSERID", personId);
        OrgManager orgManager = OrgManagerFactory.getOrgManager();
        Person person = null;
        ConnectInfo connectInfo = null;
        try {
            person = orgManager.getPersonByID(personId);
            connectInfo = new ConnectInfo(person.getID(), person.getAccount(), person.getPassword());
        }
        catch (PersonNotFoundException e) {
            throw new JDSException("\u767b\u5f55\u5931\u8d25", 200);
        }
        return connectInfo;
    }

    public static void main(String[] args) {
        System.out.println(MD5.getHashString("123456"));
    }
}

