package com.ds.topmenu.plugins.bpm;

import com.ds.config.ResultModel;
import com.ds.config.TreeListResultModel;
import com.ds.dsm.admin.temp.JavaTempNavTree;
import com.ds.dsm.manager.repository.RepositoryNav;
import com.ds.enums.db.MethodChinaName;
import com.ds.esd.custom.annotation.CustomAnnotation;
import com.ds.esd.custom.annotation.DialogAnnotation;
import com.ds.esd.custom.annotation.nav.NavGroupViewAnnotation;
import com.ds.esd.custom.annotation.nav.NavTreeViewAnnotation;
import com.ds.esd.custom.api.annotation.APIEventAnnotation;
import com.ds.esd.custom.module.annotation.ModuleAnnotation;
import com.ds.esd.dsm.enums.DSMType;
import com.ds.esd.util.TreePageUtil;
import com.ds.web.annotation.Aggregation;
import com.ds.web.annotation.AggregationType;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import java.util.Arrays;
import java.util.List;


@Controller
@RequestMapping(value = {"/action/bpm/config/"})
@Aggregation(type = AggregationType.menu)
public class BPMDevAction {


    @RequestMapping(method = RequestMethod.POST, value = "DBInstList")
    @DialogAnnotation
    @MethodChinaName(cname = "资源库")
    @NavGroupViewAnnotation
    @CustomAnnotation(index = 0)
    @ModuleAnnotation(imageClass = "iconfont iconchucun", caption = "资源库")
    @ResponseBody
    public ResultModel<RepositoryNav> getTempNav(String projectVersionName) {
        ResultModel<RepositoryNav> result = new ResultModel<RepositoryNav>();
        return result;
    }


    @MethodChinaName(cname = "模板维护")
    @RequestMapping(method = RequestMethod.POST, value = "CodeTemps")
    @APIEventAnnotation(autoRun = true)
    @NavTreeViewAnnotation
    @DialogAnnotation
    @ModuleAnnotation(imageClass = "spafont spa-icon-settingprj", dynLoad = true, caption = "代码模板")
    @ResponseBody
    public TreeListResultModel<List<JavaTempNavTree>> getTempManager(String id) {
        TreeListResultModel<List<JavaTempNavTree>> resultModel = new TreeListResultModel<List<JavaTempNavTree>>();
        resultModel = TreePageUtil.getTreeList(Arrays.asList(DSMType.repository), JavaTempNavTree.class);
        return resultModel;

    }

}
