/*
 * Decompiled with CFR 0.152.
 */
package com.ds.esd.util;

import com.ds.common.logging.Log;
import com.ds.common.logging.LogFactory;
import com.ds.common.util.CnToSpell;
import com.ds.common.util.StringUtility;
import com.ds.config.ErrorListResultModel;
import com.ds.config.ListResultModel;
import com.ds.config.TreeListResultModel;
import com.ds.context.JDSActionContext;
import com.ds.esd.custom.bean.CustomViewBean;
import com.ds.esd.custom.bean.MethodConfig;
import com.ds.esd.tool.ui.component.list.TreeListItem;
import com.ds.esd.util.FillItemTask;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TreePageUtil {
    private static final Log logger = LogFactory.getLog((String)"JDS", TreePageUtil.class);

    public static <T extends TreeListItem, K> TreeListResultModel<List<T>> getTreeList(Set<K> objs, Class<T> clazz) {
        return TreePageUtil.getTreeList(objs, clazz, null);
    }

    public static <T extends TreeListItem, K> TreeListResultModel<List<T>> getTreeList(Set<K> objs, Class<T> clazz, List<String> ids) {
        ArrayList<K> result = new ArrayList<K>();
        result.addAll(objs);
        return TreePageUtil.getTreeList(result, clazz, ids);
    }

    public static <T extends TreeListItem, K> TreeListResultModel<List<T>> getTreeList(List<K> objs, Class<T> clazz) {
        return TreePageUtil.getTreeList(objs, clazz, null);
    }

    public static <T extends TreeListItem, K> TreeListResultModel<List<T>> getTreeList(List<K> objs, Class<T> clazz, List<String> ids) {
        TreeListResultModel userStatusInfo = new TreeListResultModel();
        if (ids == null) {
            ids = new ArrayList<String>();
        }
        List<T> pageResult = TreePageUtil.fillObjs(objs, clazz, ids);
        if (ids.isEmpty()) {
            Object id = JDSActionContext.getActionContext().getParams("id");
            if (id != null && !id.equals("")) {
                String[] orgIdArr = StringUtility.split((String)id.toString(), (String)";");
                ids = Arrays.asList(orgIdArr);
            } else if (pageResult.size() > 0) {
                ids.add(((TreeListItem)pageResult.get(0)).getId());
            }
        }
        userStatusInfo.setIds(ids);
        userStatusInfo.setData(pageResult);
        return userStatusInfo;
    }

    public static <T extends TreeListItem> List<T> fillObjs(List objs, Class<T> clazz) {
        return TreePageUtil.fillObjs(objs, clazz, null);
    }

    public static <T extends TreeListItem> List<T> fillObjs(List objs, Class<T> clazz, List<String> ids) {
        ArrayList tasks = new ArrayList();
        ArrayList<Object> pageResult = new ArrayList<Object>();
        MethodConfig methodConfig = (MethodConfig)JDSActionContext.getActionContext().getContext().get("TopMethodBean");
        CustomViewBean customViewBean = (CustomViewBean)methodConfig.getView();
        for (Object obj : objs) {
            if (obj == null) continue;
            if (clazz == null || obj.getClass().isAssignableFrom(clazz)) {
                pageResult.add((TreeListItem)obj);
                continue;
            }
            FillItemTask<T> task = new FillItemTask<T>(obj, clazz, customViewBean, ids);
            try {
                T item = task.call();
                if (item.getPattern() != null && !item.getPattern().equals("")) {
                    Pattern p = Pattern.compile(item.getPattern(), 2);
                    Matcher namematcher = p.matcher(item.getName() == null ? "" : item.getName());
                    Matcher cnnamematcher = p.matcher(item.getClassName() == null ? "" : item.getClassName());
                    Matcher captionmatcher = p.matcher(item.getCaption() == null ? "" : item.getCaption());
                    Matcher cnmatcher = p.matcher(CnToSpell.getFullSpell((String)(item.getCaption() == null ? "" : item.getCaption())));
                    if (!namematcher.find() && !cnnamematcher.find() && !captionmatcher.find() && !cnmatcher.find() && item.getSub() == null || pageResult.contains(item)) continue;
                    pageResult.add(item);
                    continue;
                }
                pageResult.add(item);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return pageResult;
    }

    public static <T extends TreeListItem, K> TreeListResultModel<List<T>> changTreeList(ListResultModel<List<K>> objs, Class<T> clazz) {
        return TreePageUtil.changTreeList(objs, clazz, null);
    }

    public static <T extends TreeListItem, K> TreeListResultModel<List<T>> changTreeList(ListResultModel<List<K>> objs, Class<T> clazz, List<String> ids) {
        TreeListResultModel userStatusInfo = new TreeListResultModel();
        try {
            ArrayList pageResult = new ArrayList();
            List list = (List)objs.get();
            if (ids == null) {
                ids = new ArrayList<String>();
            }
            userStatusInfo.setData(TreePageUtil.fillObjs(list, clazz, ids));
            userStatusInfo.setSize(objs.getSize());
            if (ids.isEmpty()) {
                Object id = JDSActionContext.getActionContext().getParams("id");
                if (id != null && !id.equals("")) {
                    String[] orgIdArr = StringUtility.split((String)id.toString(), (String)";");
                    ids = Arrays.asList(orgIdArr);
                } else if (pageResult.size() > 0) {
                    ids.add(((TreeListItem)pageResult.get(0)).getId());
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            userStatusInfo = new ErrorListResultModel();
            ((ErrorListResultModel)userStatusInfo).setErrdes("\u5185\u90e8\u9519\u8bef");
        }
        return userStatusInfo;
    }

    public static <T extends TreeListItem> TreeListResultModel<List<T>> getDefaultTreeList(List<T> objs) {
        return TreePageUtil.getDefaultTreeList(objs, new ArrayList<String>());
    }

    public static <T extends TreeListItem> TreeListResultModel<List<T>> getDefaultTreeList(List<T> objs, List<String> ids) {
        return TreePageUtil.getDefaultTreeList(objs, null, ids);
    }

    public static <T extends TreeListItem> TreeListResultModel<List<T>> getDefaultTreeList(T ... objs) {
        ArrayList<T> result = new ArrayList<T>();
        result.addAll(Arrays.asList(objs));
        return TreePageUtil.getDefaultTreeList(objs);
    }

    public static <T extends TreeListItem> TreeListResultModel<List<T>> getDefaultTreeList(Set<T> objs, List<String> ids) {
        ArrayList<T> result = new ArrayList<T>();
        result.addAll(objs);
        return TreePageUtil.getDefaultTreeList(result, null, ids);
    }

    public static <T extends TreeListItem, K> TreeListResultModel<List<T>> getDefaultTreeList(Set<K> objs, Class<T> clazz) {
        return TreePageUtil.getDefaultTreeList(objs, clazz, null);
    }

    public static <T extends TreeListItem, K> TreeListResultModel<List<T>> getDefaultTreeList(Set<K> objs, Class<T> clazz, List<String> ids) {
        ArrayList<K> result = new ArrayList<K>();
        result.addAll(objs);
        return TreePageUtil.getDefaultTreeList(result, clazz, ids);
    }

    public static <T extends TreeListItem, K> TreeListResultModel<List<T>> getDefaultTreeList(ListResultModel<List<K>> objs, Class<T> clazz) {
        return TreePageUtil.getDefaultTreeList(objs, clazz, null);
    }

    public static <T extends TreeListItem, K> TreeListResultModel<List<T>> getDefaultTreeList(ListResultModel<List<K>> objs, Class<T> clazz, List<String> ids) {
        TreeListResultModel userStatusInfo = new TreeListResultModel();
        try {
            ArrayList pageResult = new ArrayList();
            List list = (List)objs.get();
            if (ids == null) {
                ids = new ArrayList<String>();
            }
            userStatusInfo.setData(TreePageUtil.fillObjs(list, clazz, ids));
            userStatusInfo.setSize(objs.getSize());
            if (ids.isEmpty()) {
                Object id = JDSActionContext.getActionContext().getParams("id");
                if (id != null && !id.equals("")) {
                    String[] orgIdArr = StringUtility.split((String)id.toString(), (String)";");
                    ids = Arrays.asList(orgIdArr);
                } else if (pageResult.size() > 0) {
                    ids.add(((TreeListItem)pageResult.get(0)).getId());
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            userStatusInfo = new ErrorListResultModel();
            ((ErrorListResultModel)userStatusInfo).setErrdes("\u5185\u90e8\u9519\u8bef");
        }
        return userStatusInfo;
    }

    public static <T extends TreeListItem, K> TreeListResultModel<List<T>> getDefaultTreeList(List<K> objs, Class<T> clazz) {
        return TreePageUtil.getDefaultTreeList(objs, clazz, null);
    }

    public static <T extends TreeListItem, K> TreeListResultModel<List<T>> getDefaultTreeList(List<K> objs, Class<T> clazz, List<String> ids) {
        ErrorListResultModel userStatusInfo = null;
        try {
            userStatusInfo = TreePageUtil.getTreeList(objs, clazz, ids);
        }
        catch (Exception e) {
            e.printStackTrace();
            userStatusInfo = new ErrorListResultModel();
            userStatusInfo.setErrdes("\u5185\u90e8\u9519\u8bef");
        }
        return userStatusInfo;
    }
}

