/*
 * Decompiled with CFR 0.152.
 */
package com.ds.esd.localproxy.handler.filter;

import com.alibaba.fastjson.JSONObject;
import com.ds.common.logging.Log;
import com.ds.common.logging.LogFactory;
import com.ds.common.util.IOUtility;
import com.ds.server.httpproxy.core.Handler;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Enumeration;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.client.fluent.Form;
import org.apache.http.client.fluent.Request;
import org.apache.http.client.fluent.Response;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.InputStreamBody;
import org.apache.http.util.CharsetUtils;

public class ProxyDispatcherServlet
extends HttpServlet {
    private static final Log logger = LogFactory.getLog((String)"JDS", ProxyDispatcherServlet.class);

    void doPostProxy(Request request, HttpServletRequest req, HttpServletResponse resp) throws IOException {
        int length;
        if (ServletFileUpload.isMultipartContent((HttpServletRequest)req)) {
            MultipartEntityBuilder reqEntitybuild = MultipartEntityBuilder.create().setMode(HttpMultipartMode.BROWSER_COMPATIBLE).setCharset(CharsetUtils.get((String)"UTF-8"));
            DiskFileItemFactory dfif = new DiskFileItemFactory();
            dfif.setSizeThreshold(Integer.MIN_VALUE);
            ServletFileUpload fileupload = new ServletFileUpload((FileItemFactory)dfif);
            List files = null;
            try {
                files = fileupload.parseRequest(req);
            }
            catch (FileUploadException e) {
                e.printStackTrace();
            }
            for (FileItem f : files) {
                if (!f.isFormField()) {
                    String fileName = f.getName();
                    InputStreamBody fileStream = new InputStreamBody(f.getInputStream(), fileName);
                    reqEntitybuild.addPart("file", (ContentBody)fileStream);
                    continue;
                }
                if (f != null && f.get() != null && f.get().length > 0) {
                    reqEntitybuild.addTextBody(f.getFieldName(), f.getString("UTF-8"));
                    continue;
                }
                reqEntitybuild.addTextBody(f.getFieldName(), "");
            }
            request = request.body(reqEntitybuild.build());
        } else {
            String contentType = req.getContentType();
            if (contentType.indexOf("application/json") > -1) {
                String userData = JSONObject.toJSON((Object)IOUtility.toString((InputStream)req.getInputStream())).toString();
                request.bodyString(userData, ContentType.APPLICATION_JSON);
            } else {
                Form form = Form.form();
                Enumeration paramNames = req.getParameterNames();
                while (paramNames.hasMoreElements()) {
                    Header[] name = (Header[])paramNames.nextElement();
                    form.add((String)name, req.getParameter((String)name));
                }
                request.bodyForm((Iterable)form.build(), Charset.forName("utf-8"));
            }
        }
        Response response = request.execute();
        HttpResponse httpResponse = response.returnResponse();
        Header[] reqheads = httpResponse.getAllHeaders();
        resp.setHeader("Transfer-Encoding", null);
        for (Header header : reqheads) {
            if (header.getName().equals("Transfer-Encoding")) continue;
            resp.setHeader(header.getName(), header.getValue());
        }
        if (httpResponse.getEntity().getContentLength() > 0L) {
            resp.setHeader("Content-Length", httpResponse.getEntity().getContentLength() + "");
            resp.setHeader("Transfer-Encoding", null);
        }
        InputStream stream = httpResponse.getEntity().getContent();
        ServletOutputStream os = resp.getOutputStream();
        byte[] b = new byte[4096];
        while ((length = stream.read(b)) > 0) {
            os.write(b, 0, length);
        }
        try {
            os.close();
            stream.close();
        }
        catch (IOException ioe) {
            resp.setStatus(500);
        }
    }

    void doGetProxy(Request request, HttpServletRequest req, HttpServletResponse resp) throws IOException {
        int length;
        Header[] reqheads;
        Enumeration heads = req.getHeaderNames();
        while (heads.hasMoreElements()) {
            String name = (String)heads.nextElement();
            request.setHeader(name, req.getHeader(name));
        }
        Response response = request.execute();
        HttpResponse httpResponse = response.returnResponse();
        for (Header header : reqheads = httpResponse.getAllHeaders()) {
            if (!header.getName().equals("Transfer-Encoding")) {
                resp.setHeader(header.getName(), header.getValue());
                continue;
            }
            resp.setHeader("Transfer-Encoding", null);
        }
        if (httpResponse.getEntity().getContentLength() > 0L) {
            resp.setHeader("Content-Length", httpResponse.getEntity().getContentLength() + "");
            resp.setHeader("Transfer-Encoding", null);
        }
        InputStream stream = httpResponse.getEntity().getContent();
        ServletOutputStream os = resp.getOutputStream();
        byte[] b = new byte[4096];
        while ((length = stream.read(b)) > 0) {
            os.write(b, 0, length);
        }
        try {
            os.close();
            stream.close();
        }
        catch (IOException ioe) {
            resp.setStatus(500);
        }
    }

    protected void service(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        String realUrl = req.getRequestURL().toString();
        String url = req.getPathInfo();
        String queryStr = req.getQueryString();
        if (queryStr != null && !queryStr.equals("")) {
            url = url + "?" + queryStr;
        }
        if (req.getMethod().toUpperCase().equals("GET")) {
            url = url.startsWith("/root") || url.startsWith("/RAD") || url.startsWith("/public") ? "http://192.168.5.43:5337" + url : "http://192.168.5.47:5338" + url;
            Request request = Request.Get((String)url);
            this.doGetProxy(request, req, res);
        } else if (req.getMethod().toUpperCase().equals("POST")) {
            url = url.startsWith("/root") || url.startsWith("/RAD") || url.startsWith("/public") ? "http://192.168.5.43:5337" + url : "http://192.168.5.47:5338" + url;
            Request request = Request.Post((String)url);
            if (!ServletFileUpload.isMultipartContent((HttpServletRequest)req)) {
                Enumeration heads = req.getHeaderNames();
                while (heads.hasMoreElements()) {
                    String name = (String)heads.nextElement();
                    if (name.toLowerCase().equals("content-length")) continue;
                    request.setHeader(name, req.getHeader(name));
                }
            } else {
                Enumeration heads = req.getHeaderNames();
                while (heads.hasMoreElements()) {
                    String name = (String)heads.nextElement();
                    for (String httpHeader : Handler.httpHeaderArr) {
                        if (!name.toLowerCase().equals(httpHeader)) continue;
                        request.setHeader(name, req.getHeader(name));
                    }
                }
            }
            this.doPostProxy(request, req, res);
        }
    }
}

