/*
 * Decompiled with CFR 0.152.
 */
package com.ds.esd.localproxy.handler.filter;

import com.ds.common.JDSException;
import com.ds.common.logging.Log;
import com.ds.common.logging.LogFactory;
import com.ds.common.md5.MD5InputStream;
import com.ds.common.util.IOUtility;
import com.ds.common.util.StringUtility;
import com.ds.config.JDSConfig;
import com.ds.context.JDSActionContext;
import com.ds.esd.client.ESDClient;
import com.ds.esd.client.ESDFacrory;
import com.ds.esd.localproxy.Conts;
import com.ds.esd.tool.module.EUModule;
import com.ds.template.JDSFreemarkerResult;
import com.ds.vfs.FileInfo;
import com.ds.vfs.ct.CtVfsFactory;
import com.ds.vfs.ct.CtVfsService;
import com.ds.web.util.RequestUtils;
import freemarker.template.TemplateException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class DefaultDispatcherServlet
extends HttpServlet {
    private static final Log logger = LogFactory.getLog((String)"JDS", DefaultDispatcherServlet.class);

    protected void service(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        req.setAttribute("ServletResponse", (Object)res);
        JDSActionContext.getActionContext().remove();
        Long currTime = System.currentTimeMillis();
        if (req instanceof HttpServletRequest) {
            String path = RequestUtils.getRelativeReqUrl((HttpServletRequest)req);
            String path2 = req.getPathInfo();
            String json = "{}";
            if (path.indexOf("?") > -1) {
                path = path.substring(0, path.indexOf("?"));
            }
            if (path.indexOf("#") > -1) {
                path = path.substring(0, path.indexOf("#"));
            }
            if (path.endsWith(".vhtml")) {
                path = StringUtility.replace((String)path, (String)".vhtml", (String)".html");
            }
            if (path.startsWith("/RAD/form")) {
                path = path.substring("/RAD".length());
            }
            if (path.startsWith("/root/") || path.startsWith("root/") || path.startsWith("form/") || path.startsWith("/form/")) {
                logger.info((Object)("httpUrl=" + path));
                if (path.startsWith("/root/")) {
                    path = path.substring("/root".length());
                }
                MD5InputStream stream = null;
                FileInfo fileInfo = null;
                try {
                    path = StringUtility.replace((String)path, (String)".js", (String)".cls");
                    fileInfo = this.getVfsClient().getFileByPath(path);
                    if (fileInfo == null) {
                        path = StringUtility.replace((String)path, (String)".cls", (String)".js");
                        fileInfo = this.getVfsClient().getFileByPath(path);
                    }
                    if (fileInfo != null) {
                        stream = fileInfo.getCurrentVersonInputStream();
                    }
                }
                catch (JDSException e) {
                    e.printStackTrace();
                }
                if (stream != null) {
                    res.setContentType(Conts.getSuffixMap().get(fileInfo.getName().substring(fileInfo.getName().indexOf("."))));
                    res.setHeader("Content-disposition", "filename=" + new String(fileInfo.getName().getBytes("utf-8"), "ISO8859-1"));
                    JDSFreemarkerResult freemarkerResult = new JDSFreemarkerResult();
                    if (fileInfo.getPath().endsWith(".js")) {
                        try {
                            freemarkerResult.doExecute(fileInfo.getCurrentVersonFileHash(), (Writer)res.getWriter(), CtVfsFactory.getLocalCachePath());
                        }
                        catch (TemplateException e) {
                            e.printStackTrace();
                        }
                    } else {
                        int length;
                        res.setHeader("Content-Length", String.valueOf(fileInfo.getCurrentVersion().getLength()));
                        ServletOutputStream os = res.getOutputStream();
                        byte[] b = new byte[4096];
                        while ((length = stream.read(b)) > 0) {
                            os.write(b, 0, length);
                        }
                        try {
                            os.close();
                            stream.close();
                        }
                        catch (IOException ioe) {
                            res.setStatus(500);
                        }
                    }
                } else if (path.endsWith("debug.html")) {
                    String localPath = JDSConfig.getAbsolutePath((String)(".." + File.separator + ".." + File.separator));
                    File file = new File(localPath + "/RAD/debug.html");
                    json = IOUtility.toString((InputStream)new FileInputStream(file), (String)"UTF-8");
                    try {
                        this.getVfsClient().saveFileAsContent(path, json, "UTF-8");
                    }
                    catch (JDSException e) {
                        e.printStackTrace();
                    }
                    res.getWriter().write(json);
                } else if (path.endsWith(".js") || path.endsWith(".vv")) {
                    res.getWriter().write(json);
                } else {
                    res.setStatus(404);
                }
            } else {
                block45: {
                    String fileName = path.substring(path.lastIndexOf("/") + 1, path.length());
                    String localPath = JDSConfig.getAbsolutePath((String)(".." + File.separator + ".." + File.separator));
                    File file = new File(localPath + path);
                    if (file.exists()) {
                        int length;
                        res.setContentType(Conts.getSuffixMap().get(fileName.substring(fileName.indexOf("."))));
                        res.setHeader("Content-disposition", "filename=" + new String(fileName.getBytes("utf-8"), "ISO8859-1"));
                        res.setHeader("Content-Length", String.valueOf(file.length()));
                        ServletOutputStream os = res.getOutputStream();
                        FileInputStream stream = new FileInputStream(file);
                        byte[] b = new byte[4096];
                        while ((length = ((InputStream)stream).read(b)) > 0) {
                            os.write(b, 0, length);
                        }
                        try {
                            os.close();
                            ((InputStream)stream).close();
                        }
                        catch (IOException iOException) {}
                    } else {
                        ESDClient client = null;
                        try {
                            client = ESDFacrory.getESDClient();
                            path = StringUtility.replace((String)path, (String)"/RAD/", (String)"");
                            String projectName = path.substring(0, path.indexOf("/"));
                            String filePath = path.substring(path.indexOf("/") + 1, path.length());
                            FileInfo fileInfo = client.getFileByPath(new String[]{filePath, projectName});
                            if (fileInfo == null) {
                                filePath = StringUtility.replace((String)filePath, (String)".js", (String)".cls");
                                fileInfo = client.getFileByPath(new String[]{filePath, projectName});
                            }
                            if (fileInfo == null) break block45;
                            MD5InputStream stream = fileInfo.getCurrentVersonInputStream();
                            res.setContentType(Conts.getSuffixMap().get(fileInfo.getName().substring(fileInfo.getName().indexOf("."))));
                            res.setHeader("Content-disposition", "filename=" + new String(fileInfo.getName().getBytes("utf-8"), "ISO8859-1"));
                            JDSFreemarkerResult freemarkerResult = new JDSFreemarkerResult();
                            if (fileInfo.getPath().endsWith(".cls")) {
                                EUModule module = null;
                                try {
                                    module = client.getModule(fileInfo.getPath(), projectName);
                                }
                                catch (JDSException e) {
                                    e.printStackTrace();
                                }
                                json = client.genJSON(module, null).toString();
                                res.getWriter().write(json);
                                break block45;
                            }
                            if (fileInfo.getPath().endsWith(".js")) {
                                try {
                                    freemarkerResult.doExecute(fileInfo.getCurrentVersonFileHash(), (Writer)res.getWriter(), CtVfsFactory.getLocalCachePath());
                                }
                                catch (TemplateException e) {
                                    e.printStackTrace();
                                }
                            } else {
                                int length;
                                res.setHeader("Content-Length", String.valueOf(fileInfo.getCurrentVersion().getLength()));
                                ServletOutputStream os = res.getOutputStream();
                                byte[] b = new byte[4096];
                                while ((length = stream.read(b)) > 0) {
                                    os.write(b, 0, length);
                                }
                                try {
                                    os.close();
                                    stream.close();
                                }
                                catch (IOException ioe) {
                                    res.setStatus(500);
                                }
                            }
                        }
                        catch (JDSException e) {
                            e.printStackTrace();
                        }
                    }
                }
                String url = RequestUtils.getRelativeReqUrl((HttpServletRequest)req);
                logger.info((Object)("httpUrl=" + url + " time=" + (System.currentTimeMillis() - currTime)));
            }
        }
    }

    public CtVfsService getVfsClient() {
        CtVfsService vfsClient = CtVfsFactory.getCtVfsService();
        return vfsClient;
    }
}

