/*
 * Decompiled with CFR 0.152.
 */
package com.ds.esd.localproxy.handler.filter;

import com.ds.common.JDSException;
import com.ds.common.logging.Log;
import com.ds.common.logging.LogFactory;
import com.ds.common.md5.MD5InputStream;
import com.ds.common.util.StringUtility;
import com.ds.context.JDSActionContext;
import com.ds.esd.client.ESDClient;
import com.ds.esd.client.ESDFacrory;
import com.ds.esd.localproxy.Conts;
import com.ds.esd.tool.module.EUModule;
import com.ds.jds.core.esb.EsbUtil;
import com.ds.server.JDSClientService;
import com.ds.template.JDSFreemarkerResult;
import com.ds.vfs.FileInfo;
import com.ds.vfs.ct.CtVfsFactory;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.io.Writer;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ClsDispatcherServlet
extends HttpServlet {
    private static final Log logger = LogFactory.getLog((String)"JDS", ClsDispatcherServlet.class);

    protected void service(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        block17: {
            req.setAttribute("ServletResponse", (Object)res);
            JDSActionContext.getActionContext().remove();
            Long currTime = System.currentTimeMillis();
            if (req instanceof HttpServletRequest) {
                String path = req.getPathInfo();
                String json = "{}";
                if (path.startsWith("/")) {
                    path = path.substring(1, path.length());
                }
                String filePath = "debug.html";
                String projectName = path;
                if (path.indexOf("/") > -1) {
                    projectName = path.substring(0, path.indexOf("/"));
                    filePath = path.substring(path.indexOf("/") + 1, path.length());
                }
                MD5InputStream stream = null;
                FileInfo fileInfo = null;
                try {
                    ESDClient client = ESDFacrory.getESDClient((JDSClientService)((JDSClientService)EsbUtil.parExpression((String)"$JDSC", JDSClientService.class)));
                    fileInfo = client.getFileByPath(new String[]{filePath, projectName});
                    if (fileInfo == null) {
                        filePath = StringUtility.replace((String)filePath, (String)".js", (String)".cls");
                        fileInfo = client.getFileByPath(new String[]{filePath, projectName});
                    }
                    if (fileInfo != null) {
                        stream = fileInfo.getCurrentVersonInputStream();
                    }
                    if (stream == null) break block17;
                    res.setContentType(Conts.getSuffixMap().get(fileInfo.getName().substring(fileInfo.getName().indexOf("."))));
                    res.setHeader("Content-disposition", "filename=" + new String(fileInfo.getName().getBytes("utf-8"), "ISO8859-1"));
                    JDSFreemarkerResult freemarkerResult = new JDSFreemarkerResult();
                    if (fileInfo.getPath().endsWith(".cls")) {
                        EUModule module = null;
                        try {
                            module = client.getModule(fileInfo.getPath(), projectName);
                        }
                        catch (JDSException e) {
                            e.printStackTrace();
                        }
                        json = client.genJSON(module, null).toString();
                        res.getWriter().write(json);
                        break block17;
                    }
                    if (fileInfo.getPath().endsWith(".js")) {
                        try {
                            String localPath = CtVfsFactory.getLocalCachePath();
                            freemarkerResult.doExecute(fileInfo.getCurrentVersonFileHash(), (Writer)res.getWriter(), localPath);
                        }
                        catch (TemplateException e) {
                            e.printStackTrace();
                        }
                    } else {
                        int length;
                        res.setHeader("Content-Length", String.valueOf(fileInfo.getCurrentVersion().getLength()));
                        ServletOutputStream os = res.getOutputStream();
                        byte[] b = new byte[4096];
                        while ((length = stream.read(b)) > 0) {
                            os.write(b, 0, length);
                        }
                        try {
                            os.close();
                            stream.close();
                        }
                        catch (IOException ioe) {
                            res.setStatus(500);
                        }
                    }
                }
                catch (JDSException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

