/*
 * Decompiled with CFR 0.152.
 */
package com.ds.esd.localproxy.handler.dsm;

import com.ds.common.JDSException;
import com.ds.common.logging.Log;
import com.ds.common.logging.LogFactory;
import com.ds.context.JDSActionContext;
import com.ds.esd.client.ESDFacrory;
import com.ds.esd.client.Project;
import com.ds.esd.custom.CustomViewFactory;
import com.ds.esd.custom.bean.MethodConfig;
import com.ds.esd.editor.enums.PackagePathType;
import com.ds.esd.editor.enums.PackageType;
import com.ds.esd.localproxy.handler.AbstractRADHandler;
import com.ds.esd.tool.module.EUModule;
import com.ds.esd.tool.ui.component.form.HiddenInputComponent;
import com.ds.esd.tool.ui.component.form.HiddenInputProperties;
import com.ds.server.httpproxy.core.HttpRequest;
import com.ds.server.httpproxy.core.HttpResponse;
import com.ds.server.httpproxy.core.Server;
import com.ds.web.RequestMethodBean;
import java.io.IOException;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;

public class DSMContextHandler
extends AbstractRADHandler {
    private static final Log logger = LogFactory.getLog((String)"JDS", DSMContextHandler.class);
    Pattern rule;

    public boolean initialize(String handlerName, Server server) {
        super.initialize(handlerName, server);
        this.rule = Pattern.compile(RULE_OPTION.getProperty(server, handlerName));
        return true;
    }

    protected boolean handleBody(HttpRequest request, HttpResponse response) throws IOException {
        boolean ruleMatches = this.rule.matcher(request.getPath()).matches();
        if (!ruleMatches) {
            return false;
        }
        EUModule module = null;
        String projectName = this.getProjectName(request);
        RequestMethodBean methodBean = this.getRequestMethodBean(request);
        Map allParamsMap = this.getAllParamMap(methodBean, request);
        try {
            Object obj = allParamsMap.get("_currClassName_");
            if (obj != null && !obj.equals("") && !obj.equals("RAD")) {
                String currClassName = obj.toString();
                MethodConfig topMethodConfig = ESDFacrory.getESDClient().getMethodAPIBean(currClassName, projectName);
                JDSActionContext.getActionContext().getContext().put("TopMethodBean", topMethodConfig);
                module = ESDFacrory.getESDClient().getModule(currClassName, projectName);
                if (module == null) {
                    module = ESDFacrory.getESDClient().getDSMModule(currClassName, allParamsMap);
                }
            }
            if (module == null && methodBean != null && projectName != null && !projectName.equals("") && !projectName.equals("RAD")) {
                allParamsMap.put("projectName", projectName);
                String path = CustomViewFactory.getInstance().formatPath(request.getUrl(), projectName);
                MethodConfig methodConfig = ESDFacrory.getESDClient().getMethodAPIBean(path, projectName);
                JDSActionContext.getActionContext().getContext().put("TopModule", module);
                if (methodConfig != null && methodConfig.isModule()) {
                    Project project = ESDFacrory.getESDClient().getProjectByName(projectName);
                    if (project != null) {
                        allParamsMap.put("projectId", project.getId());
                        PackagePathType packagePathType = PackagePathType.startPath((String)path);
                        module = packagePathType == null || packagePathType.getApiType().equals((Object)PackageType.local) ? ESDFacrory.getESDClient().getCustomModule(methodBean.getUrl(), projectName, allParamsMap) : ESDFacrory.getESDClient().getDSMModule(methodBean.getUrl(), allParamsMap);
                    } else {
                        logger.warn((Object)"DSM\u73af\u5883\u521d\u59cb\u5316\u5931\u8d25\uff0c\u672a\u53d1\u73b0\u53ef\u7528\u7684\u5de5\u7a0b\uff01");
                    }
                }
            }
            if (module != null) {
                JDSActionContext.getActionContext().getContext().put("TopModule", module);
                JDSActionContext.getActionContext().getContext().put("CurrModule", module);
                if (methodBean != null) {
                    MethodConfig methodAPIBean = ESDFacrory.getESDClient().getMethodAPIBean(methodBean.getUrl(), projectName);
                    JDSActionContext.getActionContext().getContext().put("MethodBean", methodAPIBean);
                }
                Set paramsKeys = module.getComponent().getCtxBaseComponent().getCtxMap().entrySet();
                for (Map.Entry entry : paramsKeys) {
                    if (entry.getValue() == null) continue;
                    HiddenInputComponent hiddenInputComponent = (HiddenInputComponent)entry.getValue();
                    HiddenInputProperties properties = (HiddenInputProperties)hiddenInputComponent.getProperties();
                    JDSActionContext.getActionContext().getPagectx().put(properties.getName(), properties.getValue());
                }
            }
        }
        catch (JDSException e) {
            response.sendError(500, e.getMessage());
            e.printStackTrace();
        }
        return false;
    }
}

