/*
 * Decompiled with CFR 0.152.
 */
package com.ds.esd.localproxy.handler.dsm;

import com.ds.common.JDSException;
import com.ds.common.md5.MD5;
import com.ds.common.util.StringUtility;
import com.ds.config.JDSUtil;
import com.ds.esd.client.ESDFacrory;
import com.ds.esd.custom.bean.MethodConfig;
import com.ds.esd.localproxy.handler.AbstractRADHandler;
import com.ds.server.httpproxy.core.Handler;
import com.ds.server.httpproxy.core.HttpRequest;
import com.ds.server.httpproxy.core.HttpResponse;
import com.ds.server.httpproxy.core.Server;
import com.ds.server.httpproxy.handler.ResourceHandler;
import com.ds.vfs.FileInfo;
import com.ds.vfs.ct.CtVfsService;
import com.ds.vfs.ct.admin.CtAdminVfsServiceImpl;
import com.ds.web.RequestMethodBean;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Logger;
import java.util.regex.Pattern;

public class DSMClsHandler
extends AbstractRADHandler
implements Handler {
    private static final Logger log = Logger.getLogger(ResourceHandler.class.getName());
    private String resourceMount;
    CtAdminVfsServiceImpl vfsClient;
    Pattern rule;

    public boolean initialize(String handlerName, Server server) {
        super.initialize(handlerName, server);
        this.resourceMount = RESOURCE_MOUNT_OPTION.getProperty(server, handlerName);
        this.rule = Pattern.compile(RULE_OPTION.getProperty(server, handlerName));
        return true;
    }

    protected boolean handleBody(HttpRequest request, HttpResponse response) throws IOException {
        String path = request.getPath();
        boolean ruleMatches = this.rule.matcher(path).matches();
        if (!ruleMatches) {
            return false;
        }
        String projectName = this.getProjectName(request);
        boolean projectMatches = false;
        if (projectName != null) {
            Pattern projectRule = Pattern.compile(".*/(" + projectName + ")?.*");
            projectMatches = projectRule.matcher(path).matches();
        }
        if (!projectMatches) {
            return false;
        }
        path = this.formatPath(request.getUrl(), projectName);
        String mimeType = this.getMimeType(path);
        path = StringUtility.replace((String)path, (String)".js", (String)"");
        path = StringUtility.replace((String)path, (String)".cls", (String)"");
        String className = StringUtility.replace((String)path, (String)this.getUrlPrefix(), (String)".");
        if (projectName.indexOf("VVVERSION") > -1) {
            projectName = projectName.split("VVVERSION")[0];
        }
        File file = new File(JDSUtil.getJdsRealPath() + "webapp/" + projectName + "/cls/" + MD5.getHashString((String)className));
        log.info("className=" + className);
        log.info("file=" + file.getPath());
        RequestMethodBean requestMethodBean = this.getRequestMethodBean(request);
        FileInfo fileInfo = null;
        if (requestMethodBean != null) {
            path = this.formatPath(request.getUrl(), projectName);
            Object stream = null;
            try {
                path = StringUtility.replace((String)path, (String)".js", (String)".cls");
                if (fileInfo == null) {
                    try {
                        fileInfo = ESDFacrory.getESDClient().getFileByPath(new String[]{path, projectName});
                    }
                    catch (JDSException e) {
                        e.printStackTrace();
                    }
                }
                if (fileInfo == null) {
                    try {
                        fileInfo = ESDFacrory.getESDClient().getFileByPath(new String[]{path, "DSMdsm"});
                    }
                    catch (JDSException e) {
                        e.printStackTrace();
                    }
                }
                if (fileInfo == null) {
                    fileInfo = this.getVfsClient().getFileByPath(path);
                }
            }
            catch (JDSException e) {
                e.printStackTrace();
            }
        }
        if (fileInfo != null) {
            if (!file.exists()) {
                file = new File(JDSUtil.getJdsRealPath() + this.resourceMount + this.getUrlPrefix() + projectName + "/cls/" + MD5.getHashString((String)className));
            }
            if (!file.exists()) {
                file = new File(JDSUtil.getJdsRealPath() + "webapp//DSMdsm/cls/" + MD5.getHashString((String)className));
            }
            if (!file.exists()) {
                file = new File(JDSUtil.getJdsRealPath() + this.resourceMount + "/DSMdsm/cls/" + MD5.getHashString((String)className));
            }
        }
        FileInputStream is = null;
        if (file != null && file.exists()) {
            is = new FileInputStream(file);
            if (mimeType == null || is == null) {
                log.warning("Resource was not found or the mime type was not understood. (Found file=" + (is != null) + ") (Found mime-type=" + (mimeType != null) + ")");
                return false;
            }
            if (is != null) {
                response.setMimeType(mimeType);
                response.sendResponse((InputStream)is, Integer.valueOf(Long.toString(file.length())).intValue());
                return true;
            }
            return false;
        }
        if (requestMethodBean != null) {
            MethodConfig methodConfig = null;
            try {
                methodConfig = ESDFacrory.getESDClient().getMethodAPIBean(path, projectName);
            }
            catch (JDSException e) {
                e.printStackTrace();
            }
            if (methodConfig != null && methodConfig.isModule()) {
                return this.sendModule(className, request, response);
            }
            return false;
        }
        return false;
    }

    public CtVfsService getVfsClient() {
        if (this.vfsClient == null) {
            this.vfsClient = new CtAdminVfsServiceImpl();
        }
        return this.vfsClient;
    }
}

