/*
 * Decompiled with CFR 0.152.
 */
package com.ds.esd.localproxy.handler;

import com.alibaba.fastjson.JSONObject;
import com.ds.common.util.IOUtility;
import com.ds.server.httpproxy.core.AbstractHandler;
import com.ds.server.httpproxy.core.ConfigOption;
import com.ds.server.httpproxy.core.HttpRequest;
import com.ds.server.httpproxy.core.HttpResponse;
import com.ds.server.httpproxy.core.Server;
import com.ds.server.httpproxy.handler.ResourceHandler;
import com.ds.server.httpproxy.handler.multipart.SimpleRequestContext;
import com.ds.template.JDSFreemarkerResult;
import freemarker.template.TemplateException;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.RequestContext;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.portlet.PortletFileUpload;
import org.apache.http.Header;
import org.apache.http.client.fluent.Form;
import org.apache.http.client.fluent.Request;
import org.apache.http.client.fluent.Response;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.InputStreamBody;
import org.apache.http.util.CharsetUtils;

public class HttpProxyHandler
extends AbstractHandler {
    private static final Logger log = Logger.getLogger(ResourceHandler.class.getName());
    public static final ConfigOption PEOXYSERVER_OPTION = new ConfigOption("proxyServerUrl", "http://192.168.5.47:5338", "Regular expression for matching URLs.");
    Pattern rule;
    private String proxyurl;

    public boolean initialize(String handlerName, Server server) {
        super.initialize(handlerName, server);
        this.rule = Pattern.compile(RULE_OPTION.getProperty(server, handlerName));
        this.proxyurl = PEOXYSERVER_OPTION.getProperty(server, handlerName);
        return true;
    }

    protected boolean handleBody(HttpRequest request, HttpResponse response) throws IOException {
        boolean ruleMatches = this.rule.matcher(request.getUrl()).matches();
        if (!ruleMatches) {
            return false;
        }
        String resource = request.getUrl();
        String mimeType = this.getMimeType(resource);
        if (mimeType != null) {
            response.setMimeType(mimeType);
        }
        String contentType = this.getContentType(request);
        if (request.getMethod().toUpperCase().equals("GET")) {
            return this.sendGet(request, response, this.proxyurl);
        }
        if (contentType != null && contentType.indexOf("application/octet-stream") > -1) {
            return this.sendStreamProxy(request, response, this.proxyurl);
        }
        if (contentType != null && contentType.indexOf("multipart/form-data") > -1) {
            return this.sendMultiparPostProxy(request, response, this.proxyurl);
        }
        if (request.getMethod().toUpperCase().equals("POST")) {
            return this.sendPostProxy(request, response, this.proxyurl);
        }
        return true;
    }

    public boolean sendStreamProxy(HttpRequest request, HttpResponse response, String url) throws IOException {
        String resource = this.formartUrl(request, url);
        Request remoteRequest = Request.Post((String)resource);
        Map headers = request.getHeaders().toMap();
        for (String name : headers.keySet()) {
            if (name.toLowerCase().equals("content-length")) continue;
            remoteRequest.addHeader(name, (String)headers.get(name));
        }
        return this.executeResponse(response, remoteRequest);
    }

    public boolean sendFtl(HttpRequest request, HttpResponse response, String resource) throws IOException {
        String responseStr = "";
        try {
            JDSFreemarkerResult result = new JDSFreemarkerResult();
            StringWriter stringWriter = (StringWriter)result.doExecute(resource, null);
            responseStr = stringWriter.toString();
        }
        catch (TemplateException e) {
            e.printStackTrace();
        }
        response.setMimeType("text/html");
        response.sendResponse(this.getInputStream(responseStr, "utf-8"), -1);
        return true;
    }

    public boolean sendGet(HttpRequest request, HttpResponse response, String url) throws IOException {
        String resource = this.formartUrl(request, url);
        Request remoteRequest = Request.Get((String)resource);
        Map headers = request.getHeaders().toMap();
        for (String name : headers.keySet()) {
            remoteRequest.addHeader(name, (String)headers.get(name));
        }
        return this.executeResponse(response, remoteRequest);
    }

    public boolean sendPostProxy(HttpRequest request, HttpResponse response, String url) throws IOException {
        String resource = this.formartUrl(request, url);
        Request remoteRequest = Request.Post((String)resource);
        Map headers = request.getHeaders().toMap();
        for (String name : headers.keySet()) {
            if (name.toLowerCase().equals("content-length")) continue;
            remoteRequest.addHeader(name, (String)headers.get(name));
        }
        if (this.getContentType(request).indexOf("application/json") > -1) {
            String userData = JSONObject.toJSON((Object)IOUtility.toString((byte[])request.getPostData())).toString();
            remoteRequest.bodyString(userData, ContentType.APPLICATION_JSON);
        } else {
            Map paramsMap = request.getParameterMap();
            Form form = Form.form();
            for (String name : paramsMap.keySet()) {
                form.add(name, (String)paramsMap.get(name));
            }
            remoteRequest.bodyForm((Iterable)form.build(), Charset.forName("UTF-8"));
        }
        return this.executeResponse(response, remoteRequest);
    }

    public boolean sendMultiparPostProxy(HttpRequest request, HttpResponse response, String url) throws IOException {
        String resource = this.formartUrl(request, url);
        Request remoteRequest = Request.Post((String)resource);
        Map headers = request.getHeaders().toMap();
        for (String name : headers.keySet()) {
            if (!name.toLowerCase().equals("origin") && !name.toLowerCase().equals("Referer") && !name.toLowerCase().equals("cookie")) continue;
            remoteRequest.addHeader(name, (String)headers.get(name));
        }
        MultipartEntityBuilder reqEntitybuild = MultipartEntityBuilder.create().setMode(HttpMultipartMode.BROWSER_COMPATIBLE).setCharset(CharsetUtils.get((String)"ctvfs"));
        SimpleRequestContext requestContext = new SimpleRequestContext(StandardCharsets.UTF_8, this.getContentType(request), (InputStream)new ByteArrayInputStream(request.getPostData()));
        PortletFileUpload fileUploadBase = new PortletFileUpload();
        DiskFileItemFactory fileItemFactory = new DiskFileItemFactory();
        fileUploadBase.setFileItemFactory((FileItemFactory)fileItemFactory);
        fileUploadBase.setHeaderEncoding("ctvfs");
        List fileItems = null;
        try {
            fileItems = fileUploadBase.parseRequest((RequestContext)requestContext);
        }
        catch (FileUploadException e) {
            e.printStackTrace();
        }
        for (FileItem f : fileItems) {
            if (!f.isFormField()) {
                String fileName = f.getName();
                InputStreamBody fileStream = new InputStreamBody(f.getInputStream(), fileName);
                reqEntitybuild.addPart(f.getFieldName(), (ContentBody)fileStream);
                continue;
            }
            if (f != null && f.get() != null && f.get().length > 0) {
                reqEntitybuild.addTextBody(f.getFieldName(), f.getString("ctvfs"));
                continue;
            }
            reqEntitybuild.addTextBody(f.getFieldName(), "");
        }
        remoteRequest = remoteRequest.body(reqEntitybuild.build());
        return this.executeResponse(response, remoteRequest);
    }

    public void copyStreamToFile(String url, File file) throws IOException {
        URL source = new URL(url);
        if (file.getParentFile() != null && !file.getParentFile().exists()) {
            file.getParentFile().mkdirs();
        }
        if (file.exists() && !file.canWrite()) {
            String message = "Unable to open file " + file + " for writing.";
            throw new IOException(message);
        }
        InputStream input = source.openStream();
        FileOutputStream output = new FileOutputStream(file);
        IOUtility.copy((InputStream)input, (OutputStream)output);
        IOUtility.shutdownStream((InputStream)input);
        IOUtility.shutdownStream((OutputStream)output);
    }

    protected String getMimeType(String filename) {
        int index = filename.lastIndexOf(".");
        String mimeType = null;
        if (index > 0) {
            mimeType = this.server.getProperty("mime" + filename.substring(index).toLowerCase());
        }
        return mimeType;
    }

    private boolean executeResponse(HttpResponse response, Request remoteRequest) throws IOException {
        Response remoteresponse = remoteRequest.execute();
        org.apache.http.HttpResponse httpResponse = remoteresponse.returnResponse();
        Header[] reqheards = httpResponse.getAllHeaders();
        response.addHeader("Transfer-Encoding", null);
        for (Header header : reqheards) {
            if (header.getName().equals("Transfer-Encoding")) continue;
            response.addHeader(header.getName(), header.getValue());
        }
        if (httpResponse.getEntity().getContentLength() > 0L) {
            response.addHeader("Content-Length", httpResponse.getEntity().getContentLength() + "");
            response.addHeader("Transfer-Encoding", null);
        }
        InputStream stream = httpResponse.getEntity().getContent();
        response.sendResponse(stream, Integer.valueOf(Long.toString(httpResponse.getEntity().getContentLength())).intValue());
        return true;
    }

    public String getContentType(HttpRequest request) {
        String contentType = request.getRequestHeader("Content-Type");
        if (contentType == null) {
            contentType = request.getRequestHeader("Content-type");
        }
        return contentType;
    }

    public InputStream getInputStream(String content, String charSet) {
        if (content == null) {
            return null;
        }
        try {
            return new ByteArrayInputStream(content.getBytes(charSet));
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    protected String formartUrl(HttpRequest request, String url) {
        String resource = request.getUrl();
        String queryStr = request.getQuery();
        if (queryStr != null && !queryStr.equals("")) {
            resource = resource + "?" + queryStr;
        }
        if (resource.startsWith("http://")) {
            resource = resource.substring("http://".length());
        }
        resource = url + resource;
        return resource;
    }
}

