/*
 * Decompiled with CFR 0.152.
 */
package com.ds.esd.localproxy.handler;

import com.alibaba.fastjson.JSONObject;
import com.ds.common.logging.Log;
import com.ds.common.logging.LogFactory;
import com.ds.common.md5.MD5;
import com.ds.config.ErrorResultModel;
import com.ds.config.JDSUtil;
import com.ds.config.ResultModel;
import com.ds.esd.localproxy.handler.AbstractRADHandler;
import com.ds.server.httpproxy.core.ConfigOption;
import com.ds.server.httpproxy.core.HttpRequest;
import com.ds.server.httpproxy.core.HttpResponse;
import com.ds.server.httpproxy.core.Server;
import com.ds.web.RequestMethodBean;
import com.ds.web.util.JSONGenUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.regex.Pattern;

public class DSMSpringMVCHandler
extends AbstractRADHandler {
    public static final ConfigOption RULE_OPTION = new ConfigOption("rule", true, "Regular expression for matching URLs.");
    private static final Log logger = LogFactory.getLog((String)"JDS", DSMSpringMVCHandler.class);
    Pattern rule;

    public boolean initialize(String handlerName, Server server) {
        super.initialize(handlerName, server);
        this.rule = Pattern.compile(RULE_OPTION.getProperty(server, handlerName));
        return true;
    }

    protected boolean handleBody(HttpRequest request, HttpResponse response) throws IOException {
        boolean ruleMatches = this.rule.matcher(request.getUrl()).matches();
        if (!ruleMatches) {
            return false;
        }
        logger.info((Object)("request url " + request.getUrl()));
        RequestMethodBean methodBean = this.getRequestMethodBean(request);
        if (methodBean == null) {
            return false;
        }
        try {
            Object object = null;
            String contentType = this.getContentType(request);
            object = contentType != null && contentType.indexOf("multipart/form-data") > -1 ? this.upload(methodBean, request, response) : this.invokMethod(methodBean, request, response);
            Class iClass = JSONGenUtil.getInnerReturnType((Method)methodBean.getSourceMethod());
            if (!InputStream.class.isAssignableFrom(iClass)) {
                String json = object.toString();
                if (json.endsWith(".ftl")) {
                    return this.sendFtl(request, response, json);
                }
                if (methodBean.getResponseBody() != null) {
                    json = JSONObject.toJSONString((Object)object);
                }
                return this.sendJSON(methodBean, response, json);
            }
            ResultModel resultModel = (ResultModel)this.invokMethod(methodBean, request, response);
            InputStream inputStream = (InputStream)resultModel.get();
            if (inputStream != null) {
                String mdrStr = MD5.getHashString((InputStream)inputStream);
                File file = new File(JDSUtil.getJdsRealPath() + "temp" + File.separator + mdrStr + ".temp");
                response.addHeader("Content-disposition", "filename=" + new String(file.getName().getBytes("utf-8"), "ISO8859-1"));
                response.addHeader("Content-Length", String.valueOf(file.length()));
                response.sendResponse(inputStream, Integer.valueOf(Long.toString(file.length())).intValue());
            }
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            ErrorResultModel resultModel = new ErrorResultModel();
            resultModel.setErrdes(e.getMessage());
            return this.sendJSON(methodBean, response, JSONObject.toJSONString((Object)resultModel, (boolean)false));
        }
    }
}

