/*
 * Decompiled with CFR 0.152.
 */
package com.ds.esd.localproxy.handler;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.util.TypeUtils;
import com.ds.common.JDSException;
import com.ds.common.util.ClassUtility;
import com.ds.common.util.IOUtility;
import com.ds.config.ListResultModel;
import com.ds.config.ResultModel;
import com.ds.config.TreeListResultModel;
import com.ds.context.JDSActionContext;
import com.ds.enums.service.RequestType;
import com.ds.esd.client.ESDClient;
import com.ds.esd.client.ESDFacrory;
import com.ds.esd.client.ProjectVersion;
import com.ds.esd.custom.CustomViewFactory;
import com.ds.esd.custom.DataComponent;
import com.ds.esd.custom.bean.CustomDynDataBean;
import com.ds.esd.custom.bean.CustomModuleBean;
import com.ds.esd.custom.bean.MethodConfig;
import com.ds.esd.custom.module.annotation.DynLoadAnnotation;
import com.ds.esd.editor.enums.PackagePathType;
import com.ds.esd.editor.enums.PackageType;
import com.ds.esd.tool.module.EUModule;
import com.ds.esd.tool.ui.component.Component;
import com.ds.esd.tool.ui.component.data.APICallerComponent;
import com.ds.esd.tool.ui.component.panel.grid.PageBarComponent;
import com.ds.esd.tool.ui.enums.ComponentType;
import com.ds.esd.tool.ui.module.ModuleComponent;
import com.ds.server.httpproxy.core.AbstractHandler;
import com.ds.server.httpproxy.core.HttpRequest;
import com.ds.server.httpproxy.core.HttpResponse;
import com.ds.server.httpproxy.core.Request;
import com.ds.server.httpproxy.core.Response;
import com.ds.web.BaseParamsEnums;
import com.ds.web.RequestMethodBean;
import com.ds.web.RequestParamBean;
import com.ds.web.util.AnnotationUtil;
import com.ds.web.util.JSONGenUtil;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ognl.OgnlContext;
import ognl.OgnlException;
import ognl.OgnlRuntime;
import org.springframework.web.bind.annotation.RequestBody;

public abstract class AbstractRADHandler
extends AbstractHandler {
    public boolean sendModule(String className, HttpRequest request, HttpResponse response) {
        try {
            ESDClient client = ESDFacrory.getESDClient();
            EUModule module = null;
            String projectName = this.getProjectName(request);
            RequestMethodBean requestMethodBean = this.getRequestMethodBean(request);
            PackagePathType packagePathType = null;
            Map allParamsMap = this.getAllParamMap(requestMethodBean, request);
            if (requestMethodBean.getUrl().indexOf("/") > -1) {
                String packageUrl = requestMethodBean.getUrl().substring(0, requestMethodBean.getUrl().lastIndexOf("/"));
                packagePathType = PackagePathType.startPath((String)packageUrl);
            }
            if ((module = packagePathType == null || packagePathType.getApiType().equals((Object)PackageType.local) ? client.getModule(className, projectName, true) : client.getDSMModule(className, allParamsMap)) == null) {
                MethodConfig methodConfig = CustomViewFactory.getInstance().getMethodAPIBean(className, projectName);
                module = CustomViewFactory.getInstance().buildView(methodConfig, projectName, allParamsMap, false);
                ModuleComponent moduleComponent = module.getComponent();
                if (moduleComponent.getProperties().getDynLoad() != null && moduleComponent.getProperties().getDynLoad().booleanValue()) {
                    client.saveModule(module);
                }
            }
            if (JSONGenUtil.getInnerReturnType((RequestMethodBean)requestMethodBean).isAssignableFrom(EUModule.class)) {
                Object service = this.getService(requestMethodBean, request);
                ResultModel resultModel = (ResultModel)OgnlRuntime.callMethod((OgnlContext)this.getOgnlContext(), (Object)service, (String)requestMethodBean.getMethodName(), (Object[])new Object[]{module});
                module = (EUModule)resultModel.get();
            }
            if (module == null) {
                return false;
            }
            module.getComponent().fillParams(requestMethodBean.getParamSet(), allParamsMap);
            module.getComponent().fillFormValues(allParamsMap, false);
            String mimeType = "application/javascript";
            String json = client.genJSON(module, null).toString();
            response.sendResponse(json, mimeType + ";");
        }
        catch (Exception e) {
            response.sendError(500, e.getMessage());
            e.printStackTrace();
        }
        return true;
    }

    private EUModule getEUModule(RequestMethodBean methodBean, HttpRequest request, Map<String, Object> allParamsMap) {
        EUModule module = null;
        try {
            MethodConfig methodAPIBean = ESDFacrory.getESDClient().getMethodAPIBean(methodBean.getUrl(), this.getProjectName(request));
            CustomDynDataBean customDynDataBean = methodAPIBean.getDynDataBean();
            CustomModuleBean moduleAnnotation = methodAPIBean.getModuleBean();
            Object obj = allParamsMap.get("_currClassName_");
            if (customDynDataBean != null && moduleAnnotation != null) {
                if (!customDynDataBean.getRefClassName().equals("")) {
                    ProjectVersion projectVersion;
                    String projectName = customDynDataBean.getProjectName();
                    if (projectName.equals("")) {
                        projectName = this.getProjectName(request);
                    }
                    if ((module = (projectVersion = ESDFacrory.getESDClient().getProjectVersionByName(projectName)).getModule(customDynDataBean.getRefClassName())) == null) {
                        module = ESDFacrory.getESDClient().rebuildCustomModule(customDynDataBean.getRefClassName(), projectName, allParamsMap);
                    }
                    if (module != null) {
                        module.getComponent().getRealModuleComponent().fillFormValues(allParamsMap, true);
                    }
                } else {
                    String projectName = this.getProjectName(request);
                    Class componentClass = JSONGenUtil.getInnerReturnType((Method)methodAPIBean.getMethod());
                    module = ModuleComponent.class.isAssignableFrom(componentClass) ? ESDFacrory.getESDClient().buildDynCustomModule(componentClass, allParamsMap, true) : CustomViewFactory.getInstance().createRealView(methodAPIBean, null, projectName, allParamsMap, true);
                }
            } else {
                String projectName = this.getProjectName(request);
                String currClassName = obj.toString();
                module = ESDFacrory.getESDClient().getModule(currClassName, projectName);
                if (module == null) {
                    module = ESDFacrory.getESDClient().getDSMModule(currClassName, allParamsMap);
                }
                if (module != null) {
                    module.getComponent().getRealModuleComponent().fillFormValues(allParamsMap, true);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return module;
    }

    public Object invokMethod(RequestMethodBean methodBean, HttpRequest request, HttpResponse response) throws ClassNotFoundException, OgnlException {
        Object object = null;
        Object service = this.getService(methodBean, request);
        Map allParamsMap = this.getAllParamMap(methodBean, request);
        Map paramsMap = methodBean.getParamsMap();
        Set keySet = methodBean.getParamSet();
        ArrayList<HttpRequest> objects = new ArrayList<HttpRequest>();
        ArrayList<Class> objectTyps = new ArrayList<Class>();
        DynLoadAnnotation dynAnnotation = (DynLoadAnnotation)AnnotationUtil.getMethodAnnotation((Method)methodBean.getSourceMethod(), DynLoadAnnotation.class);
        ModuleComponent moduleComponent = null;
        for (RequestParamBean paramBean : keySet) {
            Class ctClass = ClassUtility.loadClass((String)((String)paramsMap.get(paramBean.getParamName())));
            String iClassName = ctClass.getName();
            Class iClass = ClassUtility.loadClass((String)iClassName);
            String key = paramBean.getParamName();
            Object[] value = null;
            try {
                RequestBody requestBody = null;
                for (Annotation annotation : paramBean.getAnnotations()) {
                    if (!annotation.annotationType().equals(RequestBody.class)) continue;
                    requestBody = (RequestBody)annotation;
                }
                if (requestBody != null) {
                    if (methodBean.getRequestType().equals((Object)RequestType.JSON)) {
                        String jsonData = IOUtility.toString((byte[])request.getPostData());
                        JSONObject requestBodyValue = JSONObject.parseObject((String)jsonData);
                        for (BaseParamsEnums baseParams : BaseParamsEnums.values()) {
                            if (!requestBodyValue.containsKey((Object)baseParams.name())) continue;
                            JDSActionContext.getActionContext().getContext().put(baseParams.name(), requestBodyValue.get((Object)baseParams.name()));
                        }
                        value = JSONObject.parseObject((String)jsonData, (Class)paramBean.getParamClass());
                    }
                } else if (Request.class.isAssignableFrom(iClass)) {
                    value = request;
                } else if (ModuleComponent.class.isAssignableFrom(iClass)) {
                    if (moduleComponent == null) {
                        moduleComponent = this.getEUModule(methodBean, request, allParamsMap).getComponent().getRealModuleComponent();
                    }
                    value = moduleComponent;
                } else if (EUModule.class.isAssignableFrom(iClass)) {
                    value = this.getEUModule(methodBean, request, allParamsMap);
                } else if (Response.class.isAssignableFrom(iClass)) {
                    value = response;
                } else {
                    switch (methodBean.getRequestType()) {
                        case FORM: {
                            if (iClass.isArray()) {
                                if (JSONObject.parseArray((String)allParamsMap.get(key).toString()).size() > 0) {
                                    value = JSONObject.parseArray((String)allParamsMap.get(key).toString(), iClass.getComponentType()).toArray();
                                    break;
                                }
                                value = Array.newInstance(iClass.getComponentType(), 0);
                                break;
                            }
                            if (paramBean.getJsonData().booleanValue()) {
                                value = JSONObject.parseObject((String)allParamsMap.get(key).toString(), (Class)iClass);
                                break;
                            }
                            value = TypeUtils.cast(allParamsMap.get(key), (Class)iClass, null);
                            break;
                        }
                        default: {
                            value = TypeUtils.cast(allParamsMap.get(paramBean.getParamName()), (Class)iClass, null);
                        }
                    }
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
                logger.error((Object)("\u53c2\u6570\u8f6c\u6362\u9519\u8bef\uff1a  [" + paramBean.getParamName() + "] convertValue err " + e.getMessage()));
            }
            objectTyps.add(iClass);
            objects.add((HttpRequest)value);
        }
        if (service != null) {
            if (dynAnnotation != null) {
                object = OgnlRuntime.callMethod((OgnlContext)this.getOgnlContext(), (Object)service, (String)methodBean.getMethodName(), (Object[])objects.toArray());
                if (JSONGenUtil.getInnerReturnType((RequestMethodBean)methodBean).isAssignableFrom(EUModule.class)) {
                    EUModule otherModule = (EUModule)((ResultModel)object).getData();
                    try {
                        ((ResultModel)object).setData((Object)otherModule.getRealComponents(true));
                    }
                    catch (JDSException e) {
                        e.printStackTrace();
                    }
                } else if (!JSONGenUtil.getInnerReturnType((RequestMethodBean)methodBean).isAssignableFrom(Component.class) || !dynAnnotation.refClassName().equals("")) {
                    if (moduleComponent == null) {
                        try {
                            moduleComponent = this.getEUModule(methodBean, request, allParamsMap).getComponent().getRealModuleComponent().clone();
                        }
                        catch (JDSException e) {
                            e.printStackTrace();
                        }
                    }
                    if (moduleComponent != null) {
                        ResultModel resultModel = (ResultModel)object;
                        boolean syncLoad = false;
                        if (moduleComponent instanceof DataComponent) {
                            List componentList = moduleComponent.findComponents(ComponentType.APICaller, "Reload");
                            for (APICallerComponent api : componentList) {
                                if (!api.getAlias().equals("Reload") || !api.getProperties().getAutoRun().booleanValue()) continue;
                                syncLoad = true;
                            }
                            if (syncLoad) {
                                ((DataComponent)moduleComponent).setData(resultModel.getData());
                                if (!(resultModel instanceof TreeListResultModel) && resultModel instanceof ListResultModel) {
                                    ListResultModel listResultModel = (ListResultModel)object;
                                    List pageBarComponents = moduleComponent.findComponents(ComponentType.PageBar, null);
                                    if (pageBarComponents.size() > 0) {
                                        ((PageBarComponent)pageBarComponents.get(0)).setData(Integer.valueOf(listResultModel.getSize()));
                                    }
                                }
                            }
                        }
                    }
                    ((ResultModel)object).setData((Object)moduleComponent.getTopComponents(true));
                }
            } else {
                object = OgnlRuntime.callMethod((OgnlContext)this.getOgnlContext(), (Object)service, (String)methodBean.getMethodName(), (Object[])objects.toArray());
            }
        } else {
            object = OgnlRuntime.callMethod((OgnlContext)this.getOgnlContext(), (Object)service, (String)methodBean.getMethodName(), (Object[])objects.toArray());
        }
        return object;
    }
}

