/*
 * Decompiled with CFR 0.152.
 */
package com.ds.esd.dic.org;

import com.ds.common.logging.Log;
import com.ds.common.logging.LogFactory;
import com.ds.context.JDSActionContext;
import com.ds.esd.dic.org.UINode;
import com.ds.org.Org;
import com.ds.org.OrgNotFoundException;
import com.ds.org.Person;
import com.ds.org.conf.OrgConstants;
import com.ds.server.OrgManagerFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.cglib.beans.BeanMap;

public class PersonExtTree {
    protected static Log log = LogFactory.getLog((String)OrgConstants.CONFIG_KEY.getType(), PersonExtTree.class);
    private List<Person> persons = new ArrayList<Person>();
    private List<Org> orgs = new ArrayList<Org>();
    private Org topOrg;
    private String topOrgId;
    private boolean viewPerson = true;
    private boolean signSelect = false;

    public boolean isViewPerson() {
        return this.viewPerson;
    }

    public void setViewPerson(boolean viewPerson) {
        this.viewPerson = viewPerson;
    }

    public boolean isSignSelect() {
        return this.signSelect;
    }

    public void setSignSelect(boolean signSelect) {
        this.signSelect = signSelect;
    }

    public PersonExtTree(List<Person> persons, String topOrgId, boolean viewPerson, boolean signSelect) {
        HashMap orgMap = new HashMap();
        this.viewPerson = viewPerson;
        this.signSelect = signSelect;
        this.topOrgId = topOrgId == null ? ((Org)OrgManagerFactory.getOrgManager().getTopOrgs(JDSActionContext.getActionContext().getSystemCode()).get(0)).getOrgId() : topOrgId;
        try {
            Org topOrg = OrgManagerFactory.getOrgManager().getOrgByID(this.topOrgId);
            if (topOrg != null && persons == null) {
                persons = topOrg.getPersonListRecursively();
            }
        }
        catch (OrgNotFoundException e) {
            e.printStackTrace();
        }
        for (int i = 0; i < persons.size(); ++i) {
            Person perosn = (Person)persons.get(i);
            List orgs = perosn.getOrgList();
            if (orgs == null) continue;
            for (Org org : orgs) {
                if (orgMap.containsKey(org.getOrgId())) continue;
                this.addOrg(orgMap, org);
            }
        }
        this.orgs.addAll(orgMap.values());
        this.persons = persons;
    }

    public UINode getChildTree(String orgId) {
        if (orgId == null) {
            return this.getTopTree();
        }
        Org org = null;
        try {
            org = OrgManagerFactory.getOrgManager().getOrgByID(orgId);
        }
        catch (OrgNotFoundException e) {
            e.printStackTrace();
        }
        UINode childNode = null;
        if (org != null && this.isOrgInOrgs(org, this.orgs)) {
            childNode = new UINode();
            childNode.setId(org.getOrgId());
            childNode.setCaption(org.getName());
            if (this.viewPerson) {
                this.addPersonItem(childNode, org);
            }
            if (org.getChildrenList().size() > 0) {
                List list = org.getChildrenList();
                CommonComparator comparator = new CommonComparator();
                comparator.setFields_user(new String[]{"index"});
                Collections.sort(list, comparator);
                for (int j = 0; j < list.size(); ++j) {
                    Org ccorg = (Org)list.get(j);
                    if (!this.isOrgInOrgs(ccorg, this.orgs)) continue;
                    this.addChildNode(childNode, ccorg, this.orgs);
                }
            }
        }
        return childNode;
    }

    private UINode getTopTree() {
        String rootStr = "\u70b9\u51fb\u9009\u62e9\u7ec4\u7ec7\u673a\u6784";
        UINode<UINode> root = new UINode<UINode>();
        try {
            this.topOrg = OrgManagerFactory.getOrgManager().getOrgByID(this.topOrgId);
        }
        catch (OrgNotFoundException e) {
            e.printStackTrace();
        }
        root.setId(this.topOrg.getOrgId());
        root.setSignSelect(this.signSelect);
        root.setCaption(this.topOrg.getName());
        if (this.orgs.size() == 0) {
            rootStr = "\u6ca1\u6709\u8bbe\u5b9a";
            root.setCaption(rootStr);
        } else {
            ArrayList list = new ArrayList();
            for (int k = 0; k < this.topOrg.getChildrenList().size(); ++k) {
                list.add(this.topOrg.getChildrenList().get(k));
            }
            CommonComparator comparator = new CommonComparator();
            comparator.setFields_user(new String[]{"index"});
            Collections.sort(list, comparator);
            for (int k = 0; k < list.size(); ++k) {
                UINode node = this.getChildTree(((Org)list.get(k)).getOrgId());
                if (node == null) continue;
                root.addSub(node);
            }
        }
        return root;
    }

    private void addOrg(Map map, Org org) {
        if (org != null) {
            map.put(org.getOrgId(), org);
            Org parent = org.getParent();
            if (parent != null) {
                if (this.topOrgId != null && org.getOrgId().equals(this.topOrgId)) {
                    this.topOrg = parent;
                    map.put(parent.getOrgId(), parent);
                } else if (!map.containsKey(parent.getOrgId())) {
                    this.addOrg(map, parent);
                }
            } else {
                this.topOrg = org;
            }
        }
    }

    private boolean isOrgInOrgs(Org org, List<Org> orgs) {
        for (Org corg : orgs) {
            if (!org.getOrgId().equals(corg.getOrgId())) continue;
            return Boolean.TRUE;
        }
        return false;
    }

    protected void addPersonItem(UINode parentnode, Org org) {
        CommonComparator comparator = new CommonComparator();
        comparator.setFields_user(new String[]{"index"});
        Collections.sort(this.persons, comparator);
        for (int i = 0; this.persons.size() > i; ++i) {
            Person person = this.persons.get(i);
            if (!this.isPersonInOrg(org, person.getID())) continue;
            UINode inputNode = new UINode();
            inputNode.setId(person.getID());
            inputNode.setCaption(person.getName());
            inputNode.setImageClass("bpmfont bpmgongzuoliu");
            parentnode.addSub(inputNode);
        }
    }

    private boolean isPersonInOrg(Org org, String personId) {
        List personList = org.getPersonList();
        for (Person person : personList) {
            if (!personId.equalsIgnoreCase(person.getID())) continue;
            return Boolean.TRUE;
        }
        return false;
    }

    private UINode addChildNode(UINode parentnode, Org org, List<Org> orgs) {
        if (this.isOrgInOrgs(org, orgs)) {
            UINode inputNode = new UINode();
            inputNode.setId(org.getOrgId());
            inputNode.setCaption(org.getName());
            inputNode.setImageClass("xui-icon-menu");
            parentnode.addSub(inputNode);
            List childs = org.getChildrenList();
            for (Org corg : childs) {
                this.addChildNode(inputNode, corg, orgs);
            }
            if (this.viewPerson) {
                this.addPersonItem(inputNode, org);
            }
        }
        return parentnode;
    }

    class CommonComparator
    implements Comparator {
        String[] fields_user = null;

        CommonComparator() {
        }

        public String[] getFields_user() {
            return this.fields_user;
        }

        public void setFields_user(String[] fields_user) {
            this.fields_user = fields_user;
        }

        public int compare(Object obj1, Object obj2) {
            if (this.fields_user == null || this.fields_user.length <= 0) {
                return 2;
            }
            int i = 0;
            if (i < this.fields_user.length) {
                if (this.compareField(obj1, obj2, this.fields_user[i])) {
                    return 1;
                }
                return -1;
            }
            return 0;
        }

        private boolean compareField(Object o1, Object o2, String fieldName) {
            try {
                Object value1 = BeanMap.create((Object)o1).get((Object)fieldName);
                Object value2 = BeanMap.create((Object)o2).get((Object)fieldName);
                if (value1 != null && value2 != null && Integer.parseInt(value1.toString()) > Integer.parseInt(value2.toString())) {
                    return true;
                }
            }
            catch (Exception e) {
                log.info((Object)"---------\u5bf9\u8c61\u7684\u8be5\u5c5e\u6027\u4e0d\u5b58\u5728\u6216\u8005\u4e0d\u5141\u8bb8\u5728\u6b64\u5b89\u5168\u7ea7\u522b\u4e0a\u53cd\u5c04\u8be5\u5c5e\u6027\uff0c\u8be6\u60c5\u8bf7\u67e5\u9605JAVA DOC--------");
                e.printStackTrace();
            }
            return false;
        }
    }
}

