/*
 * Decompiled with CFR 0.152.
 */
package com.ds.esd.dic.file;

import com.ds.common.JDSException;
import com.ds.common.logging.Log;
import com.ds.common.logging.LogFactory;
import com.ds.esd.client.ESDFacrory;
import com.ds.esd.dic.file.UIFileNode;
import com.ds.org.conf.OrgConstants;
import com.ds.vfs.Folder;
import com.ds.vfs.ct.CtVfsFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.cglib.beans.BeanMap;

public class FolderExtTree {
    protected static Log log = LogFactory.getLog((String)OrgConstants.CONFIG_KEY.getType(), FolderExtTree.class);
    private List<Folder> folders = new ArrayList<Folder>();
    private Folder topFolder;
    private String topFolderId;
    private boolean signSelect = false;

    public boolean isSignSelect() {
        return this.signSelect;
    }

    public void setSignSelect(boolean signSelect) {
        this.signSelect = signSelect;
    }

    public FolderExtTree(List<Folder> allfolders, String topFolderId, boolean signSelect) {
        HashMap<String, Folder> folderMap = new HashMap<String, Folder>();
        this.folders = allfolders;
        this.signSelect = signSelect;
        try {
            this.topFolderId = topFolderId == null ? ESDFacrory.getESDClient().getSpace().getId() : topFolderId;
            Folder topFolder = CtVfsFactory.getCtVfsService().getFolderById(this.topFolderId);
            if (topFolder != null && this.folders == null) {
                this.folders = topFolder.getChildrenRecursivelyList();
            }
        }
        catch (JDSException e) {
            e.printStackTrace();
        }
        for (Folder folder : this.folders) {
            if (!folderMap.containsKey(folder.getID())) {
                this.addFolder(folderMap, folder);
            }
            if (folder == null || folderMap.containsKey(folder.getID())) continue;
            this.addFolder(folderMap, folder);
        }
        this.folders.addAll(folderMap.values());
    }

    public UIFileNode getChildTree(String folderId) {
        if (folderId == null) {
            return this.getTopTree();
        }
        Folder folder = null;
        try {
            folder = CtVfsFactory.getCtVfsService().getFolderById(folderId);
        }
        catch (JDSException e) {
            e.printStackTrace();
        }
        UIFileNode childNode = null;
        if (folder != null && this.isFolderInFolders(folder, this.folders)) {
            childNode = new UIFileNode();
            childNode.setId(folder.getPath());
            childNode.setCaption(folder.getName());
            if (folder.getChildrenList().size() > 0) {
                List list = folder.getChildrenList();
                CommonComparator comparator = new CommonComparator();
                comparator.setFields_user(new String[]{"index"});
                Collections.sort(list, comparator);
                for (int j = 0; j < list.size(); ++j) {
                    Folder cfolder = (Folder)list.get(j);
                    if (!this.isFolderInFolders(cfolder, this.folders)) continue;
                    this.addChildNode(childNode, cfolder, this.folders);
                }
            }
        }
        return childNode;
    }

    private UIFileNode getTopTree() {
        String rootStr = "\u6240\u6709\u6587\u4ef6";
        UIFileNode root = new UIFileNode();
        try {
            this.topFolder = CtVfsFactory.getCtVfsService().getFolderById(this.topFolderId);
        }
        catch (JDSException e) {
            e.printStackTrace();
        }
        root.setId(this.topFolder.getPath());
        root.setSignSelect(this.signSelect);
        root.setCaption(this.topFolder.getName());
        if (this.folders.size() == 0) {
            rootStr = "\u6ca1\u6709\u8bbe\u5b9a";
            root.setCaption(rootStr);
        } else {
            ArrayList list = new ArrayList();
            for (int k = 0; k < this.topFolder.getChildrenList().size(); ++k) {
                list.add(this.topFolder.getChildrenList().get(k));
            }
            CommonComparator comparator = new CommonComparator();
            comparator.setFields_user(new String[]{"index"});
            Collections.sort(list, comparator);
            for (int k = 0; k < list.size(); ++k) {
                UIFileNode node = this.getChildTree(((Folder)list.get(k)).getID());
                if (node == null) continue;
                root.addSub(node);
            }
        }
        return root;
    }

    private void addFolder(Map<String, Folder> map, Folder folder) {
        if (folder != null) {
            map.put(folder.getID(), folder);
            Folder parent = folder.getParent();
            if (parent != null) {
                if (this.topFolderId != null && folder.getID().equals(this.topFolderId)) {
                    this.topFolder = parent;
                    map.put(parent.getID(), parent);
                } else if (!map.containsKey(parent.getID())) {
                    this.addFolder(map, parent);
                }
            } else {
                this.topFolder = folder;
            }
        }
    }

    private boolean isFolderInFolders(Folder folder, List<Folder> folders) {
        for (Folder cfolder : folders) {
            if (!folder.getID().equals(cfolder.getID())) continue;
            return Boolean.TRUE;
        }
        return false;
    }

    private UIFileNode addChildNode(UIFileNode parentnode, Folder folder, List<Folder> folders) {
        if (this.isFolderInFolders(folder, folders)) {
            UIFileNode inputNode = new UIFileNode();
            inputNode.setId(folder.getPath());
            inputNode.setCaption(folder.getName());
            inputNode.setImageClass("xui-icon-file-fold");
            parentnode.addSub(inputNode);
            List childFolders = folder.getChildrenList();
            for (Folder cfolder : childFolders) {
                this.addChildNode(inputNode, cfolder, folders);
            }
        }
        return parentnode;
    }

    class CommonComparator
    implements Comparator {
        String[] fields_user = null;

        CommonComparator() {
        }

        public String[] getFields_user() {
            return this.fields_user;
        }

        public void setFields_user(String[] fields_user) {
            this.fields_user = fields_user;
        }

        public int compare(Object obj1, Object obj2) {
            if (this.fields_user == null || this.fields_user.length <= 0) {
                return 2;
            }
            int i = 0;
            if (i < this.fields_user.length) {
                if (this.compareField(obj1, obj2, this.fields_user[i])) {
                    return 1;
                }
                return -1;
            }
            return 0;
        }

        private boolean compareField(Object o1, Object o2, String fieldName) {
            try {
                Object value1 = BeanMap.create((Object)o1).get((Object)fieldName);
                Object value2 = BeanMap.create((Object)o2).get((Object)fieldName);
                if (value1 != null && value2 != null && Integer.parseInt(value1.toString()) > Integer.parseInt(value2.toString())) {
                    return true;
                }
            }
            catch (Exception e) {
                log.info((Object)"---------\u5bf9\u8c61\u7684\u8be5\u5c5e\u6027\u4e0d\u5b58\u5728\u6216\u8005\u4e0d\u5141\u8bb8\u5728\u6b64\u5b89\u5168\u7ea7\u522b\u4e0a\u53cd\u5c04\u8be5\u5c5e\u6027\uff0c\u8be6\u60c5\u8bf7\u67e5\u9605JAVA DOC--------");
                e.printStackTrace();
            }
            return false;
        }
    }
}

