/*
 * Decompiled with CFR 0.152.
 */
package com.ds.esd.admin.team;

import com.ds.org.Org;
import com.ds.org.Person;
import java.util.ArrayList;
import java.util.List;

public class XUIOrg {
    public String id;
    public String name;
    public String path;
    public boolean disabled = false;
    public boolean group = false;
    public boolean draggable = true;
    public String imageClass = "spafont spa-icon-c-grid";
    public String caption;
    List<XUIOrg> sub;

    public XUIOrg(List<Org> orgs, boolean hasPerson) {
        this.caption = "\u7ec4\u7ec7\u7ed3\u6784";
        this.id = "00000000-0000-0000-0000-000000000000";
        this.name = "\u603b\u8ddf";
        for (Org childOrg : orgs) {
            this.addSub(new XUIOrg(childOrg, hasPerson));
        }
    }

    public XUIOrg(Org org, boolean hasPerson) {
        this.id = org.getOrgId();
        this.name = org.getName();
        this.caption = org.getName();
        this.imageClass = "xui-icon-menu";
        List childOrgs = org.getChildrenList();
        if (childOrgs != null) {
            for (Org childOrg : childOrgs) {
                if (childOrg.getOrgId().equals(childOrg.getParentId())) continue;
                this.addSub(new XUIOrg(childOrg, hasPerson));
            }
        }
        if (hasPerson) {
            this.setDisabled(true);
            List persons = org.getPersonList();
            for (Person Person2 : persons) {
                this.addSub(new XUIOrg(Person2));
            }
        }
    }

    public XUIOrg(Person person) {
        this.id = person.getID();
        this.caption = person.getName();
        this.name = person.getName();
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public boolean isGroup() {
        return this.group;
    }

    public void setGroup(boolean group) {
        this.group = group;
    }

    public boolean isDisabled() {
        return this.disabled;
    }

    public void setDisabled(boolean disabled) {
        this.disabled = disabled;
    }

    public String getCaption() {
        return this.caption;
    }

    public void setCaption(String caption) {
        this.caption = caption;
    }

    public String getImageClass() {
        return this.imageClass;
    }

    public void setImageClass(String imageClass) {
        this.imageClass = imageClass;
    }

    public void addSub(XUIOrg subNode) {
        if (this.sub == null) {
            this.sub = new ArrayList<XUIOrg>();
        }
        this.sub.add(subNode);
    }

    public List<XUIOrg> getSub() {
        return this.sub;
    }

    public void setSub(List<XUIOrg> sub) {
        this.sub = sub;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }
}

