/*
 * Decompiled with CFR 0.152.
 */
package com.ds.esd.admin.team;

import com.ds.client.JDSSessionFactory;
import com.ds.common.JDSException;
import com.ds.common.org.CtOrg;
import com.ds.common.org.CtOrgManager;
import com.ds.common.org.CtPerson;
import com.ds.common.org.service.OrgAdminService;
import com.ds.common.util.CnToSpell;
import com.ds.common.util.StringUtility;
import com.ds.config.ErrorListResultModel;
import com.ds.config.ErrorResultModel;
import com.ds.config.ListResultModel;
import com.ds.config.ResultModel;
import com.ds.context.JDSActionContext;
import com.ds.engine.ConnectInfo;
import com.ds.engine.JDSSessionHandle;
import com.ds.enums.db.MethodChinaName;
import com.ds.esd.admin.team.XUIOrg;
import com.ds.esd.client.ESDClient;
import com.ds.esd.client.ESDFacrory;
import com.ds.esd.client.Project;
import com.ds.esd.project.config.ProjectConfig;
import com.ds.esd.project.enums.ProjectRoleType;
import com.ds.jds.core.User;
import com.ds.jds.core.esb.EsbUtil;
import com.ds.org.Org;
import com.ds.org.OrgManager;
import com.ds.org.OrgNotFoundException;
import com.ds.org.Person;
import com.ds.org.PersonNotFoundException;
import com.ds.org.conf.OrgConstants;
import com.ds.server.JDSClientService;
import com.ds.server.JDSServer;
import com.ds.server.OrgManagerFactory;
import com.ds.server.eumus.ConfigCode;
import com.ds.web.util.PageUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@MethodChinaName(cname="\u7cfb\u7edf\u7528\u6237\u63a5\u53e3")
@Controller
@RequestMapping(value={"/admin/org/"})
public class OrgService {
    @MethodChinaName(cname="\u7528\u6237\u767b\u5f55")
    @RequestMapping(method={RequestMethod.POST}, value={"login"})
    @ResponseBody
    public ResultModel<User> login(String userName, String password) {
        ResultModel result = new ResultModel();
        try {
            HttpServletRequest request = (HttpServletRequest)JDSActionContext.getActionContext().getHttpRequest();
            if (request != null && request.getSession(true) != null) {
                request.getSession(true).invalidate();
            }
            OrgManager orgManager = OrgManagerFactory.getOrgManager((ConfigCode)OrgConstants.CONFIG_KEY);
            Person person = null;
            userName = userName.toLowerCase();
            JDSClientService client = null;
            boolean login = true;
            person = orgManager.getPersonByAccount(userName.toLowerCase());
            login = orgManager.verifyPerson(userName.toLowerCase(), password);
            ConnectInfo connect = new ConnectInfo(userName, person.getID(), person.getPassword());
            person = orgManager.getPersonByAccount(userName);
            ConnectInfo connectInfo = new ConnectInfo(person.getID(), person.getAccount(), person.getPassword());
            JDSSessionFactory factory = new JDSSessionFactory(JDSActionContext.getActionContext());
            JDSSessionHandle sessionHandle = factory.createSessionHandle();
            JDSActionContext.getActionContext().getContext().put("JSESSIONID", sessionHandle.getSessionID());
            request.setAttribute("JSESSIONID", (Object)sessionHandle.getSessionID());
            JDSActionContext.getActionContext().getSession().put("SYSID", "org");
            Set sessionHandleList = JDSServer.getInstance().getSessionHandleList(connectInfo);
            ArrayList newsessionHandleList = new ArrayList();
            client = factory.newClientService(sessionHandle, JDSActionContext.getActionContext().getConfigCode());
            client.connect(connectInfo);
            User user = new User();
            user.setAccount(userName.toLowerCase());
            user.setId(person.getID());
            user.setEmail(person.getEmail());
            user.setName(person.getName());
            user.setSessionId(sessionHandle.getSessionID());
            user.setPhone(person.getMobile());
            result.setData((Object)user);
        }
        catch (PersonNotFoundException e) {
            result = new ErrorResultModel();
            ((ErrorResultModel)result).setErrcode(200);
            ((ErrorResultModel)result).setErrdes(e.getMessage());
        }
        catch (JDSException e) {
            result = new ErrorResultModel();
            ((ErrorResultModel)result).setErrcode(200);
            ((ErrorResultModel)result).setErrdes(e.getMessage());
        }
        return result;
    }

    @MethodChinaName(cname="\u7528\u6237\u9000\u51fa")
    @RequestMapping(method={RequestMethod.POST}, value={"logout"})
    @ResponseBody
    public ResultModel<Boolean> logout() {
        ResultModel result = new ResultModel();
        try {
            OrgManager orgManager = OrgManagerFactory.getOrgManager((ConfigCode)OrgConstants.CONFIG_KEY);
            this.getClient().disconnect();
            JDSActionContext.getActionContext().getContext().remove("JSESSIONID");
            HttpServletRequest request = (HttpServletRequest)JDSActionContext.getActionContext().getHttpRequest();
            request.removeAttribute("JSESSIONID");
            result.setData((Object)true);
        }
        catch (JDSException e) {
            result = new ErrorResultModel();
            ((ErrorResultModel)result).setErrcode(200);
            ((ErrorResultModel)result).setErrdes(e.getMessage());
        }
        return result;
    }

    Org getTopOrg() throws JDSException {
        List orgs = OrgManagerFactory.getOrgManager((ConfigCode)this.getClient().getConfigCode()).getTopOrgs(JDSActionContext.getActionContext().getSystemCode());
        if (orgs == null || orgs.size() == 0) {
            throw new JDSException("\u7cfb\u7edf\u4fe1\u606f\u9519\u8bef");
        }
        return (Org)orgs.get(0);
    }

    @MethodChinaName(cname="\u6dfb\u52a0\u5f00\u53d1\u6210\u5458")
    @RequestMapping(method={RequestMethod.POST}, value={"addDevPersons"})
    @ResponseBody
    public ResultModel<Boolean> addDevPersons(String projectName, ProjectRoleType group, String id) {
        ResultModel result = new ResultModel();
        String[] personIdArr = StringUtility.split((String)id, (String)";");
        try {
            Project project = this.getClient().getProjectByName(projectName);
            ProjectConfig config = project.getConfig();
            for (String personId : personIdArr) {
                config.addDevPersons(group, personId);
            }
            project.updateConfig(config);
        }
        catch (JDSException e) {
            result = new ErrorResultModel();
            ((ErrorResultModel)result).setErrcode(e.getErrorCode());
            ((ErrorResultModel)result).setErrdes(e.getMessage());
        }
        return result;
    }

    @MethodChinaName(cname="\u79fb\u9664\u5f00\u53d1\u6210\u5458")
    @RequestMapping(method={RequestMethod.POST}, value={"removeDevPersons"})
    @ResponseBody
    public ResultModel<Boolean> removeDevPersons(String projectName, ProjectRoleType group, String iD) {
        ResultModel result = new ResultModel();
        try {
            Project project = this.getClient().getProjectByName(projectName);
            ProjectConfig config = project.getConfig();
            config.removeDevPersons(group, iD);
            project.updateConfig(config);
        }
        catch (JDSException e) {
            result = new ErrorResultModel();
            ((ErrorResultModel)result).setErrcode(e.getErrorCode());
            ((ErrorResultModel)result).setErrdes(e.getMessage());
        }
        return result;
    }

    @MethodChinaName(cname="\u83b7\u53d6\u5f00\u53d1\u6210\u5458\u5217\u8868")
    @RequestMapping(method={RequestMethod.POST}, value={"getDevPersons"})
    @ResponseBody
    public ListResultModel<List<Person>> getDevPersons(String projectName, ProjectRoleType group) {
        ListResultModel userStatusInfo = new ListResultModel();
        List xuiPersons = null;
        try {
            Project project = this.getClient().getProjectByName(projectName);
            xuiPersons = project.getDevPersons(group);
        }
        catch (JDSException e) {
            e.printStackTrace();
        }
        userStatusInfo = PageUtil.getDefaultPageList(xuiPersons);
        return userStatusInfo;
    }

    public ESDClient getClient() throws JDSException {
        ESDClient client = ESDFacrory.getESDClient();
        return client;
    }

    @MethodChinaName(cname="\u83b7\u53d6\u5f00\u53d1\u7ec4\u7ec7")
    @RequestMapping(value={"getOrgs"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public ResultModel<XUIOrg> getOrgs() {
        ResultModel userStatusInfo = new ResultModel();
        try {
            Org org = this.getTopOrg();
            XUIOrg xuiOrg = new XUIOrg(org, false);
            userStatusInfo.setData((Object)xuiOrg);
        }
        catch (JDSException e) {
            e.printStackTrace();
            userStatusInfo = new ErrorResultModel();
            ((ErrorResultModel)userStatusInfo).setErrdes(e.getMessage());
        }
        return userStatusInfo;
    }

    @MethodChinaName(cname="\u83b7\u53d6\u5b50\u8282\u70b9")
    @RequestMapping(value={"getChildOrgs"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public ListResultModel<List<Org>> getChildOrgs(String orgId) {
        ListResultModel userStatusInfo = new ListResultModel();
        ArrayList xuiOrgs = new ArrayList();
        try {
            if (orgId == null || orgId.equals("")) {
                orgId = this.getTopOrg().getOrgId();
            }
            Org org = OrgManagerFactory.getOrgManager().getOrgByID(orgId);
            userStatusInfo = PageUtil.getDefaultPageList((List)org.getChildrenList());
        }
        catch (JDSException e) {
            userStatusInfo = new ErrorListResultModel();
            ((ErrorListResultModel)userStatusInfo).setErrdes(e.getMessage());
        }
        catch (OrgNotFoundException e) {
            userStatusInfo = new ErrorListResultModel();
            ((ErrorListResultModel)userStatusInfo).setErrdes(e.getMessage());
        }
        return userStatusInfo;
    }

    @MethodChinaName(cname="\u6dfb\u52a0\u7ec4\u7ec7\u7ba1\u7406\u5458")
    @RequestMapping(value={"addLeader"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public ResultModel<Boolean> addLeader(String personId, String orgId) {
        ResultModel userStatusInfo = new ResultModel();
        try {
            CtOrg org = (CtOrg)OrgManagerFactory.getOrgManager().getOrgByID(orgId);
            Person person = OrgManagerFactory.getOrgManager().getPersonByID(personId);
            org.setLeader(personId);
        }
        catch (Exception e) {
            userStatusInfo = new ErrorResultModel();
            ((ErrorResultModel)userStatusInfo).setErrdes(e.getMessage());
        }
        return userStatusInfo;
    }

    @MethodChinaName(cname="\u83b7\u53d6\u6210\u5458\u8282\u70b9\u6570\u636e")
    @RequestMapping(value={"getPersonTree"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public ResultModel<XUIOrg> getPersonTree(String iD) {
        ResultModel userStatusInfo = new ResultModel();
        ArrayList xuiPersons = new ArrayList();
        try {
            if (iD == null || iD.equals("")) {
                iD = this.getTopOrg().getOrgId();
            }
            Org org = OrgManagerFactory.getOrgManager().getOrgByID(iD);
            XUIOrg xuiorg = new XUIOrg(org, true);
            userStatusInfo.setData((Object)xuiorg);
        }
        catch (OrgNotFoundException e) {
            userStatusInfo = new ErrorResultModel();
            ((ErrorResultModel)userStatusInfo).setErrdes(e.getMessage());
        }
        catch (JDSException e) {
            userStatusInfo = new ErrorResultModel();
            ((ErrorResultModel)userStatusInfo).setErrdes(e.getMessage());
        }
        return userStatusInfo;
    }

    @MethodChinaName(cname="\u83b7\u53d6\u673a\u6784\u8282\u70b9\u6570\u636e")
    @RequestMapping(value={"getOrgnTree"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public ResultModel<XUIOrg> getOrgnTree(String iD) {
        ResultModel userStatusInfo = new ResultModel();
        ArrayList xuiPersons = new ArrayList();
        try {
            if (iD == null || iD.equals("")) {
                iD = this.getTopOrg().getOrgId();
            }
            Org org = OrgManagerFactory.getOrgManager().getOrgByID(iD);
            XUIOrg xuiorg = new XUIOrg(org, false);
            userStatusInfo.setData((Object)xuiorg);
        }
        catch (OrgNotFoundException e) {
            userStatusInfo = new ErrorResultModel();
            ((ErrorResultModel)userStatusInfo).setErrdes(e.getMessage());
        }
        catch (JDSException e) {
            userStatusInfo = new ErrorResultModel();
            ((ErrorResultModel)userStatusInfo).setErrdes(e.getMessage());
        }
        return userStatusInfo;
    }

    @MethodChinaName(cname="\u67e5\u627e\u6210\u5458")
    @RequestMapping(value={"findPerson"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public ListResultModel<List<Person>> findPerson() {
        ListResultModel userStatusInfo = new ListResultModel();
        ArrayList xuiPersons = new ArrayList();
        List persons = OrgManagerFactory.getOrgManager().getPersons();
        userStatusInfo = PageUtil.getDefaultPageList((List)persons);
        return userStatusInfo;
    }

    @MethodChinaName(cname="\u83b7\u53d6\u6210\u5458")
    @RequestMapping(value={"getPersons"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public ListResultModel<List<Person>> getPersons(String orgId) {
        ListResultModel userStatusInfo = new ListResultModel();
        ArrayList xuiPersons = new ArrayList();
        try {
            if (orgId == null || orgId.equals("")) {
                orgId = this.getTopOrg().getOrgId();
            }
            Org org = OrgManagerFactory.getOrgManager().getOrgByID(orgId);
            userStatusInfo = PageUtil.getDefaultPageList((List)org.getPersonList());
        }
        catch (OrgNotFoundException e) {
            userStatusInfo = new ErrorListResultModel();
            ((ErrorListResultModel)userStatusInfo).setErrdes(e.getMessage());
        }
        catch (JDSException e) {
            userStatusInfo = new ErrorListResultModel();
            ((ErrorListResultModel)userStatusInfo).setErrdes(e.getMessage());
        }
        return userStatusInfo;
    }

    @MethodChinaName(cname="\u4fdd\u5b58\u6210\u5458\u4fe1\u606f")
    @RequestMapping(value={"savePerson"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public ResultModel<Boolean> savePerson(@RequestBody CtPerson person) {
        ResultModel userStatusInfo = new ResultModel();
        try {
            if (person.getAccount() == null || person.getAccount().equals("")) {
                person.setAccount(CnToSpell.getFullSpell((String)person.getName()));
            }
            this.getOrgService().savePerson(person).get();
            CtOrgManager manager = (CtOrgManager)OrgManagerFactory.getOrgManager();
            manager.clearOrgCache(person.getOrgId());
        }
        catch (JDSException e) {
            userStatusInfo = new ErrorResultModel();
            ((ErrorResultModel)userStatusInfo).setErrcode(e.getErrorCode());
            ((ErrorResultModel)userStatusInfo).setErrdes(e.getMessage());
        }
        return userStatusInfo;
    }

    @MethodChinaName(cname="\u4fdd\u5b58\u673a\u6784\u4fe1\u606f")
    @RequestMapping(value={"saveOrg"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public ResultModel<Boolean> saveOrg(@RequestBody CtOrg org) {
        ResultModel userStatusInfo = new ResultModel();
        try {
            this.getOrgService().saveOrg(org).get();
            CtOrgManager manager = (CtOrgManager)OrgManagerFactory.getOrgManager();
            manager.clearOrgCache(org.getOrgId());
        }
        catch (JDSException e) {
            userStatusInfo = new ErrorResultModel();
            ((ErrorResultModel)userStatusInfo).setErrcode(e.getErrorCode());
            ((ErrorResultModel)userStatusInfo).setErrdes(e.getMessage());
        }
        return userStatusInfo;
    }

    @MethodChinaName(cname="\u79fb\u9664\u6210\u5458")
    @RequestMapping(value={"delPerson"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public ResultModel<Boolean> delPerson(String personId) {
        ResultModel userStatusInfo = new ResultModel();
        try {
            CtOrgManager manager = (CtOrgManager)OrgManagerFactory.getOrgManager();
            Person person = manager.getPersonByID(personId);
            this.getOrgService().delPerson(personId).get();
            manager.clearOrgCache(person.getOrgId());
        }
        catch (JDSException e) {
            userStatusInfo = new ErrorResultModel();
            ((ErrorResultModel)userStatusInfo).setErrcode(e.getErrorCode());
            ((ErrorResultModel)userStatusInfo).setErrdes(e.getMessage());
        }
        catch (PersonNotFoundException e) {
            userStatusInfo = new ErrorResultModel();
            ((ErrorResultModel)userStatusInfo).setErrdes(e.getMessage());
        }
        return userStatusInfo;
    }

    @MethodChinaName(cname="\u79fb\u9664\u7ec4\u7ec7")
    @RequestMapping(value={"delOrg"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public ResultModel<Boolean> delOrg(String orgId) {
        ResultModel userStatusInfo = new ResultModel();
        try {
            CtOrgManager manager = (CtOrgManager)OrgManagerFactory.getOrgManager();
            Org org = manager.getOrgByID(orgId);
            this.getOrgService().delOrg(orgId).get();
            manager.clearOrgCache(org.getParentId());
        }
        catch (JDSException e) {
            userStatusInfo = new ErrorResultModel();
            ((ErrorResultModel)userStatusInfo).setErrcode(e.getErrorCode());
            ((ErrorResultModel)userStatusInfo).setErrdes(e.getMessage());
        }
        catch (OrgNotFoundException e) {
            userStatusInfo = new ErrorResultModel();
            ((ErrorResultModel)userStatusInfo).setErrdes(e.getMessage());
        }
        return userStatusInfo;
    }

    OrgAdminService getOrgService() {
        OrgAdminService service = (OrgAdminService)EsbUtil.parExpression((String)"$OrgAdminService", OrgAdminService.class);
        return service;
    }
}

