/*
 * Decompiled with CFR 0.152.
 */
package com.ds.esd.admin.plugins.service;

import com.alibaba.fastjson.JSONObject;
import com.ds.common.JDSException;
import com.ds.common.md5.MD5InputStream;
import com.ds.common.util.StringUtility;
import com.ds.config.ErrorListResultModel;
import com.ds.config.ErrorResultModel;
import com.ds.config.ListResultModel;
import com.ds.config.ResultModel;
import com.ds.context.JDSActionContext;
import com.ds.enums.db.MethodChinaName;
import com.ds.esd.admin.node.XUIFile;
import com.ds.esd.admin.node.XUIFileVersion;
import com.ds.esd.admin.node.XUIModule;
import com.ds.esd.admin.node.XUIParas;
import com.ds.esd.client.ESDClient;
import com.ds.esd.client.ESDFacrory;
import com.ds.esd.client.ProjectVersion;
import com.ds.esd.editor.enums.PackagePathType;
import com.ds.esd.editor.enums.PackageType;
import com.ds.esd.project.enums.ProjectDefAccess;
import com.ds.esd.tool.enums.EUFileType;
import com.ds.esd.tool.module.EUModule;
import com.ds.esd.tool.ui.module.ModuleComponent;
import com.ds.vfs.FileInfo;
import com.ds.vfs.FileVersion;
import com.ds.vfs.Folder;
import com.ds.vfs.ct.CtVfsFactory;
import com.ds.vfs.ct.CtVfsService;
import com.ds.web.util.PageUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;

@Controller
@RequestMapping(value={"/RAD/{projectName}/"})
@MethodChinaName(cname="XUI\u7f16\u8f91\u5668")
public class VFSService {
    @MethodChinaName(cname="\u6dfb\u52a0\u6587\u4ef6\u5939")
    @RequestMapping(value={"addFolder"}, method={RequestMethod.POST})
    @ResponseBody
    public ResultModel<XUIFile> addFolder(String path, @PathVariable String projectName) {
        ResultModel result = new ResultModel();
        try {
            ProjectVersion version = this.getClient().getProjectVersionByName(projectName);
            Folder folder = version.createFolder(path);
            result.setData((Object)new XUIFile(folder, version));
        }
        catch (JDSException e) {
            result = new ErrorResultModel();
            ((ErrorResultModel)result).setErrcode(100);
            ((ErrorResultModel)result).setErrdes(e.getMessage());
        }
        return result;
    }

    @MethodChinaName(cname="\u5237\u65b0\u5de5\u7a0b")
    @RequestMapping(value={"reLoadProject"}, method={RequestMethod.POST})
    @ResponseBody
    public ResultModel<XUIFile> reLoadProject(@PathVariable String projectName) {
        ResultModel result = new ResultModel();
        try {
            this.getClient().reLoadProject(projectName);
        }
        catch (JDSException e) {
            result = new ErrorResultModel();
            ((ErrorResultModel)result).setErrcode(100);
            ((ErrorResultModel)result).setErrdes(e.getMessage());
        }
        return result;
    }

    @MethodChinaName(cname="\u6dfb\u52a0\u666e\u901a\u6587\u4ef6")
    @RequestMapping(value={"addTextFile"}, method={RequestMethod.POST})
    @ResponseBody
    public ResultModel<XUIFile> addTextFile(String path, @PathVariable String projectName) {
        ResultModel result = new ResultModel();
        try {
            ProjectVersion version = this.getClient().getProjectVersionByName(projectName);
            FileInfo fileInfo = this.getClient().saveFile(new StringBuffer("{}"), new String[]{path, projectName});
            result.setData((Object)new XUIFile(fileInfo, version));
        }
        catch (JDSException e) {
            result = new ErrorResultModel();
            ((ErrorResultModel)result).setErrcode(100);
            ((ErrorResultModel)result).setErrdes(e.getMessage());
        }
        return result;
    }

    @MethodChinaName(cname="\u6dfb\u52a0\u9875\u9762")
    @RequestMapping(value={"addClass"}, method={RequestMethod.POST})
    @ResponseBody
    public ResultModel<XUIFile> addClass(String className, String projectName) {
        ResultModel result = new ResultModel();
        try {
            ProjectVersion version = this.getClient().getProjectVersionByName(projectName);
            EUModule module = this.getClient().getModule(className, version.getVersionName(), true);
            if (module != null) {
                throw new JDSException("\u9875\u9762\u5df2\u5b58\u5728\uff01");
            }
            EUModule euModule = version.createModule(className);
            this.getClient().saveModule(euModule);
            result.setData((Object)new XUIFile(euModule));
        }
        catch (JDSException e) {
            result = new ErrorResultModel();
            ((ErrorResultModel)result).setErrcode(100);
            ((ErrorResultModel)result).setErrdes(e.getMessage());
        }
        return result;
    }

    @MethodChinaName(cname="\u6dfb\u52a0\u6587\u4ef6")
    @RequestMapping(value={"uploadFiles"}, method={RequestMethod.POST})
    @ResponseBody
    public ResultModel<XUIFile> uploadFiles(String uploadpath, @PathVariable String projectName, @RequestParam(value="files") MultipartFile files, @RequestParam(value="file") MultipartFile file) {
        ResultModel result = new ResultModel();
        if (uploadpath == null) {
            uploadpath = "";
        }
        if (files == null) {
            files = file;
        }
        try {
            Folder tfolder;
            ProjectVersion version = this.getClient().getProjectVersionByName(projectName);
            if (uploadpath.equals(projectName)) {
                uploadpath = "";
            }
            if ((tfolder = this.getClient().getFolderByPath(new String[]{uploadpath, version.getVersionName()})) == null) {
                tfolder = version.createFolder(uploadpath);
            }
            try {
                FileInfo fileInfo = this.getClient().uploadFile(new MD5InputStream(files.getInputStream()), new String[]{tfolder.getPath() + files.getOriginalFilename(), projectName});
                result.setData((Object)new XUIFile(fileInfo, version));
            }
            catch (IOException e) {
                throw new JDSException((Throwable)e);
            }
        }
        catch (JDSException e) {
            result = new ErrorResultModel();
            ((ErrorResultModel)result).setErrcode(100);
            ((ErrorResultModel)result).setErrdes(e.getMessage());
        }
        return result;
    }

    @MethodChinaName(cname="\u5bfc\u5165\u6587\u4ef6")
    @RequestMapping(value={"importFile"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public ResultModel<List<XUIFile>> importFile(String id, String tpath, @PathVariable String projectName) {
        ResultModel result = new ResultModel();
        ArrayList<XUIFile> xuiFiles = new ArrayList<XUIFile>();
        try {
            ProjectVersion version = this.getClient().getProjectVersionByName(projectName);
            String[] filePaths = StringUtility.split((String)id, (String)";");
            List objects = this.getClient().importFile(Arrays.asList(filePaths), new String[]{tpath, projectName});
            for (Object obj : objects) {
                if (obj instanceof EUModule) {
                    xuiFiles.add(new XUIFile((EUModule)obj));
                    continue;
                }
                if (!(obj instanceof FileInfo)) continue;
                xuiFiles.add(new XUIFile((FileInfo)obj, version));
            }
            result.setData(xuiFiles);
        }
        catch (JDSException e) {
            result = new ErrorResultModel();
            ((ErrorResultModel)result).setErrcode(100);
            ((ErrorResultModel)result).setErrdes(e.getMessage());
        }
        return result;
    }

    @MethodChinaName(cname="\u62f7\u8d1d\u6587\u4ef6\u5939")
    @RequestMapping(value={"copy"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public ResultModel<XUIFile> copy(String spath, String tpath, String projectName) {
        ResultModel result = new ResultModel();
        try {
            ProjectVersion version = this.getClient().getProjectVersionByName(projectName);
            Object obj = this.getClient().copy(projectName, spath, tpath);
            if (obj instanceof EUModule) {
                result.setData((Object)new XUIFile((EUModule)obj));
            } else if (obj instanceof FileInfo) {
                result.setData((Object)new XUIFile((FileInfo)obj, version));
            } else if (obj instanceof Folder) {
                result.setData((Object)new XUIFile((Folder)obj, version));
            }
        }
        catch (JDSException e) {
            result = new ErrorResultModel();
            ((ErrorResultModel)result).setErrcode(100);
            ((ErrorResultModel)result).setErrdes(e.getMessage());
        }
        return result;
    }

    @MethodChinaName(cname="\u83b7\u53d6\u6587\u4ef6\u5185\u5bb9")
    @RequestMapping(value={"getFileContent"}, method={RequestMethod.GET})
    @ResponseBody
    public ResultModel<XUIModule> getFileContent(String path, String className, @PathVariable String projectName) {
        ResultModel result = new ResultModel();
        XUIModule xuiModule = new XUIModule();
        String json = "{}";
        try {
            if (path != null && path.indexOf("VVVERSIONVV") > -1) {
                FileVersion version = CtVfsFactory.getCtVfsService().getFileVersionByPath(path);
                json = this.getClient().readFileAsString(new String[]{path, projectName});
                ModuleComponent moduleComponent = (ModuleComponent)JSONObject.parseObject((String)json, ModuleComponent.class);
                JDSActionContext.getActionContext().getContext().put("className", className + "V" + version.getIndex());
                moduleComponent.setClassName(className + "V" + version.getIndex());
                json = this.getClient().genJSON(moduleComponent, null).toString();
            } else if (className != null && !className.equals("")) {
                EUModule module;
                if (className.endsWith(".cls")) {
                    className = className.substring(0, className.length() - ".cls".length());
                    JDSActionContext.getActionContext().getContext().put("className", className);
                }
                if ((module = this.getClient().getModule(path, projectName, false)) == null) {
                    EUModule euModule = this.getClient().createModule(className, projectName);
                    this.getClient().saveModule(euModule);
                }
                json = this.getClient().genJSON(module, null).toString();
            } else if (path.endsWith(".cls")) {
                EUModule module = this.getClient().getModule(path, projectName, false);
                if (module == null) {
                    EUModule euModule = this.getClient().createModule(className, projectName);
                    this.getClient().saveModule(euModule);
                }
                json = this.getClient().genJSON(module, null).toString();
            } else {
                json = this.getClient().readFileAsString(new String[]{path, projectName});
            }
            xuiModule.setContent(json);
            result.setData((Object)xuiModule);
        }
        catch (Exception e) {
            e.printStackTrace();
            result = new ErrorResultModel();
            ((ErrorResultModel)result).setErrcode(100);
            ((ErrorResultModel)result).setErrdes(e.getMessage());
        }
        return result;
    }

    @MethodChinaName(cname="\u5220\u9664\u6587\u4ef6")
    @RequestMapping(value={"delFile"}, method={RequestMethod.POST})
    @ResponseBody
    public ResultModel<XUIModule> delFile(String paths, @PathVariable String projectName) {
        ResultModel result = new ResultModel();
        XUIModule xuiModule = new XUIModule();
        List<XUIFile> modules = xuiModule.getFiles();
        try {
            ProjectVersion version = this.getClient().getProjectVersionByName(projectName);
            if (paths != null && paths.equals(projectName)) {
                this.getClient().delProject(this.getClient().getProjectByName(projectName).getId());
            } else {
                String[] filePath = StringUtility.split((String)paths, (String)";");
                version.delFile(Arrays.asList(filePath));
            }
        }
        catch (JDSException e) {
            result = new ErrorResultModel();
            ((ErrorResultModel)result).setErrcode(100);
            ((ErrorResultModel)result).setErrdes(e.getMessage());
        }
        return result;
    }

    @MethodChinaName(cname="\u91cd\u65b0\u547d\u540d\u6587\u4ef6")
    @RequestMapping(value={"reName"}, method={RequestMethod.POST})
    @ResponseBody
    public ResultModel<XUIFile> reName(String path, String newName, @PathVariable String projectName) {
        ResultModel result = new ResultModel();
        try {
            ProjectVersion version = this.getClient().getProjectVersionByName(projectName);
            Object obj = this.getClient().reName(projectName, path, newName);
            if (obj instanceof EUModule) {
                result.setData((Object)new XUIFile((EUModule)obj));
            } else if (obj instanceof FileInfo) {
                result.setData((Object)new XUIFile((FileInfo)obj, version));
            } else if (obj instanceof Folder) {
                result.setData((Object)new XUIFile((Folder)obj, version));
            }
        }
        catch (JDSException e) {
            result = new ErrorResultModel();
            ((ErrorResultModel)result).setErrcode(100);
            ((ErrorResultModel)result).setErrdes(e.getMessage());
        }
        return result;
    }

    @MethodChinaName(cname="\u6253\u5f00\u6587\u4ef6\u5939")
    @RequestMapping(value={"openFolder"}, method={RequestMethod.POST})
    @ResponseBody
    public ListResultModel<List<XUIFile>> openFolder(String path, @PathVariable String projectName, Boolean hasFile) {
        ListResultModel result = new ListResultModel();
        String[] systemFiles = new String[]{"ProjectConfig.cfg", "xuiconf.js"};
        ArrayList<XUIFile> modules = new ArrayList<XUIFile>();
        Folder folder = null;
        ProjectVersion version = null;
        try {
            if (projectName != null) {
                if (path == null || projectName.equals(path)) {
                    path = "";
                }
                folder = this.getClient().getFolderByPath(new String[]{path, projectName});
                version = this.getClient().getProjectVersionByName(projectName);
            } else {
                folder = this.getVfsClient().getFolderByPath(path);
            }
            List folders = folder.getChildrenList();
            for (Folder cfolder : folders) {
                String folderPath = StringUtility.replace((String)cfolder.getPath(), (String)version.getPath(), (String)"/");
                PackagePathType packagePathType = PackagePathType.startPath((String)folderPath);
                if (packagePathType != null && !packagePathType.getApiType().equals((Object)PackageType.local) && !version.getProject().getProjectType().equals((Object)ProjectDefAccess.DSM)) continue;
                boolean isSystem = false;
                String[] stringArray = systemFiles;
                int n = stringArray.length;
                for (int i = 0; i < n; ++i) {
                    String name = stringArray[i];
                    if (!cfolder.getName().equals(name)) continue;
                    isSystem = true;
                }
                if (isSystem) continue;
                modules.add(new XUIFile(cfolder, version));
            }
            List infos = folder.getFileList();
            for (FileInfo fileInfo : infos) {
                boolean isSystem = false;
                for (String name : systemFiles) {
                    if (!fileInfo.getName().equals(name)) continue;
                    isSystem = true;
                }
                if (isSystem) continue;
                if (!fileInfo.getName().endsWith(".cls")) {
                    modules.add(new XUIFile(fileInfo, version));
                    continue;
                }
                EUModule module = version.getModule(fileInfo.getPath());
                if (module == null) continue;
                modules.add(new XUIFile(module));
            }
            result.setData(modules);
        }
        catch (JDSException e) {
            result = new ErrorListResultModel();
            ((ErrorListResultModel)result).setErrcode(100);
            ((ErrorListResultModel)result).setErrdes(e.getMessage());
        }
        return result;
    }

    @MethodChinaName(cname="\u7cfb\u7edf\u65b9\u6cd5")
    @RequestMapping(value={"request"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public ResultModel<XUIModule> request(String key, String paras, @PathVariable String projectName) {
        ResultModel result = new ResultModel();
        XUIParas param = (XUIParas)JSONObject.parseObject((String)paras, XUIParas.class);
        String path = param.getPath();
        XUIModule xuiModule = new XUIModule();
        if (param.getAction().equals("open") || param.getAction().equals("refresh")) {
            List<XUIFile> modules = xuiModule.getFiles();
            try {
                Folder folder;
                ProjectVersion version = this.getClient().getProjectVersionByName(projectName);
                if (param.getAction().equals("refresh")) {
                    this.getVfsClient().clearCache(path);
                }
                if ((folder = this.getClient().getFolderByPath(new String[]{path, projectName})) != null && folder != null) {
                    List folders = folder.getChildrenList();
                    for (Folder cfolder : folders) {
                        modules.add(new XUIFile(cfolder, version));
                    }
                    if (!(param.getType() != null && param.getType() == 0 || param.getDeep() != null && param.getDeep().equals("0"))) {
                        List infos = folder.getFileList();
                        HashMap nameMap = new HashMap();
                        for (FileInfo fileInfo : infos) {
                            if (param.getPattern() != null && !param.getPattern().equals("")) {
                                Pattern p = Pattern.compile(param.getPattern());
                                Matcher matcher = p.matcher(fileInfo.getName());
                                modules.add(new XUIFile(fileInfo, version));
                                continue;
                            }
                            modules.add(new XUIFile(fileInfo, version));
                        }
                    }
                }
                result.setData((Object)xuiModule);
            }
            catch (JDSException e) {
                result = new ErrorResultModel();
                ((ErrorResultModel)result).setErrcode(100);
                ((ErrorResultModel)result).setErrdes(e.getMessage());
            }
        }
        return result;
    }

    @MethodChinaName(cname="\u4fdd\u5b58\u6587\u4ef6\u5185\u5bb9")
    @RequestMapping(value={"saveContent"}, method={RequestMethod.POST})
    @ResponseBody
    public ResultModel<XUIModule> saveContent(@PathVariable String projectName, String className, String content, String jscontent, String path, EUFileType fileType) {
        ResultModel result = new ResultModel();
        XUIModule xuiModule = new XUIModule();
        try {
            ProjectVersion version = this.getClient().getProjectVersionByName(projectName);
            if (path != null && path.endsWith(".cls")) {
                fileType = EUFileType.EUClass;
            }
            switch (fileType) {
                case EUClass: {
                    if (path.endsWith(".js") && jscontent != null) {
                        this.getClient().saveFile(new StringBuffer(jscontent), new String[]{path, projectName});
                    }
                    ModuleComponent moduleComponent = (ModuleComponent)JSONObject.parseObject((String)content, ModuleComponent.class);
                    EUModule euModule = version.createModule(path);
                    euModule.setComponent(moduleComponent);
                    this.getClient().saveModule(euModule);
                    break;
                }
                case EUFile: {
                    this.getClient().saveFile(new StringBuffer(jscontent), new String[]{path, projectName});
                }
            }
            result.setData((Object)xuiModule);
        }
        catch (Exception e) {
            e.printStackTrace();
            result = new ErrorResultModel();
            ((ErrorResultModel)result).setErrcode(100);
            ((ErrorResultModel)result).setErrdes(e.getMessage());
        }
        return result;
    }

    @MethodChinaName(cname="\u5220\u9664\u6587\u4ef6\u7248\u672c")
    @RequestMapping(value={"delFileVersion"}, method={RequestMethod.POST})
    @ResponseBody
    public ResultModel<Boolean> delFileVersion(String paths, @PathVariable String projectName) {
        String[] versionIdArr;
        ResultModel result = new ResultModel();
        for (String versionId : versionIdArr = StringUtility.split((String)paths, (String)";")) {
            try {
                this.getVfsClient().deleteFileVersion(versionId);
            }
            catch (JDSException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    @MethodChinaName(cname="\u83b7\u53d6\u6240\u6709\u7248\u672c")
    @RequestMapping(value={"getAllFileVersion"}, method={RequestMethod.POST})
    @ResponseBody
    public ListResultModel<List<XUIFileVersion>> getAllFileVersion(String path, @PathVariable String projectName) {
        ListResultModel result = new ListResultModel();
        ArrayList allversions = new ArrayList();
        try {
            FileInfo fileInfo = this.getClient().getFileByPath(new String[]{path, projectName});
            List versions = fileInfo.getVersionList();
            result = PageUtil.getDefaultPageList((List)versions, XUIFileVersion.class);
        }
        catch (JDSException e) {
            result = new ErrorListResultModel();
            ((ErrorListResultModel)result).setErrcode(100);
            ((ErrorListResultModel)result).setErrdes(e.getMessage());
        }
        return result;
    }

    ESDClient getClient() throws JDSException {
        ESDClient client = ESDFacrory.getESDClient();
        return client;
    }

    public CtVfsService getVfsClient() {
        CtVfsService vfsClient = CtVfsFactory.getCtVfsService();
        return vfsClient;
    }
}

