/*
 * Decompiled with CFR 0.152.
 */
package com.ds.esd.admin.plugins.service;

import com.ds.cluster.ServerNode;
import com.ds.cluster.ServerNodeList;
import com.ds.cluster.service.ServerEventFactory;
import com.ds.common.JDSException;
import com.ds.common.util.StringUtility;
import com.ds.config.ErrorListResultModel;
import com.ds.config.ErrorResultModel;
import com.ds.config.ListResultModel;
import com.ds.config.ResultModel;
import com.ds.enums.db.MethodChinaName;
import com.ds.esb.config.EsbFlowType;
import com.ds.esb.config.manager.EsbBean;
import com.ds.esb.config.manager.EsbBeanFactory;
import com.ds.esb.config.manager.ExpressionTempBean;
import com.ds.esd.admin.node.ServiceNode;
import com.ds.esd.admin.node.XUIApplication;
import com.ds.esd.admin.node.XUIServerNode;
import com.ds.esd.admin.node.XUIService;
import com.ds.esd.admin.node.XUISystem;
import com.ds.jds.core.esb.EsbUtil;
import com.ds.server.JDSServer;
import com.ds.server.SubSystem;
import com.ds.server.eumus.ConfigCode;
import com.ds.server.eumus.SystemType;
import com.ds.server.service.SysWebManager;
import com.ds.web.util.PageUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@MethodChinaName(cname="\u96c6\u7fa4\u670d\u52a1")
@RequestMapping(value={"/admin/system/"})
public class SystemService {
    @MethodChinaName(cname="\u83b7\u53d6\u6240\u6709\u7cfb\u7edf")
    @RequestMapping(value={"getAllSystem"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public ListResultModel<List<XUISystem>> getAllSystem(String classification) {
        ListResultModel userStatusInfo = new ListResultModel();
        try {
            JDSServer.getInstance();
            List serverNodes = JDSServer.getClusterClient().getAllServer();
            ArrayList<ServerNode> sysNodes = new ArrayList<ServerNode>();
            for (ServerNode node : serverNodes) {
                JDSServer.getInstance();
                SubSystem subSystem = JDSServer.getClusterClient().getSystem(node.getId());
                if (subSystem == null || subSystem.getType() == null || !subSystem.getType().equals((Object)SystemType.system)) continue;
                sysNodes.add(node);
            }
            userStatusInfo = PageUtil.getDefaultPageList(sysNodes, XUISystem.class);
        }
        catch (JDSException e) {
            userStatusInfo = new ErrorListResultModel();
            ((ErrorListResultModel)userStatusInfo).setErrcode(e.getErrorCode());
            ((ErrorListResultModel)userStatusInfo).setErrdes(e.getMessage());
        }
        return userStatusInfo;
    }

    @MethodChinaName(cname="\u83b7\u53d6\u6240\u6709\u5e94\u7528\u914d\u7f6e")
    @RequestMapping(value={"getApplications"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public ListResultModel<List<XUIApplication>> getApplications() {
        List applications = JDSServer.getClusterClient().getApplications();
        ListResultModel userStatusInfo = PageUtil.getDefaultPageList((List)applications, XUIApplication.class);
        return userStatusInfo;
    }

    @MethodChinaName(cname="\u83b7\u53d6\u6240\u6709\u8282\u70b9\u670d\u52a1")
    @RequestMapping(value={"getServerNodes"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public ListResultModel<List<XUIServerNode>> getServerNodes(String code) {
        ServerNodeList serverNodeList = JDSServer.getClusterClient().getServerNodeListByConfigCode(ConfigCode.fromType((String)code));
        ListResultModel userStatusInfo = PageUtil.getDefaultPageList((List)serverNodeList.getServerNodeList(), XUIServerNode.class);
        return userStatusInfo;
    }

    @MethodChinaName(cname="\u83b7\u53d6\u8282\u70b9\u4fe1\u606f")
    @RequestMapping(value={"getServerNodeInfo"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public ResultModel<XUIServerNode> getServerNodeInfo(String code) {
        ServerNode serverNode = JDSServer.getClusterClient().getServerNodeById(code);
        ResultModel userStatusInfo = new ResultModel();
        userStatusInfo.setData((Object)new XUIServerNode(serverNode));
        return userStatusInfo;
    }

    @MethodChinaName(cname="\u83b7\u53d6\u8fdc\u7a0b\u670d\u52a1\u4fe1\u606f")
    @RequestMapping(value={"getEsbBeanListBean"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public ListResultModel<List<EsbBean>> getEsbTemp() {
        List esbBeans = EsbBeanFactory.getInstance().getEsbBeanList();
        ListResultModel userStatusInfo = PageUtil.getDefaultPageList((List)esbBeans);
        return userStatusInfo;
    }

    @ResponseBody
    @RequestMapping(value={"getServcieByType"}, method={RequestMethod.POST, RequestMethod.GET})
    public ListResultModel<List<ServiceNode>> getServcieByType() {
        EsbFlowType[] types;
        ListResultModel module = new ListResultModel();
        ArrayList<ServiceNode> serviceNodes = new ArrayList<ServiceNode>();
        for (EsbFlowType type : types = EsbFlowType.values()) {
            ServiceNode serviceNode = new ServiceNode(type);
            serviceNodes.add(serviceNode);
        }
        module.setData(serviceNodes);
        return module;
    }

    @MethodChinaName(cname="\u6240\u6709\u6d88\u606f\u4e8b\u4ef6\u4fe1\u606f")
    @RequestMapping(value={"getAllEvent"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public ListResultModel<Set<ExpressionTempBean>> getAllEvent() {
        Set beanSet = ServerEventFactory.getInstance().getAllRegisterEvent();
        List<ExpressionTempBean> esbBeans = Arrays.asList(beanSet.toArray(new ExpressionTempBean[beanSet.size()]));
        ListResultModel userStatusInfo = PageUtil.getDefaultPageList(esbBeans);
        return userStatusInfo;
    }

    @MethodChinaName(cname="\u83b7\u53d6\u6ce8\u518c\u670d\u52a1\u4fe1\u606f")
    @RequestMapping(value={"getBusBeanTemp"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public ListResultModel<Set<ExpressionTempBean>> getBusBeanTemp(String flowTypes) {
        ArrayList<EsbFlowType> types = new ArrayList<EsbFlowType>();
        if (flowTypes != null) {
            if (flowTypes.equals("all")) {
                types.addAll(Arrays.asList(EsbFlowType.values()));
            } else {
                String[] flowTypeArr;
                for (String app : flowTypeArr = StringUtility.split((String)flowTypes, (String)";")) {
                    types.add(EsbFlowType.fromType((String)app));
                }
            }
        }
        List esbBeans = EsbBeanFactory.getInstance().getServiceBeanByFlowType(types.toArray(new EsbFlowType[0]));
        ListResultModel userStatusInfo = PageUtil.getDefaultPageList((List)esbBeans);
        return userStatusInfo;
    }

    @MethodChinaName(cname="\u83b7\u53d6\u8fdc\u7a0b\u670d\u52a1\u4fe1\u606f")
    @RequestMapping(value={"getRemoteClusterSevice"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public ListResultModel<List<XUIService>> getRemoteClusterSevice(String classification) {
        ListResultModel userStatusInfo = new ListResultModel();
        try {
            userStatusInfo = PageUtil.getDefaultPageList((List)JDSServer.getInstance().getClusterSevice(), XUIService.class);
        }
        catch (JDSException e) {
            userStatusInfo = new ErrorListResultModel();
            ((ErrorListResultModel)userStatusInfo).setErrcode(e.getErrorCode());
            ((ErrorListResultModel)userStatusInfo).setErrdes(e.getMessage());
        }
        return userStatusInfo;
    }

    @MethodChinaName(cname="\u66f4\u65b0\u7cfb\u7edf\u670d\u52a1\u4fe1\u606f")
    @RequestMapping(value={"updateSystemInfo"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public ResultModel<Boolean> updateSystemInfo(@RequestBody SubSystem subSystem) {
        return this.saveSysem(subSystem);
    }

    ResultModel<Boolean> saveSysem(SubSystem subSystem) {
        ResultModel userStatusInfo = new ResultModel();
        try {
            this.getSysWebManager().saveSystemInfo(subSystem).get();
        }
        catch (JDSException e) {
            userStatusInfo = new ErrorResultModel();
            ((ErrorResultModel)userStatusInfo).setErrcode(e.getErrorCode());
            ((ErrorResultModel)userStatusInfo).setErrdes(e.getMessage());
        }
        return userStatusInfo;
    }

    SysWebManager getSysWebManager() {
        return (SysWebManager)EsbUtil.parExpression((String)"$SysWebManager");
    }
}

