/*
 * Decompiled with CFR 0.152.
 */
package com.ds.esd.admin.plugins.service;

import com.ds.common.JDSException;
import com.ds.common.util.StringUtility;
import com.ds.config.ErrorListResultModel;
import com.ds.config.ErrorResultModel;
import com.ds.config.ListResultModel;
import com.ds.config.ResultModel;
import com.ds.enums.db.MethodChinaName;
import com.ds.esd.client.ESDClient;
import com.ds.esd.client.ESDFacrory;
import com.ds.esd.client.Project;
import com.ds.esd.client.ProjectVersion;
import com.ds.esd.plugins.style.node.StyleConfig;
import com.ds.esd.plugins.style.node.StyleNode;
import com.ds.esd.project.config.ProjectConfig;
import com.ds.esd.project.enums.ProjectResourceType;
import java.util.ArrayList;
import java.util.List;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/admin/plugs/style/"})
@MethodChinaName(cname="\u6837\u5f0f\u670d\u52a1")
public class StyleService {
    @MethodChinaName(cname="\u6837\u5f0f\u914d\u7f6e")
    @RequestMapping(value={"getSelStyle"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public ListResultModel<List<StyleConfig>> getSelStyle(@PathVariable String projectName) {
        ListResultModel result = new ListResultModel();
        List styleConfigs = new ArrayList();
        try {
            ProjectVersion projectVersion = this.getClient().getProjectVersionByName(projectName);
            styleConfigs = projectVersion.getProject().getStyles();
            result.setData(styleConfigs);
        }
        catch (JDSException e) {
            e.printStackTrace();
            ErrorListResultModel errorResult = new ErrorListResultModel();
            errorResult.setErrdes(e.getMessage());
            result = errorResult;
        }
        return result;
    }

    @MethodChinaName(cname="\u6dfb\u52a0\u6837\u5f0f")
    @RequestMapping(value={"addStyle"}, method={RequestMethod.POST})
    @ResponseBody
    public ResultModel<Boolean> addStyle(String projectName, String id) {
        ResultModel result = new ResultModel();
        try {
            ProjectVersion version = this.getClient().getProjectVersionByName(projectName);
            String[] ids = StringUtility.split((String)id, (String)";");
            ProjectConfig config = version.getProject().getConfig();
            List styleIds = config.getStyles();
            for (String apiId : ids) {
                if (styleIds.contains(apiId)) continue;
                styleIds.add(apiId);
            }
            config.setImgs(styleIds);
            version.updateConfig(config);
        }
        catch (JDSException e) {
            result = new ErrorResultModel();
            ((ErrorResultModel)result).setErrcode(100);
            ((ErrorResultModel)result).setErrdes(e.getMessage());
        }
        return result;
    }

    @MethodChinaName(cname="\u83b7\u53d6\u6837\u5f0f\u5b9a\u4e49\u6811")
    @RequestMapping(value={"getStyleTreeProject"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public ListResultModel<List<StyleNode>> getStyleTreeProject() {
        ListResultModel result = new ListResultModel();
        ArrayList<StyleNode> styleNodes = new ArrayList<StyleNode>();
        try {
            List projects = this.getClient().getResourceAllProject(ProjectResourceType.css);
            for (Project project : projects) {
                styleNodes.add(new StyleNode(project));
            }
            result.setData(styleNodes);
        }
        catch (JDSException e) {
            e.printStackTrace();
        }
        return result;
    }

    @MethodChinaName(cname="\u5220\u9664\u6837\u5f0f")
    @RequestMapping(value={"delStyle"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public ResultModel<Boolean> delStyle(String projectName, String id) {
        ResultModel result = new ResultModel();
        List styleConfigIds = new ArrayList();
        try {
            Project project = this.getClient().getProjectByName(projectName);
            styleConfigIds = project.getConfig().getStyles();
            styleConfigIds.remove(id);
            this.getClient().updateProjectConfig(project.getId(), project.getConfig());
        }
        catch (JDSException e) {
            e.printStackTrace();
            ErrorResultModel errorResult = new ErrorResultModel();
            errorResult.setErrdes(e.getMessage());
            errorResult.setErrcode(e.getErrorCode());
            result = errorResult;
        }
        return result;
    }

    @MethodChinaName(cname="\u83b7\u53d6\u5de5\u7a0b\u6837\u5f0f")
    @RequestMapping(value={"getProjectStyles"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public ListResultModel<List<StyleConfig>> getProjectImgs(String projectName) {
        ListResultModel result = new ListResultModel();
        try {
            Project project = this.getClient().getProjectByName(projectName);
            List fontConfigs = project.getStyles();
            result.setData((Object)fontConfigs);
        }
        catch (JDSException e) {
            e.printStackTrace();
        }
        return result;
    }

    public ESDClient getClient() throws JDSException {
        ESDClient client = ESDFacrory.getESDClient();
        return client;
    }
}

