/*
 * Decompiled with CFR 0.152.
 */
package com.ds.esd.admin.plugins.service;

import com.ds.common.JDSException;
import com.ds.common.md5.MD5;
import com.ds.common.md5.MD5InputStream;
import com.ds.common.util.IOUtility;
import com.ds.common.util.StringUtility;
import com.ds.config.ErrorListResultModel;
import com.ds.config.JDSConfig;
import com.ds.config.ListResultModel;
import com.ds.config.ResultModel;
import com.ds.context.JDSActionContext;
import com.ds.enums.db.MethodChinaName;
import com.ds.esd.admin.node.XUIFile;
import com.ds.esd.client.ESDClient;
import com.ds.esd.client.ESDFacrory;
import com.ds.esd.client.ProjectVersion;
import com.ds.esd.editor.enums.PackagePathType;
import com.ds.esd.editor.enums.PackageType;
import com.ds.esd.plugins.font.node.FontConfig;
import com.ds.esd.project.enums.ProjectDefAccess;
import com.ds.esd.tool.module.EUModule;
import com.ds.vfs.FileInfo;
import com.ds.vfs.Folder;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/RAD/{projectName}/"})
@MethodChinaName(cname="XUI\u7f16\u8f91\u5668")
public class RADEditor {
    @RequestMapping(value={"export"}, method={RequestMethod.GET})
    @ResponseBody
    public ResultModel<Boolean> export(@PathVariable String projectName) {
        ResultModel resultModel = new ResultModel();
        try {
            File file;
            ProjectVersion version = this.getClient().getProjectVersionByName(projectName);
            List fileInfos = version.getRootFolder().getFileListRecursively();
            for (FileInfo fileInfo : fileInfos) {
                if (fileInfo.getName().endsWith(".cls")) continue;
                String localPath = JDSConfig.Config.tempPath().getPath() + File.separator;
                String realPath = StringUtility.replace((String)fileInfo.getPath(), (String)version.getRootFolder().getPath(), (String)"/");
                file = new File(localPath + realPath);
                MD5InputStream input = fileInfo.getCurrentVersion().getInputStream();
                if (file.getParentFile() != null && !file.getParentFile().exists()) {
                    file.getParentFile().mkdirs();
                }
                if (!file.exists()) {
                    file.createNewFile();
                }
                FileOutputStream output = new FileOutputStream(file);
                IOUtility.copy((InputStream)input, (OutputStream)output);
                IOUtility.shutdownStream((InputStream)input);
                IOUtility.shutdownStream((OutputStream)output);
            }
            JDSActionContext.getActionContext().getContext().put("build", "false");
            Set modules = version.getAllModule();
            for (EUModule module : modules) {
                String localPath = JDSConfig.Config.tempPath().getPath() + File.separator;
                file = new File(localPath + "cls/" + MD5.getHashString((String)module.getClassName()));
                StringBuffer json = ESDFacrory.getESDClient().genJSON(module, null);
                ByteArrayInputStream input = null;
                input = new ByteArrayInputStream(json.toString().getBytes("UTF-8"));
                if (file.getParentFile() != null && !file.getParentFile().exists()) {
                    file.getParentFile().mkdirs();
                }
                if (!file.exists()) {
                    file.createNewFile();
                }
                FileOutputStream output = new FileOutputStream(file);
                IOUtility.copy((InputStream)input, (OutputStream)output);
                IOUtility.shutdownStream((InputStream)input);
                IOUtility.shutdownStream((OutputStream)output);
            }
            JDSActionContext.getActionContext().getContext().remove("build");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (JDSException e) {
            e.printStackTrace();
        }
        return resultModel;
    }

    @RequestMapping(value={"debug"}, method={RequestMethod.GET})
    public ModelAndView debug(ModelAndView mv, @PathVariable String projectName) {
        mv.addObject("projectName", (Object)projectName);
        ArrayList<FileInfo> cssFiles = new ArrayList<FileInfo>();
        try {
            ProjectVersion version = this.getClient().getProjectVersionByName(projectName);
            List fontNodes = version.getProject().getFonts();
            for (FontConfig fontNode : fontNodes) {
                Folder folder = this.getClient().getFolderByPath(new String[]{fontNode.getFile()});
                List fileInfos = folder.getFileListRecursively();
                for (FileInfo cssFile : fileInfos) {
                    if (!cssFile.getName().endsWith(".css") || cssFiles.contains(cssFile)) continue;
                    cssFiles.add(cssFile);
                }
            }
        }
        catch (JDSException e) {
            e.printStackTrace();
        }
        mv.addObject("cssFiles", cssFiles);
        mv.setViewName("/projectDebug");
        return mv;
    }

    private List<XUIFile> getTopFolder(String projectName, PackageType type) throws JDSException {
        ArrayList<XUIFile> modules = new ArrayList<XUIFile>();
        ProjectVersion projectVersion = this.getClient().getProjectVersionByName(projectName);
        List folders = projectVersion.getRootFolder().getChildrenList();
        for (Folder cfolder : folders) {
            String path = StringUtility.replace((String)cfolder.getPath(), (String)projectVersion.getPath(), (String)"/");
            PackagePathType packagePathType = PackagePathType.startPath((String)path);
            if (packagePathType != null && type != null && !packagePathType.getApiType().equals((Object)type) && !projectVersion.getProject().getProjectType().equals((Object)ProjectDefAccess.DSM)) continue;
            modules.add(new XUIFile(cfolder, projectVersion));
        }
        return modules;
    }

    @MethodChinaName(cname="\u88c5\u8f7d\u7cfb\u7edf\u76ee\u5f55")
    @RequestMapping(value={"loadSystemFolder"}, method={RequestMethod.GET})
    @ResponseBody
    public ListResultModel<List<XUIFile>> loadSystemFolder(@PathVariable String projectName) {
        ListResultModel result = new ListResultModel();
        try {
            List<Object> modules = new ArrayList();
            this.getClient().reLoadProjectRoot(projectName);
            modules = this.getTopFolder(projectName, PackageType.system);
            result.setData(modules);
        }
        catch (JDSException e) {
            result = new ErrorListResultModel();
            ((ErrorListResultModel)result).setErrcode(100);
            ((ErrorListResultModel)result).setErrdes(e.getMessage());
        }
        return result;
    }

    @MethodChinaName(cname="\u88c5\u8f7d\u5de5\u7a0b")
    @RequestMapping(value={"openProject"}, method={RequestMethod.GET})
    @ResponseBody
    public ListResultModel<List<XUIFile>> openProject(@PathVariable String projectName) {
        ListResultModel result = new ListResultModel();
        List<Object> modules = new ArrayList();
        String[] systemFiles = new String[]{"ProjectConfig.cfg", "xuiconf.js"};
        try {
            ProjectVersion projectVersion = this.getClient().getProjectVersionByName(projectName);
            modules = this.getTopFolder(projectName, PackageType.local);
            List infos = projectVersion.getRootFolder().getFileList();
            for (FileInfo fileInfo : infos) {
                boolean isSystem = false;
                for (String name : systemFiles) {
                    if (!fileInfo.getName().equals(name)) continue;
                    isSystem = true;
                }
                if (isSystem) continue;
                if (!fileInfo.getName().endsWith(".cls")) {
                    modules.add(new XUIFile(fileInfo, projectVersion));
                    continue;
                }
                EUModule module = projectVersion.getModule(fileInfo.getPath());
                modules.add(new XUIFile(module));
            }
            result.setData(modules);
        }
        catch (JDSException e) {
            result = new ErrorListResultModel();
            ((ErrorListResultModel)result).setErrcode(100);
            ((ErrorListResultModel)result).setErrdes(e.getMessage());
        }
        return result;
    }

    @MethodChinaName(cname="\u83b7\u53d6\u5de5\u7a0b\u914d\u7f6e\u4fe1\u606f")
    @RequestMapping(value={"getProjectConfig"}, produces={"application/javascript;charset=utf-8"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public String getProjectConfig(@PathVariable String projectName) {
        String conf = "{}";
        try {
            conf = this.getClient().readFileAsString(new String[]{"xuiconf.js", projectName});
        }
        catch (JDSException e) {
            e.printStackTrace();
            return e.getMessage();
        }
        return conf;
    }

    ESDClient getClient() throws JDSException {
        ESDClient client = ESDFacrory.getESDClient();
        return client;
    }
}

