/*
 * Decompiled with CFR 0.152.
 */
package com.ds.esd.admin.plugins.service;

import com.ds.common.JDSException;
import com.ds.common.md5.MD5InputStream;
import com.ds.config.ErrorResultModel;
import com.ds.config.ListResultModel;
import com.ds.config.ResultModel;
import com.ds.enums.db.MethodChinaName;
import com.ds.esd.admin.node.XUIFile;
import com.ds.esd.admin.node.XUIModule;
import com.ds.esd.client.ESDClient;
import com.ds.esd.client.ESDFacrory;
import com.ds.esd.client.ProjectVersion;
import com.ds.esd.project.enums.ProjectTempType;
import com.ds.esd.project.temp.ProjectTemp;
import com.ds.vfs.FileInfo;
import com.ds.vfs.Folder;
import com.ds.vfs.ct.CtVfsFactory;
import com.ds.vfs.ct.CtVfsService;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/admin/temp/"})
@MethodChinaName(cname="RAD\u7f16\u8f91\u5668\u7ba1\u7406")
public class ProjectTempServcie {
    @MethodChinaName(cname="\u83b7\u53d6\u5de5\u7a0b\u5206\u7c7b")
    @RequestMapping(value={"getTempType"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public ListResultModel<List<ProjectTemp>> getTempType(String path, String pattern) {
        ListResultModel result = new ListResultModel();
        ArrayList<ProjectTemp> temps = new ArrayList<ProjectTemp>();
        for (ProjectTempType type : ProjectTempType.values()) {
            ProjectTemp temp = new ProjectTemp(type);
            temps.add(temp);
        }
        result.setData(temps);
        return result;
    }

    @MethodChinaName(cname="\u83b7\u53d6\u9875\u9762\u6a21\u677f")
    @RequestMapping(value={"getTempPage"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public ResultModel<XUIModule> getTempPage(String path, String pattern) {
        ResultModel result = new ResultModel();
        XUIModule xuiModule = new XUIModule();
        List<XUIFile> modules = xuiModule.getFiles();
        Folder folder = null;
        try {
            ProjectVersion version = this.getClient().getProjectVersionByName(path);
            folder = this.getVfsClient().getFolderByPath(path);
            if (folder != null) {
                List infos = folder.getChildrenRecursivelyList();
                for (Folder cfolder : infos) {
                    List fileInfos = cfolder.getFileList();
                    boolean isProject = false;
                    for (FileInfo fileInfo : fileInfos) {
                        if (!fileInfo.getName().equals("xuiconf.js")) continue;
                        isProject = true;
                    }
                    if (!isProject) continue;
                    if (pattern != null && !pattern.equals("")) {
                        Pattern p = Pattern.compile(pattern);
                        Matcher matcher = p.matcher(cfolder.getName());
                        if (!matcher.find()) continue;
                        modules.add(new XUIFile(cfolder, version));
                        continue;
                    }
                    modules.add(new XUIFile(cfolder, version));
                }
            }
            result.setData((Object)xuiModule);
        }
        catch (JDSException e) {
            result = new ErrorResultModel();
            ((ErrorResultModel)result).setErrcode(100);
            ((ErrorResultModel)result).setErrdes(e.getMessage());
        }
        return result;
    }

    @MethodChinaName(cname="\u83b7\u53d6\u5de5\u7a0b\u6570\u636e")
    @RequestMapping(value={"getAllSystemProject"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public ResultModel<XUIModule> getAllSystemProject(String path, String pattern) {
        ResultModel result = new ResultModel();
        XUIModule xuiModule = new XUIModule();
        List<XUIFile> modules = xuiModule.getFiles();
        Folder folder = null;
        try {
            ProjectVersion version = this.getClient().getProjectVersionByName(path);
            folder = this.getVfsClient().getFolderByPath(path);
            if (folder != null) {
                List infos = folder.getChildrenRecursivelyList();
                for (Folder cfolder : infos) {
                    List fileInfos = cfolder.getFileList();
                    boolean isProject = false;
                    for (FileInfo fileInfo : fileInfos) {
                        if (!fileInfo.getName().equals("xuiconf.js")) continue;
                        isProject = true;
                    }
                    if (!isProject) continue;
                    if (pattern != null && !pattern.equals("")) {
                        Pattern p = Pattern.compile(pattern);
                        Matcher matcher = p.matcher(cfolder.getName());
                        if (!matcher.find()) continue;
                        modules.add(new XUIFile(cfolder, version));
                        continue;
                    }
                    modules.add(new XUIFile(cfolder, version));
                }
            }
            result.setData((Object)xuiModule);
        }
        catch (JDSException e) {
            result = new ErrorResultModel();
            ((ErrorResultModel)result).setErrcode(100);
            ((ErrorResultModel)result).setErrdes(e.getMessage());
        }
        return result;
    }

    @MethodChinaName(cname="\u83b7\u53d6\u6240\u6709\u6a21\u677f\u5de5\u7a0b")
    @RequestMapping(value={"getProjectTemp"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public ResultModel<XUIModule> getProjectTemp(String path) {
        ResultModel result = new ResultModel();
        XUIModule xuiModule = new XUIModule();
        List<XUIFile> modules = xuiModule.getFiles();
        Folder folder = null;
        try {
            folder = this.getVfsClient().getFolderByPath(path);
            ProjectVersion version = this.getClient().getProjectVersionByName(path);
            if (folder != null) {
                List folders = folder.getChildrenList();
                for (Folder cfolder : folders) {
                    modules.add(new XUIFile(cfolder, version));
                }
                FileInfo fileInfo = this.getVfsClient().getFileByPath(folder.getPath() + "config.json");
                if (fileInfo != null) {
                    xuiModule.setConf(this.readFile(fileInfo.getPath()));
                }
            }
            result.setData((Object)xuiModule);
        }
        catch (JDSException e) {
            result = new ErrorResultModel();
            ((ErrorResultModel)result).setErrcode(100);
            ((ErrorResultModel)result).setErrdes(e.getMessage());
        }
        return result;
    }

    @RequestMapping(value={"adminManager"}, method={RequestMethod.GET})
    public void adminManager(HttpServletResponse response) {
        MD5InputStream stream = null;
        FileInfo fileInfo = null;
        try {
            int length;
            fileInfo = this.getVfsClient().getFileByPath("system/adminManager.html");
            if (fileInfo != null) {
                stream = fileInfo.getCurrentVersonInputStream();
            }
            ServletOutputStream os = response.getOutputStream();
            byte[] b = new byte[4096];
            while ((length = stream.read(b)) > 0) {
                os.write(b, 0, length);
            }
            try {
                os.close();
                stream.close();
            }
            catch (IOException iOException) {}
        }
        catch (JDSException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private String readFile(String path) {
        String json = "{}";
        try {
            json = this.getVfsClient().readFileAsString(path, "UTF-8").toString();
        }
        catch (JDSException e) {
            e.printStackTrace();
        }
        return json;
    }

    public ESDClient getClient() throws JDSException {
        ESDClient client = ESDFacrory.getESDClient();
        return client;
    }

    public CtVfsService getVfsClient() {
        CtVfsService vfsClient = CtVfsFactory.getCtVfsService();
        return vfsClient;
    }
}

