/*
 * Decompiled with CFR 0.152.
 */
package com.ds.esd.admin.plugins.service;

import com.ds.common.JDSException;
import com.ds.common.database.metadata.MetadataFactory;
import com.ds.common.database.metadata.TableInfo;
import com.ds.common.md5.MD5InputStream;
import com.ds.common.util.StringUtility;
import com.ds.config.ErrorListResultModel;
import com.ds.config.ErrorResultModel;
import com.ds.config.ListResultModel;
import com.ds.config.ResultModel;
import com.ds.enums.db.MethodChinaName;
import com.ds.esd.admin.node.XUIFile;
import com.ds.esd.admin.node.XUIModule;
import com.ds.esd.admin.plugins.fdt.node.UITopNode;
import com.ds.esd.client.ESDClient;
import com.ds.esd.client.ESDFacrory;
import com.ds.esd.client.Project;
import com.ds.esd.client.ProjectVersion;
import com.ds.esd.dsm.DSMFactory;
import com.ds.esd.dsm.gen.UIGenTools;
import com.ds.esd.dsm.repository.database.proxy.DSMTableProxy;
import com.ds.esd.editor.enums.PackageType;
import com.ds.esd.plugins.api.node.APIPaths;
import com.ds.esd.plugins.font.node.FontConfig;
import com.ds.esd.plugins.img.node.ImgConfig;
import com.ds.esd.project.config.DataBaseConfig;
import com.ds.esd.project.enums.ProjectDefAccess;
import com.ds.esd.tool.module.EUModule;
import com.ds.esd.tool.module.EUPackage;
import com.ds.esd.tool.node.XUIModuleFile;
import com.ds.esd.tool.node.XUISyncFile;
import com.ds.esd.tool.toolbox.UIComponentNode;
import com.ds.esd.tool.ui.component.Component;
import com.ds.esd.tool.ui.component.data.APICallerComponent;
import com.ds.esd.tool.ui.component.data.APICallerProperties;
import com.ds.esd.tool.ui.module.ModuleComponent;
import com.ds.vfs.FileInfo;
import com.ds.vfs.Folder;
import com.ds.vfs.ct.CtVfsFactory;
import com.ds.vfs.ct.CtVfsService;
import com.ds.web.APIConfig;
import com.ds.web.APIConfigFactory;
import com.ds.web.RequestMethodBean;
import com.ds.web.util.PageUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/RAD/{projectName}/plugs/"})
@MethodChinaName(cname="RAD\u5de5\u5177\u5e94\u7528")
public class PlugsService {
    @MethodChinaName(cname="\u4ece\u6a21\u677f\u6dfb\u52a0\u6587\u4ef6")
    @RequestMapping(value={"addFromTpl"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public ResultModel<XUIModule> addFromTpl(String className, String tempPath, @PathVariable String projectName) {
        ResultModel result = new ResultModel();
        XUIModule xuiModule = new XUIModule();
        List<XUIFile> modules = xuiModule.getFiles();
        try {
            FileInfo tempFile = this.getVfsClient().getFileByPath(tempPath);
            String json = this.getVfsClient().readFileAsString(tempFile.getPath(), "UTF-8").toString();
            this.getClient().saveModuleAsJson(projectName, className, json);
        }
        catch (JDSException e) {
            e.printStackTrace();
        }
        if (tempPath == null || tempPath.equals("")) {
            tempPath = "template/cn/index.js";
        }
        return result;
    }

    @MethodChinaName(cname="\u83b7\u53d6\u6240\u6709XUI\u7c7b")
    @RequestMapping(value={"getAllClass"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public ListResultModel<List<XUIFile>> getAllClass(@PathVariable String projectName) {
        ArrayList<XUIFile> classList = new ArrayList<XUIFile>();
        ListResultModel result = new ListResultModel();
        Set modules = null;
        try {
            ProjectVersion projectVersion = this.getClient().getProjectVersionByName(projectName);
            modules = projectVersion.getAllModule();
            for (EUModule module : modules) {
                if (module == null) continue;
                classList.add(new XUIFile(module));
            }
            result.setData(classList);
        }
        catch (JDSException e) {
            e.printStackTrace();
            ErrorListResultModel errorResult = new ErrorListResultModel();
            errorResult.setErrdes(e.getMessage());
            result = errorResult;
        }
        return result;
    }

    @MethodChinaName(cname="\u83b7\u53d6\u6240\u6709XUI\u7c7b")
    @RequestMapping(value={"getAllClassComponents"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public ListResultModel<List<XUIFile>> getAllClassComponents(@PathVariable String projectName) {
        ArrayList<XUIFile> classList = new ArrayList<XUIFile>();
        ListResultModel result = new ListResultModel();
        Set modules = null;
        try {
            ProjectVersion projectVersion = this.getClient().getProjectVersionByName(projectName);
            modules = projectVersion.getAllModule();
            for (EUModule module : modules) {
                if (module == null) continue;
                classList.add(new XUIFile(module));
            }
            result.setData(classList);
        }
        catch (JDSException e) {
            e.printStackTrace();
            ErrorListResultModel errorResult = new ErrorListResultModel();
            errorResult.setErrdes(e.getMessage());
            result = errorResult;
        }
        return result;
    }

    @MethodChinaName(cname="\u5b57\u4f53\u7c7b\u914d\u7f6e")
    @RequestMapping(value={"getSelFont"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public ListResultModel<List<FontConfig>> getSelFont(@PathVariable String projectName) {
        ListResultModel result = new ListResultModel();
        List fontConfigs = new ArrayList();
        try {
            ProjectVersion projectVersion = this.getClient().getProjectVersionByName(projectName);
            fontConfigs = projectVersion.getProject().getFonts();
            result.setData(fontConfigs);
        }
        catch (JDSException e) {
            e.printStackTrace();
            ErrorListResultModel errorResult = new ErrorListResultModel();
            errorResult.setErrdes(e.getMessage());
            result = errorResult;
        }
        return result;
    }

    @MethodChinaName(cname="\u56fe\u7247\u7c7b\u914d\u7f6e")
    @RequestMapping(value={"getSelImg"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public ListResultModel<List<ImgConfig>> getSelImg(@PathVariable String projectName) {
        ListResultModel result = new ListResultModel();
        List imgConfigs = new ArrayList();
        try {
            ProjectVersion projectVersion = this.getClient().getProjectVersionByName(projectName);
            imgConfigs = projectVersion.getProject().getImgs();
            result.setData(imgConfigs);
        }
        catch (JDSException e) {
            e.printStackTrace();
            ErrorListResultModel errorResult = new ErrorListResultModel();
            errorResult.setErrdes(e.getMessage());
            result = errorResult;
        }
        return result;
    }

    @MethodChinaName(cname="\u56fe\u7247\u7c7b\u914d\u7f6e")
    @RequestMapping(value={"getSelImgByPath"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public ResultModel<ImgConfig> getSelImgByPath(@PathVariable String projectName, String path) {
        ResultModel result = new ResultModel();
        try {
            ProjectVersion projectVersion = this.getClient().getProjectVersionByName(projectName);
            ImgConfig imgConfig = this.getClient().getImgConfig(path);
            result.setData((Object)imgConfig);
        }
        catch (JDSException e) {
            e.printStackTrace();
            ErrorResultModel errorResult = new ErrorResultModel();
            errorResult.setErrdes(e.getMessage());
            result = errorResult;
        }
        return result;
    }

    @MethodChinaName(cname="\u83b7\u53d6\u5de5\u7a0b\u5185\u56fe\u7247")
    @RequestMapping(value={"getInnerImg"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public ListResultModel<List<ImgConfig>> getInnerImg(@PathVariable String projectName, String path) {
        ListResultModel result = new ListResultModel();
        ArrayList<ImgConfig> imgConfigs = new ArrayList<ImgConfig>();
        try {
            ImgConfig imgConfig = this.getClient().buildImgConfig(projectName, path);
            imgConfigs.add(imgConfig);
            result.setData(imgConfigs);
        }
        catch (JDSException e) {
            e.printStackTrace();
            ErrorListResultModel errorResult = new ErrorListResultModel();
            errorResult.setErrdes(e.getMessage());
            result = errorResult;
        }
        return result;
    }

    @RequestMapping(value={"API"}, method={RequestMethod.GET})
    public ResultModel<Boolean> api(HttpServletResponse response, @PathVariable String projectName) {
        MD5InputStream stream = null;
        FileInfo fileInfo = null;
        try {
            int length;
            fileInfo = this.getVfsClient().getFileByPath("root/RAD/API/index.html");
            if (fileInfo != null) {
                stream = fileInfo.getCurrentVersonInputStream();
            }
            ServletOutputStream os = response.getOutputStream();
            byte[] b = new byte[4096];
            while ((length = stream.read(b)) > 0) {
                os.write(b, 0, length);
            }
            try {
                os.close();
                stream.close();
            }
            catch (IOException iOException) {}
        }
        catch (JDSException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return new ResultModel();
    }

    @MethodChinaName(cname="\u83b7\u53d6\u6269\u5c55\u6a21\u5757\u5e93")
    @RequestMapping(value={"getExtModuleProjectTree"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public ListResultModel<List<XUIFile>> getExtModuleProjectTree(@PathVariable String projectName) {
        ListResultModel result = new ListResultModel();
        ArrayList<XUIFile> xuiFiles = new ArrayList<XUIFile>();
        ArrayList folders = new ArrayList();
        try {
            List projects = this.getClient().getAllProject(ProjectDefAccess.Module);
            for (Project project : projects) {
                Set modules = null;
                ProjectVersion projectVersion = project.getActiveProjectVersion();
                try {
                    modules = projectVersion.getAllModule();
                }
                catch (JDSException e) {
                    e.printStackTrace();
                }
                if (modules == null || modules.size() <= 0) continue;
                XUIFile xuiFile = new XUIFile(projectVersion);
                xuiFile.setCaption(projectVersion.getProject().getDesc() == null ? projectVersion.getProject().getProjectName() : projectVersion.getProject().getDesc());
                xuiFiles.add(xuiFile);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            ErrorListResultModel errorResult = new ErrorListResultModel();
            errorResult.setErrdes(e.getMessage());
            result = errorResult;
        }
        result.setData(xuiFiles);
        return result;
    }

    @MethodChinaName(cname="\u83b7\u53d6\u6269\u5c55\u7ec4\u4ef6\u5e93")
    @RequestMapping(value={"getExtComProjectTree"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public ListResultModel<List<XUIFile>> getExtComProjectTree(@PathVariable String projectName) {
        ListResultModel result = new ListResultModel();
        ArrayList<XUIFile> xuiFiles = new ArrayList<XUIFile>();
        ArrayList folders = new ArrayList();
        try {
            List projects = this.getClient().getAllProject(ProjectDefAccess.Component);
            for (Project project : projects) {
                Set modules = null;
                ProjectVersion projectVersion = project.getActiveProjectVersion();
                try {
                    modules = projectVersion.getAllModule();
                }
                catch (JDSException e) {
                    e.printStackTrace();
                }
                if (modules == null || modules.size() <= 0) continue;
                XUIFile xuiFile = new XUIFile(projectVersion);
                xuiFile.setCaption(projectVersion.getProject().getDesc() == null ? projectVersion.getProject().getProjectName() : projectVersion.getProject().getDesc());
                xuiFiles.add(xuiFile);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            ErrorListResultModel errorResult = new ErrorListResultModel();
            errorResult.setErrdes(e.getMessage());
            result = errorResult;
        }
        result.setData(xuiFiles);
        return result;
    }

    @MethodChinaName(cname="\u83b7\u53d6\u6240\u6709\u5de5\u7a0b")
    @RequestMapping(value={"getAllProjectTree"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public ListResultModel<List<XUIFile>> getAllProjectTree(@PathVariable String projectName, String tpath) {
        ListResultModel result = new ListResultModel();
        ArrayList<XUIFile> xuiFiles = new ArrayList<XUIFile>();
        ArrayList folders = new ArrayList();
        try {
            Project sproject = this.getClient().getProjectByName(projectName);
            ProjectDefAccess type = sproject.getProjectType();
            List projects = this.getClient().getAllProject(type);
            for (Project project : projects) {
                Set modules = null;
                ProjectVersion projectVersion = project.getActiveProjectVersion();
                try {
                    modules = projectVersion.getAllModule();
                }
                catch (JDSException e) {
                    e.printStackTrace();
                }
                if (modules == null || modules.size() <= 0) continue;
                XUIFile xuiFile = new XUIFile(projectVersion);
                xuiFile.setCaption(projectVersion.getProject().getDesc() == null ? projectVersion.getProject().getProjectName() : projectVersion.getProject().getDesc());
                xuiFile.setSub(new ArrayList<XUIFile>());
                xuiFiles.add(xuiFile);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            ErrorListResultModel errorResult = new ErrorListResultModel();
            errorResult.setErrdes(e.getMessage());
            result = errorResult;
        }
        result.setData(xuiFiles);
        return result;
    }

    @MethodChinaName(cname="\u83b7\u53d6\u6240\u6709\u5305")
    @RequestMapping(value={"getAllClasses"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public ListResultModel<List<XUISyncFile>> getAllClasses(@PathVariable String projectName, String className) {
        ListResultModel result = new ListResultModel();
        ArrayList<XUISyncFile> xuiFiles = new ArrayList<XUISyncFile>();
        ArrayList folders = new ArrayList();
        HashMap<String, XUISyncFile> folderMap = new HashMap<String, XUISyncFile>();
        try {
            ProjectVersion projectVersion = this.getClient().getProjectVersionByName(projectName);
            EUModule euModule = projectVersion.getModule(className);
            EUPackage euPackage = projectVersion.getEUPackage(euModule.getPackageName());
            Set allModules = euPackage.listModules();
            for (EUModule module : allModules) {
                if (module == null || className != null && className.equals(module.getClassName())) continue;
                Folder folder = null;
                try {
                    folder = this.getClient().getFileByPath(new String[]{module.getPath(), projectName}).getFolder();
                    XUISyncFile xuiSyncFile = (XUISyncFile)folderMap.get(folder.getPath());
                    if (xuiSyncFile == null) {
                        xuiSyncFile = new XUISyncFile(folder, projectVersion);
                        folderMap.put(folder.getPath(), xuiSyncFile);
                        xuiFiles.add(xuiSyncFile);
                    }
                    XUIModuleFile moduleFile = new XUIModuleFile(module);
                    moduleFile.setType("");
                    moduleFile.setCaption(module.getName());
                    xuiSyncFile.getSub().add(moduleFile);
                }
                catch (JDSException e) {
                    e.printStackTrace();
                }
            }
            Collections.sort(xuiFiles, new Comparator<XUISyncFile>(){

                @Override
                public int compare(XUISyncFile o1, XUISyncFile o2) {
                    return o1.getClassName().compareTo(o2.getClassName());
                }
            });
            result.setData(xuiFiles);
        }
        catch (JDSException e) {
            e.printStackTrace();
            ErrorListResultModel errorResult = new ErrorListResultModel();
            errorResult.setErrdes(e.getMessage());
            result = errorResult;
        }
        return result;
    }

    @MethodChinaName(cname="\u83b7\u53d6\u6240\u6709\u5305")
    @RequestMapping(value={"getAllPackages"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public ListResultModel<List<XUIFile>> getAllPackages(String projectName, String type, String pattern) {
        ListResultModel result = new ListResultModel();
        ArrayList<XUIFile> xuiFiles = new ArrayList<XUIFile>();
        ArrayList folders = new ArrayList();
        try {
            ProjectVersion projectVersion = this.getClient().getProjectVersionByName(projectName);
            List packages = this.getClient().getAllPackage(projectName, PackageType.local);
            for (EUPackage euPackage : packages) {
                if (euPackage.findModules(type, pattern).size() <= 0) continue;
                xuiFiles.add(new XUIFile(euPackage));
            }
            Collections.sort(xuiFiles, new Comparator<XUIFile>(){

                @Override
                public int compare(XUIFile o1, XUIFile o2) {
                    return o1.getClassName().compareTo(o2.getClassName());
                }
            });
            result.setData(xuiFiles);
        }
        catch (JDSException e) {
            e.printStackTrace();
            ErrorListResultModel errorResult = new ErrorListResultModel();
            errorResult.setErrdes(e.getMessage());
            result = errorResult;
        }
        return result;
    }

    @MethodChinaName(cname="\u83b7\u53d6\u6240\u6709\u5305")
    @RequestMapping(value={"getAPIPackages"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public ListResultModel<List<APIPaths>> getAPIPackages(String projectName) {
        ListResultModel result = new ListResultModel();
        ArrayList<APIPaths> xuiFiles = new ArrayList<APIPaths>();
        ArrayList folders = new ArrayList();
        try {
            ProjectVersion projectVersion = this.getClient().getProjectVersionByName(projectName);
            List apiConfigs = this.getClient().getAPIConfigByProject(projectName);
            for (APIConfig apiConfig : apiConfigs) {
                xuiFiles.add(new APIPaths("localhost", apiConfig));
            }
            Collections.sort(xuiFiles, new Comparator<APIPaths>(){

                @Override
                public int compare(APIPaths o1, APIPaths o2) {
                    return o1.getPath().compareTo(o2.getPath());
                }
            });
            result.setData(xuiFiles);
        }
        catch (JDSException e) {
            e.printStackTrace();
            ErrorListResultModel errorResult = new ErrorListResultModel();
            errorResult.setErrdes(e.getMessage());
            result = errorResult;
        }
        return result;
    }

    @MethodChinaName(cname="\u6307\u5b9a\u5305\u4e0b\u7ec4\u4ef6")
    @RequestMapping(value={"getAllComponentsByClass"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public ListResultModel<List<Object>> getAllComponentsByClass(@PathVariable String projectName, String className, String type, String pattern, Boolean draggable) {
        if (draggable == null) {
            draggable = true;
        }
        ListResultModel result = new ListResultModel();
        ArrayList<UIComponentNode> modules = new ArrayList<UIComponentNode>();
        try {
            EUModule module = this.getClient().getModule(className, projectName);
            ModuleComponent component = module.getComponent();
            if (component != null) {
                for (Object subcomponent : component.findComponents(type, pattern)) {
                    modules.add(new UIComponentNode((Component)subcomponent, draggable.booleanValue()));
                }
            }
            result.setData(modules);
        }
        catch (Exception e) {
            e.printStackTrace();
            ErrorListResultModel errorResult = new ErrorListResultModel();
            errorResult.setErrdes(e.getMessage());
            result = errorResult;
        }
        return result;
    }

    @MethodChinaName(cname="\u6307\u5b9a\u5305\u4e0b\u7ec4\u4ef6")
    @RequestMapping(value={"getAllComponentsByPath"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public ListResultModel<List<Object>> getAllComponentsByPath(String projectName, String path, String className, String type, String pattern, Boolean draggable) {
        if (draggable == null) {
            draggable = true;
        }
        ListResultModel result = new ListResultModel();
        ArrayList<UIComponentNode> modules = new ArrayList<UIComponentNode>();
        try {
            ProjectVersion projectVersion = this.getClient().getProjectVersionByName(projectName);
            Folder folder = this.getClient().getFolderByPath(new String[]{path, projectName});
            if (folder == null) {
                folder = this.getClient().createFolder(new String[]{path, projectName});
            }
            Set allModules = projectVersion.getAllModule();
            for (EUModule module : allModules) {
                ModuleComponent component;
                Folder mfolder;
                if (module == null || !(mfolder = this.getClient().getFileByPath(new String[]{module.getPath(), projectName}).getFolder()).getPath().equals(folder.getPath()) || (component = module.getComponent()) == null || component.findComponents(type, pattern) == null || component.findComponents(type, pattern).size() <= 0) continue;
                UIComponentNode node = new UIComponentNode((Component)component, draggable.booleanValue());
                modules.add(node);
            }
            result.setData(modules);
        }
        catch (Exception e) {
            e.printStackTrace();
            ErrorListResultModel errorResult = new ErrorListResultModel();
            errorResult.setErrdes(e.getMessage());
            result = errorResult;
        }
        return result;
    }

    @MethodChinaName(cname="\u68c0\u7d22\u5173\u8054\u52a8\u4f5c")
    @RequestMapping(value={"getComponents"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public ListResultModel<List<Object>> getComponents(@PathVariable String projectName) {
        ListResultModel result = new ListResultModel();
        ArrayList<UIComponentNode> modules = new ArrayList<UIComponentNode>();
        try {
            ProjectVersion projectVersion = this.getClient().getProjectVersionByName(projectName);
            Set allModules = projectVersion.getAllModule();
            for (EUModule module : allModules) {
                ModuleComponent component;
                if (module == null || (component = module.getComponent()) == null || component.getChildren() == null || component.getChildren().size() <= 0) continue;
                modules.add(new UIComponentNode((Component)component, true));
            }
            result.setData(modules);
        }
        catch (JDSException e) {
            e.printStackTrace();
            ErrorListResultModel errorResult = new ErrorListResultModel();
            errorResult.setErrdes(e.getMessage());
            result = errorResult;
        }
        return result;
    }

    @MethodChinaName(cname="\u83b7\u53d6\u6269\u5c55\u5e94\u7528\u5b9a\u4e49")
    @RequestMapping(value={"getExtModules"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public ListResultModel<List<Object>> getExtModules(@PathVariable String projectName) {
        ListResultModel result = new ListResultModel();
        ArrayList<UIComponentNode> modules = new ArrayList<UIComponentNode>();
        try {
            ProjectVersion projectVersion = this.getClient().getProjectVersionByName(projectName);
            Set allModules = projectVersion.getAllModule();
            for (EUModule module : allModules) {
                ModuleComponent component;
                if (module == null || (component = module.getComponent()) == null || component.getChildren() == null || component.getChildren().size() <= 0) continue;
                modules.add(new UIComponentNode((Component)component, true));
            }
            result.setData(modules);
        }
        catch (JDSException e) {
            e.printStackTrace();
            ErrorListResultModel errorResult = new ErrorListResultModel();
            errorResult.setErrdes(e.getMessage());
            result = errorResult;
        }
        return result;
    }

    @MethodChinaName(cname="\u83b7\u53d6\u6269\u5c55\u7ec4\u4ef6\u5b9a\u4e49")
    @RequestMapping(value={"getExtComs"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public ListResultModel<List<Object>> getExtComs(@PathVariable String projectName) {
        ListResultModel result = new ListResultModel();
        ArrayList<UIComponentNode> modules = new ArrayList<UIComponentNode>();
        try {
            ProjectVersion projectVersion = this.getClient().getProjectVersionByName(projectName);
            Set allModules = projectVersion.getAllModule();
            for (EUModule module : allModules) {
                ModuleComponent component;
                if (module == null || (component = module.getComponent()) == null || component.getChildren() == null || component.getChildren().size() <= 0) continue;
                modules.add(new UIComponentNode((Component)component, true));
            }
            result.setData(modules);
        }
        catch (JDSException e) {
            e.printStackTrace();
            ErrorListResultModel errorResult = new ErrorListResultModel();
            errorResult.setErrdes(e.getMessage());
            result = errorResult;
        }
        return result;
    }

    @MethodChinaName(cname="\u83b7\u53d6\u6240\u6709\u6570\u636e\u5e93\u8868")
    @RequestMapping(method={RequestMethod.POST}, value={"fdt/GetAllTableByName"})
    @ResponseBody
    public ListResultModel<List<TableInfo>> getAllTableByName(String simpleName, @PathVariable String projectName) {
        ListResultModel result = new ListResultModel();
        ArrayList<TableInfo> tables = new ArrayList<TableInfo>();
        try {
            ProjectVersion projectVersion = this.getClient().getProjectVersionByName(projectName);
            List configs = projectVersion.getProject().getConfig().getDbConfigs();
            for (DataBaseConfig config : configs) {
                try {
                    if (config.getConfigKey() == null || this.getClient().getDbFactory(config.getConfigKey()) == null) continue;
                    MetadataFactory factory = this.getClient().getDbFactory(config.getConfigKey());
                    List alltables = factory.getTableInfos(simpleName);
                    List tableNames = config.getTableName();
                    for (TableInfo table : alltables) {
                        if (tableNames != null && !tableNames.contains(table.getName())) continue;
                        tables.add(table);
                    }
                    result = PageUtil.getDefaultPageList(tables);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        catch (JDSException e) {
            ErrorListResultModel errorResult = new ErrorListResultModel();
            errorResult.setErrdes(e.getMessage());
            result = errorResult;
        }
        return result;
    }

    @MethodChinaName(cname="\u83b7\u53d6\u6570\u636e\u5e93\u8868\u7ec4\u4ef6")
    @RequestMapping(value={"GetTableComponents"}, method={RequestMethod.POST, RequestMethod.GET})
    @ResponseBody
    public ResultModel<List<UIComponentNode>> getTableComponents(String tableName, String configKey, @PathVariable String projectName, String repositoryId) {
        ResultModel result = new ResultModel();
        ArrayList<UIComponentNode> componentNodes = new ArrayList<UIComponentNode>();
        try {
            ProjectVersion version = this.getClient().getProjectVersionByName(projectName);
            UIGenTools tools = new UIGenTools(version, configKey);
            MetadataFactory metadataFactory = this.getClient().getDbFactory(configKey);
            DSMTableProxy proxy = DSMFactory.getInstance().getRepositoryManager().getTableProxyByName(tableName, repositoryId);
            EUModule formModule = tools.genTableFormModule(tableName, null, repositoryId);
            EUModule gridLayoutModule = tools.genTableGridModule(tableName, null, repositoryId);
            APIConfig config = APIConfigFactory.getInstance().getAPIConfig("com.ds.fdt.server.service.DAOFromService");
            List methods = config.getMethods();
            for (RequestMethodBean methodBean : methods) {
                methodBean.setUrl(StringUtility.replace((String)methodBean.getUrl(), (String)"{connfigKey}", (String)configKey));
                methodBean.setUrl(StringUtility.replace((String)methodBean.getUrl(), (String)"{className}", (String)proxy.getClassName()));
                APICallerProperties properties = new APICallerProperties(methodBean);
                UIComponentNode apiComponent = new UIComponentNode((Component)new APICallerComponent(methodBean.getName(), properties), true);
                componentNodes.add(apiComponent);
            }
            componentNodes.add(new UIComponentNode((Component)formModule.getComponent(), true));
            componentNodes.add(new UIComponentNode((Component)gridLayoutModule.getComponent(), true));
            result.setData(componentNodes);
        }
        catch (Exception e) {
            e.printStackTrace();
            ErrorResultModel errorResult = new ErrorResultModel();
            errorResult.setErrdes(e.getMessage());
            result = errorResult;
        }
        return result;
    }

    @MethodChinaName(cname="\u83b7\u53d6\u6570\u636e\u5e93\u6811\u5f62\u5b9e\u4f8b\u6570\u636e")
    @RequestMapping(value={"fdt/GetTableTrees"}, method={RequestMethod.POST, RequestMethod.GET})
    @ResponseBody
    public ResultModel<List<UITopNode>> getTableTrees(String text, String url, @PathVariable String projectName) {
        ResultModel result = new ResultModel();
        ArrayList<UITopNode> topNodes = new ArrayList<UITopNode>();
        try {
            ProjectVersion projectVersion = this.getClient().getProjectVersionByName(projectName);
            List configs = projectVersion.getProject().getConfig().getDbConfigs();
            for (DataBaseConfig config : configs) {
                try {
                    if (config.getConfigKey() == null || this.getClient().getDbFactory(config.getConfigKey()) == null) continue;
                    topNodes.add(new UITopNode(config));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            result.setData(topNodes);
        }
        catch (Exception e) {
            ErrorResultModel errorResult = new ErrorResultModel();
            errorResult.setErrdes(e.getMessage());
            result = errorResult;
        }
        return result;
    }

    public ESDClient getClient() throws JDSException {
        ESDClient client = ESDFacrory.getESDClient();
        return client;
    }

    public CtVfsService getVfsClient() {
        CtVfsService vfsClient = CtVfsFactory.getCtVfsService();
        return vfsClient;
    }
}

