/*
 * Decompiled with CFR 0.152.
 */
package com.ds.esd.admin.plugins.service;

import com.alibaba.fastjson.JSON;
import com.ds.cluster.service.SysEventWebManager;
import com.ds.cluster.udp.ClusterEvent;
import com.ds.common.JDSException;
import com.ds.common.query.Condition;
import com.ds.common.query.ConditionKey;
import com.ds.common.query.JoinOperator;
import com.ds.common.query.Operator;
import com.ds.common.util.DateUtility;
import com.ds.config.ErrorListResultModel;
import com.ds.config.ListResultModel;
import com.ds.config.ResultModel;
import com.ds.engine.JDSSessionHandle;
import com.ds.enums.db.MethodChinaName;
import com.ds.esb.config.manager.ServiceBean;
import com.ds.esd.admin.node.XUICommandLog;
import com.ds.esd.admin.node.XUIDataLog;
import com.ds.jds.core.esb.EsbUtil;
import com.ds.msg.CommandMsg;
import com.ds.msg.LogMsg;
import com.ds.msg.MsgClient;
import com.ds.msg.MsgFactroy;
import com.ds.org.query.MsgConditionKey;
import com.ds.server.JDSServer;
import com.ds.web.ConnectionLogFactory;
import com.ds.web.RuntimeLog;
import com.ds.web.util.PageUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@MethodChinaName(cname="\u6d88\u606f\u670d\u52a1")
@RequestMapping(value={"/admin/msg/"})
public class MsgService {
    @MethodChinaName(cname="\u4e0a\u62a5\u6570\u636e\u65e5\u5fd7")
    @RequestMapping(value={"getSensorCMDLogs"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public ListResultModel<List<XUICommandLog>> getSensorCMDLogs(String sensorieee, String starttime, String endtime) {
        ListResultModel userStatusInfo = new ListResultModel();
        try {
            MsgClient client = MsgFactroy.getInstance().getClient(null, CommandMsg.class);
            Condition condition = new Condition((ConditionKey)MsgConditionKey.MSG_ACTIVITYINSTID, Operator.EQUALS, (Object)sensorieee);
            if (starttime != null && !starttime.equals("") && endtime != null && !endtime.equals("")) {
                Condition timeCondition = new Condition((ConditionKey)MsgConditionKey.MSG_SENDTIME, Operator.BETWEEN, (Object)new Date[]{DateUtility.getDate((String)starttime), DateUtility.getDate((String)endtime)});
                condition.addCondition(timeCondition, JoinOperator.JOIN_AND);
            }
            ListResultModel commandMsgs = client.getMsgList(condition);
            userStatusInfo = PageUtil.changPageList((ListResultModel)commandMsgs, XUICommandLog.class);
        }
        catch (JDSException e) {
            userStatusInfo = new ErrorListResultModel();
            ((ErrorListResultModel)userStatusInfo).setErrcode(e.getErrorCode());
            ((ErrorListResultModel)userStatusInfo).setErrdes(e.getMessage());
        }
        return userStatusInfo;
    }

    @MethodChinaName(cname="\u6d4b\u8bd5\u53d1\u9001")
    @RequestMapping(method={RequestMethod.GET, RequestMethod.POST}, value={"testSendEvent"})
    @ResponseBody
    public ResultModel<Boolean> testSendEvent(String sessionId, String msg) {
        Integer k = 0;
        while (k < 1000) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            ClusterEvent clusterEvent = new ClusterEvent();
            clusterEvent.setMsgId(UUID.randomUUID().toString());
            clusterEvent.setEventId("testente");
            clusterEvent.setSourceJson("" + k);
            clusterEvent.setSessionHandle(new JDSSessionHandle(sessionId));
            clusterEvent.setSessionId("d0daca60-d0ab-4d9a-b20b-4069c05c25eb");
            clusterEvent.setSystemCode("mqtt");
            clusterEvent.setEventName("testEventName");
            clusterEvent.setExpression("$RepeatMqttMsg");
            String eventStr = JSON.toJSONString((Object)clusterEvent);
            boolean isSend = JDSServer.getClusterClient().getUDPClient().send(eventStr);
            k = k + 1;
            System.out.println(clusterEvent.getMsgId());
        }
        return new ResultModel();
    }

    @MethodChinaName(cname="\u83b7\u53d6\u6240\u6709\u53ef\u8ba2\u9605\u6d88\u606f")
    @RequestMapping(value={"getAllEventBeans"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public ListResultModel<List<? extends ServiceBean>> getAllEventBeans() {
        ListResultModel userStatusInfo = new ListResultModel();
        SysEventWebManager webManager = (SysEventWebManager)EsbUtil.parExpression(SysEventWebManager.class);
        List serviceBeans = null;
        try {
            serviceBeans = (List)webManager.getRegisterEventByCode("all").get();
        }
        catch (JDSException e) {
            e.printStackTrace();
        }
        userStatusInfo.setData((Object)serviceBeans);
        return userStatusInfo;
    }

    @MethodChinaName(cname="\u547d\u4ee4\u670d\u52a1\u65e5\u5fd7")
    @RequestMapping(value={"getCMDLogs"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public ListResultModel<List<XUICommandLog>> getCMDLogs(String gwieee, String ieee, String starttime, String endtime, String body) {
        ListResultModel userStatusInfo = new ListResultModel();
        try {
            Condition timeCondition;
            Condition condition = new Condition((ConditionKey)MsgConditionKey.MSG_TYPE, Operator.EQUALS, (Object)"MSG");
            MsgClient client = MsgFactroy.getInstance().getClient(null, CommandMsg.class);
            if (body != null && !body.equals("")) {
                Condition gwcondition = new Condition((ConditionKey)MsgConditionKey.MSG_BODY, Operator.LIKE, (Object)("%" + body + "%"));
                condition.addCondition(gwcondition, JoinOperator.JOIN_AND);
            }
            if (endtime != null && !endtime.equals("")) {
                timeCondition = new Condition((ConditionKey)MsgConditionKey.MSG_SENDTIME, Operator.LESS_THAN, (Object)endtime);
                condition.addCondition(timeCondition, JoinOperator.JOIN_AND);
            }
            if (endtime != null && !endtime.equals("")) {
                timeCondition = new Condition((ConditionKey)MsgConditionKey.MSG_SENDTIME, Operator.LESS_THAN, (Object)endtime);
                condition.addCondition(timeCondition, JoinOperator.JOIN_AND);
            }
            if (starttime != null && !starttime.equals("")) {
                timeCondition = new Condition((ConditionKey)MsgConditionKey.MSG_SENDTIME, Operator.GREATER_THAN, (Object)starttime);
                condition.addCondition(timeCondition, JoinOperator.JOIN_AND);
            }
            ListResultModel commandMsgs = client.getMsgList(condition);
            userStatusInfo = PageUtil.changPageList((ListResultModel)commandMsgs, XUICommandLog.class);
        }
        catch (JDSException e) {
            userStatusInfo = new ErrorListResultModel();
            ((ErrorListResultModel)userStatusInfo).setErrcode(e.getErrorCode());
            ((ErrorListResultModel)userStatusInfo).setErrdes(e.getMessage());
        }
        return userStatusInfo;
    }

    @MethodChinaName(cname="\u8fd0\u884c\u65e5\u5fd7")
    @RequestMapping(value={"getRunTimeLogs"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public ListResultModel<List<RuntimeLog>> getRunTimeLogs(String url, String body, String sessionId, Long time) {
        if (time == null) {
            time = 0L;
        }
        if (url == null || url.equals("")) {
            url = "http://";
        }
        ListResultModel userStatusInfo = new ListResultModel();
        List logs = ConnectionLogFactory.getInstance().findLogs(url, body, sessionId, time.longValue());
        userStatusInfo = PageUtil.getDefaultPageList((List)logs);
        return userStatusInfo;
    }

    @RequestMapping(value={"getUDPLogs"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public ListResultModel<List<RuntimeLog>> getUDPLogs(String url, String body, String sessionId, Long time) {
        if (time == null) {
            time = 0L;
        }
        ListResultModel userStatusInfo = new ListResultModel();
        SysEventWebManager manager = (SysEventWebManager)EsbUtil.parExpression(SysEventWebManager.class);
        if (url == null || url.equals("")) {
            url = "udp://";
        } else if (url.endsWith("]")) {
            url = url.substring(0, url.lastIndexOf(":"));
        }
        ListResultModel logs = manager.getRunTimeLogs(url, body, sessionId, time);
        userStatusInfo = PageUtil.changPageList((ListResultModel)logs, RuntimeLog.class);
        return userStatusInfo;
    }

    @RequestMapping(value={"clearUDPServer"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public ResultModel<Boolean> clearUDPServer(String url) {
        ConnectionLogFactory.getInstance().clear(url);
        ResultModel userStatusInfo = new ResultModel();
        return userStatusInfo;
    }

    @RequestMapping(value={"clearLocalLog"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public ResultModel<Boolean> clearLocalLog(String url) {
        ConnectionLogFactory.getInstance().clear(url);
        ResultModel userStatusInfo = new ResultModel();
        return userStatusInfo;
    }

    @MethodChinaName(cname="UPD\u96c6\u7fa4\u5e7f\u64ad")
    @RequestMapping(value={"getLocalUDPLogs"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public ListResultModel<List<RuntimeLog>> getLocalUDPLogs(String url, String body, String sessionId, Long time) {
        if (time == null) {
            time = 0L;
        }
        ListResultModel userStatusInfo = new ListResultModel();
        if (url == null || url.equals("")) {
            url = "udp://";
        } else if (url.endsWith("]")) {
            url = url.substring(0, url.lastIndexOf(":"));
        }
        List logs = ConnectionLogFactory.getInstance().findLogs(url, body, sessionId, time.longValue());
        userStatusInfo = PageUtil.getDefaultPageList((List)logs, RuntimeLog.class);
        return userStatusInfo;
    }

    @RequestMapping(value={"clear"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public ResultModel<Boolean> clear(String url) {
        ConnectionLogFactory.getInstance().clear(url);
        ResultModel userStatusInfo = new ResultModel();
        return userStatusInfo;
    }

    @MethodChinaName(cname="\u83b7\u53d6\u6570\u636e\u65e5\u5fd7")
    @RequestMapping(value={"getDataLogs"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public ListResultModel<List<XUIDataLog>> getDataLogs(String gwieee, String ieee, String starttime, String endtime, String body) {
        ListResultModel userStatusInfo = new ListResultModel();
        Condition condition = new Condition((ConditionKey)MsgConditionKey.MSG_TYPE, Operator.EQUALS, (Object)"LOG");
        try {
            Condition timeCondition;
            Condition gwcondition;
            ArrayList modules = new ArrayList();
            MsgClient client = MsgFactroy.getInstance().getClient(null, LogMsg.class);
            if (gwieee != null && !gwieee.equals("")) {
                gwcondition = new Condition((ConditionKey)MsgConditionKey.MSG_PROCESSINSTID, Operator.EQUALS, (Object)gwieee);
                condition.addCondition(gwcondition, JoinOperator.JOIN_AND);
            }
            if (ieee != null && !ieee.equals("")) {
                gwcondition = new Condition((ConditionKey)MsgConditionKey.MSG_ACTIVITYINSTID, Operator.EQUALS, (Object)ieee);
                condition.addCondition(gwcondition, JoinOperator.JOIN_AND);
            }
            if (body != null && !body.equals("")) {
                gwcondition = new Condition((ConditionKey)MsgConditionKey.MSG_BODY, Operator.LIKE, (Object)("%" + body + "%"));
                condition.addCondition(gwcondition, JoinOperator.JOIN_AND);
            }
            if (endtime != null && !endtime.equals("")) {
                timeCondition = new Condition((ConditionKey)MsgConditionKey.MSG_SENDTIME, Operator.LESS_THAN, (Object)endtime);
                condition.addCondition(timeCondition, JoinOperator.JOIN_AND);
            }
            if (starttime != null && !starttime.equals("")) {
                timeCondition = new Condition((ConditionKey)MsgConditionKey.MSG_SENDTIME, Operator.GREATER_THAN, (Object)starttime);
                condition.addCondition(timeCondition, JoinOperator.JOIN_AND);
            }
            ListResultModel commandMsgs = client.getMsgList(condition);
            userStatusInfo = PageUtil.changPageList((ListResultModel)commandMsgs, XUIDataLog.class);
        }
        catch (JDSException e) {
            userStatusInfo = new ErrorListResultModel();
            ((ErrorListResultModel)userStatusInfo).setErrcode(e.getErrorCode());
            ((ErrorListResultModel)userStatusInfo).setErrdes(e.getMessage());
        }
        return userStatusInfo;
    }
}

