/*
 * Decompiled with CFR 0.152.
 */
package com.ds.esd.admin.plugins.service;

import com.ds.common.JDSException;
import com.ds.common.util.StringUtility;
import com.ds.config.ErrorListResultModel;
import com.ds.config.ErrorResultModel;
import com.ds.config.ListResultModel;
import com.ds.config.ResultModel;
import com.ds.enums.db.MethodChinaName;
import com.ds.esd.client.ESDClient;
import com.ds.esd.client.ESDFacrory;
import com.ds.esd.client.Project;
import com.ds.esd.client.ProjectVersion;
import com.ds.esd.plugins.img.ImgFactory;
import com.ds.esd.plugins.img.node.ImgConfig;
import com.ds.esd.plugins.img.node.ImgNode;
import com.ds.esd.project.config.ProjectConfig;
import com.ds.esd.project.enums.ProjectResourceType;
import com.ds.esd.workspace.MySpace;
import com.ds.vfs.Folder;
import com.ds.vfs.ct.CtVfsFactory;
import java.util.ArrayList;
import java.util.List;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/admin/plugs/img/"})
@MethodChinaName(cname="\u56fe\u7247\u670d\u52a1")
public class ImgService {
    @MethodChinaName(cname="\u56fe\u7247\u7c7b\u914d\u7f6e")
    @RequestMapping(value={"getSelImg"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public ListResultModel<List<ImgConfig>> getSelImg(@PathVariable String projectName) {
        ListResultModel result = new ListResultModel();
        List imgConfigs = new ArrayList();
        try {
            ProjectVersion projectVersion = this.getClient().getProjectVersionByName(projectName);
            imgConfigs = projectVersion.getProject().getImgs();
            result.setData(imgConfigs);
        }
        catch (JDSException e) {
            e.printStackTrace();
            ErrorListResultModel errorResult = new ErrorListResultModel();
            errorResult.setErrdes(e.getMessage());
            result = errorResult;
        }
        return result;
    }

    @MethodChinaName(cname="\u6dfb\u52a0\u56fe\u7247")
    @RequestMapping(value={"addImg"}, method={RequestMethod.POST})
    @ResponseBody
    public ResultModel<Boolean> addImg(String projectName, String id) {
        ResultModel result = new ResultModel();
        try {
            ProjectVersion version = this.getClient().getProjectVersionByName(projectName);
            String[] ids = StringUtility.split((String)id, (String)";");
            ProjectConfig config = version.getProject().getConfig();
            List imgIds = config.getImgs();
            for (String imgId : ids) {
                if (imgIds.contains(imgId)) continue;
                ImgConfig imgConfig = ImgFactory.getInstance((MySpace)this.getClient().getSpace()).getImgConfigById(imgId);
                Folder folder = CtVfsFactory.getCtVfsService().getFolderById(imgId);
                if (folder == null) continue;
                Folder imgFolder = (Folder)this.getClient().copy(projectName, folder.getPath(), "img/" + folder.getName());
                imgIds.add(imgFolder.getID());
            }
            config.setImgs(imgIds);
            version.updateConfig(config);
        }
        catch (JDSException e) {
            result = new ErrorResultModel();
            ((ErrorResultModel)result).setErrcode(100);
            ((ErrorResultModel)result).setErrdes(e.getMessage());
        }
        return result;
    }

    @MethodChinaName(cname="\u56fe\u7247\u5b9a\u4e49")
    @RequestMapping(value={"getImgTreeProject"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public ListResultModel<List<ImgNode>> getImgTreeProject() {
        ListResultModel result = new ListResultModel();
        ArrayList<ImgNode> fontNodes = new ArrayList<ImgNode>();
        try {
            List projects = this.getClient().getResourceAllProject(ProjectResourceType.img);
            for (Project project : projects) {
                fontNodes.add(new ImgNode(project));
            }
            result.setData(fontNodes);
        }
        catch (JDSException e) {
            e.printStackTrace();
        }
        return result;
    }

    @MethodChinaName(cname="\u5b57\u4f53\u7c7b\u914d\u7f6e")
    @RequestMapping(value={"delImg"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public ResultModel<Boolean> delFont(String projectName, String id) {
        ResultModel result = new ResultModel();
        List fontConfigIds = new ArrayList();
        try {
            Project project = this.getClient().getProjectByName(projectName);
            fontConfigIds = project.getConfig().getImgs();
            fontConfigIds.remove(id);
            this.getClient().updateProjectConfig(project.getId(), project.getConfig());
        }
        catch (JDSException e) {
            e.printStackTrace();
            ErrorResultModel errorResult = new ErrorResultModel();
            errorResult.setErrdes(e.getMessage());
            errorResult.setErrcode(e.getErrorCode());
            result = errorResult;
        }
        return result;
    }

    @MethodChinaName(cname="\u5b57\u4f53\u7c7b\u914d\u7f6e")
    @RequestMapping(value={"getProjectImgs"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public ListResultModel<List<ImgConfig>> getProjectImgs(String projectName) {
        ListResultModel result = new ListResultModel();
        try {
            Project project = this.getClient().getProjectByName(projectName);
            List fontConfigs = project.getImgs();
            result.setData((Object)fontConfigs);
        }
        catch (JDSException e) {
            e.printStackTrace();
        }
        return result;
    }

    public ESDClient getClient() throws JDSException {
        ESDClient client = ESDFacrory.getESDClient();
        return client;
    }
}

