/*
 * Decompiled with CFR 0.152.
 */
package com.ds.esd.admin.plugins.service;

import com.ds.common.JDSException;
import com.ds.common.util.StringUtility;
import com.ds.config.ErrorListResultModel;
import com.ds.config.ErrorResultModel;
import com.ds.config.ListResultModel;
import com.ds.config.ResultModel;
import com.ds.enums.db.MethodChinaName;
import com.ds.esd.client.ESDClient;
import com.ds.esd.client.ESDFacrory;
import com.ds.esd.client.Project;
import com.ds.esd.client.ProjectVersion;
import com.ds.esd.plugins.font.node.FontConfig;
import com.ds.esd.plugins.font.node.FontNode;
import com.ds.esd.project.config.ProjectConfig;
import com.ds.esd.project.enums.ProjectResourceType;
import java.util.ArrayList;
import java.util.List;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/admin/plugs/font/"})
@MethodChinaName(cname="\u56fe\u6807\u5b57\u4f53\u670d\u52a1")
public class FontService {
    @MethodChinaName(cname="\u5b57\u4f53\u7c7b\u914d\u7f6e")
    @RequestMapping(value={"getSelFont"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public ListResultModel<List<FontConfig>> getSelFont(@PathVariable String projectName) {
        ListResultModel result = new ListResultModel();
        List fontConfigs = new ArrayList();
        try {
            ProjectVersion projectVersion = this.getClient().getProjectVersionByName(projectName);
            fontConfigs = projectVersion.getProject().getFonts();
            result.setData(fontConfigs);
        }
        catch (JDSException e) {
            e.printStackTrace();
            ErrorListResultModel errorResult = new ErrorListResultModel();
            errorResult.setErrdes(e.getMessage());
            result = errorResult;
        }
        return result;
    }

    @MethodChinaName(cname="\u6dfb\u52a0\u5b57\u4f53\u5b9a\u4e49")
    @RequestMapping(value={"addFont"}, method={RequestMethod.POST})
    @ResponseBody
    public ResultModel<Boolean> addFont(String projectName, String id) {
        ResultModel result = new ResultModel();
        try {
            ProjectVersion version = this.getClient().getProjectVersionByName(projectName);
            String[] ids = StringUtility.split((String)id, (String)";");
            ProjectConfig config = version.getProject().getConfig();
            List fontIds = config.getFonts();
            for (String apiId : ids) {
                if (fontIds.contains(apiId)) continue;
                fontIds.add(apiId);
            }
            config.setFonts(fontIds);
            version.updateConfig(config);
        }
        catch (JDSException e) {
            result = new ErrorResultModel();
            ((ErrorResultModel)result).setErrcode(100);
            ((ErrorResultModel)result).setErrdes(e.getMessage());
        }
        return result;
    }

    @MethodChinaName(cname="\u83b7\u53d6\u5b57\u4f53\u6587\u4ef6\u5b9a\u4e49")
    @RequestMapping(value={"getFontTreeProject"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public ListResultModel<List<FontNode>> getFontTreeProject() {
        ListResultModel result = new ListResultModel();
        ArrayList<FontNode> fontNodes = new ArrayList<FontNode>();
        try {
            List projects = this.getClient().getResourceAllProject(ProjectResourceType.font);
            for (Project project : projects) {
                fontNodes.add(new FontNode(project));
            }
            result.setData(fontNodes);
        }
        catch (JDSException e) {
            e.printStackTrace();
        }
        return result;
    }

    @MethodChinaName(cname="\u5b57\u4f53\u7c7b\u914d\u7f6e")
    @RequestMapping(value={"delFont"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public ResultModel<Boolean> delFont(String projectName, String id) {
        ResultModel result = new ResultModel();
        List fontConfigIds = new ArrayList();
        try {
            Project project = this.getClient().getProjectByName(projectName);
            fontConfigIds = project.getConfig().getFonts();
            fontConfigIds.remove(id);
            this.getClient().updateProjectConfig(project.getId(), project.getConfig());
        }
        catch (JDSException e) {
            e.printStackTrace();
            ErrorResultModel errorResult = new ErrorResultModel();
            errorResult.setErrdes(e.getMessage());
            errorResult.setErrcode(e.getErrorCode());
            result = errorResult;
        }
        return result;
    }

    @MethodChinaName(cname="\u5b57\u4f53\u7c7b\u914d\u7f6e")
    @RequestMapping(value={"getProjectFonts"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public ListResultModel<List<FontConfig>> getProjectFonts(String projectName) {
        ListResultModel result = new ListResultModel();
        try {
            Project project = this.getClient().getProjectByName(projectName);
            List fontConfigs = project.getFonts();
            result.setData((Object)fontConfigs);
        }
        catch (JDSException e) {
            e.printStackTrace();
        }
        return result;
    }

    public ESDClient getClient() throws JDSException {
        ESDClient client = ESDFacrory.getESDClient();
        return client;
    }
}

