/*
 * Decompiled with CFR 0.152.
 */
package com.ds.esd.admin.plugins.service;

import com.ds.common.JDSException;
import com.ds.config.ErrorListResultModel;
import com.ds.config.ErrorResultModel;
import com.ds.config.ListResultModel;
import com.ds.config.ResultModel;
import com.ds.engine.ConnectInfo;
import com.ds.enums.db.MethodChinaName;
import com.ds.esd.client.ESDClient;
import com.ds.esd.client.ESDFacrory;
import com.ds.esd.client.Project;
import com.ds.esd.client.ProjectVersion;
import com.ds.esd.esdserver.ESDServerUtil;
import com.ds.esd.project.config.DevUserConfig;
import com.ds.esd.project.config.LocalServer;
import com.ds.esd.project.config.RemoteServer;
import com.ds.server.ServerProjectConfig;
import com.ds.server.eumus.SystemStatus;
import com.ds.server.httpproxy.ServerProxyFactory;
import com.ds.server.httpproxy.core.ProxyHost;
import com.ds.server.httpproxy.core.UUID;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.sf.cglib.beans.BeanMap;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/admin/proxyhost/"})
@MethodChinaName(cname="\u4ee3\u7406\u670d\u52a1\u914d\u7f6e")
public class DeployHostService {
    @MethodChinaName(cname="\u83b7\u53d6\u90e8\u7f72\u914d\u7f6e\u6587\u4ef6")
    @RequestMapping(value={"getServerProjectConfig"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public ResultModel<ServerProjectConfig> getServerProjectConfig(String projectName) {
        ResultModel result = new ResultModel();
        try {
            ProjectVersion version = ESDFacrory.getESDClient().getProjectVersionByName(projectName);
            ServerProjectConfig config = new ServerProjectConfig();
            config.setHost(version.getProject().getConfig().getPublicServerUrl());
            config.setProjectName(version.getProject().getProjectName());
            config.setVersionName(version.getVersionName());
            config.setIndexPage("App.index");
            ConnectInfo connectInfo = ESDFacrory.getESDClient().getConnectInfo();
            config.setUserId(connectInfo.getUserID());
            config.setUserName(connectInfo.getLoginName());
        }
        catch (JDSException e) {
            e.printStackTrace();
            ErrorResultModel errorResult = new ErrorResultModel();
            errorResult.setErrdes(e.getMessage());
            result = errorResult;
        }
        return result;
    }

    @MethodChinaName(cname="\u83b7\u53d6\u672c\u5730\u7528\u6237\u4ee3\u7406")
    @RequestMapping(value={"getProxyHosts"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public ListResultModel<List<ProxyHost>> getProxyHosts() {
        ListResultModel result = new ListResultModel();
        List hosts = new ArrayList();
        try {
            DevUserConfig userConfig = this.getClient().getUserConfig();
            hosts = userConfig.getHosts();
            result.setData(hosts);
        }
        catch (JDSException e) {
            e.printStackTrace();
            ErrorListResultModel errorResult = new ErrorListResultModel();
            errorResult.setErrdes(e.getMessage());
            result = errorResult;
        }
        return result;
    }

    @MethodChinaName(cname="\u6e05\u7a7a\u914d\u7f6e")
    @RequestMapping(value={"clearHosts"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public ResultModel<Boolean> clearHosts() {
        ResultModel result = new ResultModel();
        ArrayList imgConfigs = new ArrayList();
        try {
            DevUserConfig userConfig = this.getClient().getUserConfig();
            ServerProxyFactory.getInstance().clear();
            userConfig.setHosts(new ArrayList());
            this.getClient().updateUserConfig(userConfig);
            result.setData((Object)true);
        }
        catch (JDSException e) {
            e.printStackTrace();
            ErrorResultModel errorResult = new ErrorResultModel();
            errorResult.setErrdes(e.getMessage());
            result = errorResult;
        }
        return result;
    }

    @MethodChinaName(cname="\u66f4\u65b0\u4ee3\u7406\u670d\u52a1")
    @RequestMapping(value={"updateProxyHosts"}, method={RequestMethod.POST})
    @ResponseBody
    public ResultModel<ProxyHost> updateProxyHosts(@RequestBody ProxyHost host) {
        ResultModel result = new ResultModel();
        try {
            DevUserConfig userConfig = this.getClient().getUserConfig();
            String proxyId = host.getProxyId();
            if (proxyId == null || proxyId.equals("")) {
                proxyId = UUID.createUUID().toString();
                host.setProxyId(proxyId);
                userConfig.getHosts().add(host);
            } else {
                ProxyHost proxyHost = userConfig.getProxyHostById(proxyId);
                ProxyHost runtimeHost = (ProxyHost)ServerProxyFactory.serverProxyMap.get(proxyHost.getHost());
                if (runtimeHost != null) {
                    runtimeHost.setProxyUrl(proxyHost.getProxyUrl());
                }
                if (proxyHost != null) {
                    proxyHost.fill(host);
                } else {
                    userConfig.getHosts().add(host);
                }
            }
            this.getClient().updateUserConfig(userConfig);
        }
        catch (JDSException e) {
            e.printStackTrace();
            ErrorResultModel errorResult = new ErrorResultModel();
            errorResult.setErrdes(e.getMessage());
            result = errorResult;
        }
        return result;
    }

    @MethodChinaName(cname="\u83b7\u53d6\u672c\u5730\u670d\u52a1\u5668\u914d\u7f6e")
    @RequestMapping(value={"getServerList"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public ListResultModel<List<LocalServer>> getServerList() {
        ListResultModel result = new ListResultModel();
        List hosts = new ArrayList();
        try {
            DevUserConfig userConfig = this.getClient().getUserConfig();
            hosts = userConfig.getServers();
            result.setData(hosts);
        }
        catch (JDSException e) {
            e.printStackTrace();
            ErrorListResultModel errorResult = new ErrorListResultModel();
            errorResult.setErrdes(e.getMessage());
            result = errorResult;
        }
        return result;
    }

    @MethodChinaName(cname="\u5220\u9664\u8fdc\u7a0b\u670d\u52a1\u5668\u914d\u7f6e")
    @RequestMapping(value={"deleteHost"}, method={RequestMethod.POST})
    @ResponseBody
    public ResultModel<Boolean> deleteHost(String proxyId) {
        ResultModel result = new ResultModel();
        try {
            DevUserConfig userConfig = this.getClient().getUserConfig();
            if (proxyId != null) {
                ProxyHost runtimeHost;
                ProxyHost proxyHost = userConfig.getProxyHostById(proxyId);
                if (proxyHost != null) {
                    userConfig.getHosts().remove(proxyHost);
                }
                if ((runtimeHost = (ProxyHost)ServerProxyFactory.serverProxyMap.get(proxyHost.getHost())) != null) {
                    runtimeHost.setProxyUrl(null);
                }
            }
            this.getClient().updateUserConfig(userConfig);
        }
        catch (JDSException e) {
            e.printStackTrace();
            ErrorResultModel errorResult = new ErrorResultModel();
            errorResult.setErrdes(e.getMessage());
            result = errorResult;
        }
        return result;
    }

    @MethodChinaName(cname="\u5220\u9664\u8fdc\u7a0b\u670d\u52a1\u5668\u914d\u7f6e")
    @RequestMapping(value={"deleteRemoteServer"}, method={RequestMethod.POST})
    @ResponseBody
    public ResultModel<Boolean> deleteRemoteServer(String serverId) {
        ResultModel result = new ResultModel();
        try {
            RemoteServer proxyHost;
            DevUserConfig userConfig = this.getClient().getUserConfig();
            if (serverId != null && (proxyHost = userConfig.getRemoteServerById(serverId)) != null) {
                userConfig.getRemoteServers().remove(proxyHost);
            }
            this.getClient().updateUserConfig(userConfig);
        }
        catch (JDSException e) {
            e.printStackTrace();
            ErrorResultModel errorResult = new ErrorResultModel();
            errorResult.setErrdes(e.getMessage());
            result = errorResult;
        }
        return result;
    }

    @MethodChinaName(cname="\u5220\u9664\u672c\u5730\u670d\u52a1\u5668\u914d\u7f6e")
    @RequestMapping(value={"deleteLocalServer"}, method={RequestMethod.POST})
    @ResponseBody
    public ResultModel<Boolean> deleteLocalServer(String serverId) {
        ResultModel result = new ResultModel();
        try {
            LocalServer proxyHost;
            DevUserConfig userConfig = this.getClient().getUserConfig();
            if (serverId != null && (proxyHost = userConfig.getServerById(serverId)) != null) {
                userConfig.getServers().remove(proxyHost);
            }
            this.getClient().updateUserConfig(userConfig);
        }
        catch (JDSException e) {
            e.printStackTrace();
            ErrorResultModel errorResult = new ErrorResultModel();
            errorResult.setErrdes(e.getMessage());
            result = errorResult;
        }
        return result;
    }

    @MethodChinaName(cname="\u66f4\u65b0\u672c\u5730\u670d\u52a1\u5668\u914d\u7f6e")
    @RequestMapping(value={"updateLocalServer"}, method={RequestMethod.POST})
    @ResponseBody
    public ResultModel<LocalServer> updateLocalServer(@RequestBody LocalServer server) {
        ResultModel result = new ResultModel();
        try {
            DevUserConfig userConfig = this.getClient().getUserConfig();
            String serverId = server.getServerId();
            if (serverId == null || serverId.equals("")) {
                serverId = UUID.createUUID().toString();
                server.setServerId(serverId);
                userConfig.getServers().add(server);
            } else {
                LocalServer proxyHost = userConfig.getServerById(serverId);
                if (proxyHost != null) {
                    BeanMap.create((Object)proxyHost).putAll((Map)BeanMap.create((Object)server));
                } else {
                    userConfig.getServers().add(server);
                }
            }
            this.getClient().updateUserConfig(userConfig);
        }
        catch (JDSException e) {
            e.printStackTrace();
            ErrorResultModel errorResult = new ErrorResultModel();
            errorResult.setErrdes(e.getMessage());
            result = errorResult;
        }
        return result;
    }

    @MethodChinaName(cname="\u6e05\u7a7a\u672c\u5730\u670d\u52a1\u5668\u914d\u7f6e")
    @RequestMapping(value={"clearServers"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public ResultModel<Boolean> clearServers() {
        ResultModel result = new ResultModel();
        ArrayList imgConfigs = new ArrayList();
        try {
            DevUserConfig userConfig = this.getClient().getUserConfig();
            userConfig.setServers(new ArrayList());
            this.getClient().updateUserConfig(userConfig);
            result.setData((Object)true);
        }
        catch (JDSException e) {
            e.printStackTrace();
            ErrorResultModel errorResult = new ErrorResultModel();
            errorResult.setErrdes(e.getMessage());
            result = errorResult;
        }
        return result;
    }

    @MethodChinaName(cname="\u542f\u52a8\u672c\u5730\u670d\u52a1\u5668")
    @RequestMapping(value={"startLocalServer"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public ResultModel<Boolean> startLocalServer(String serverId, String projectName) {
        ResultModel result = new ResultModel();
        ArrayList imgConfigs = new ArrayList();
        try {
            Project project = ESDFacrory.getESDClient().getProjectByName(projectName);
            DevUserConfig userConfig = this.getClient().getUserConfig();
            LocalServer server = userConfig.getServerById(serverId);
            if (server != null) {
                ESDServerUtil.startESDServer((Project)project, (LocalServer)server);
                server.setStatus(SystemStatus.ONLINE);
            }
            result.setData((Object)true);
        }
        catch (JDSException e) {
            e.printStackTrace();
            ErrorResultModel errorResult = new ErrorResultModel();
            errorResult.setErrdes(e.getMessage());
            result = errorResult;
        }
        return result;
    }

    @MethodChinaName(cname="\u5173\u95ed\u670d\u52a1\u5668")
    @RequestMapping(value={"stopLocalServer"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public ResultModel<Boolean> stopLocalServer(String serverId) {
        ResultModel result = new ResultModel();
        ArrayList imgConfigs = new ArrayList();
        try {
            DevUserConfig userConfig = this.getClient().getUserConfig();
            LocalServer server = userConfig.getServerById(serverId);
            if (server != null) {
                ESDServerUtil.stopESDServer((LocalServer)server);
                server.setStatus(SystemStatus.OFFLINE);
            }
            result.setData((Object)true);
        }
        catch (JDSException e) {
            e.printStackTrace();
            ErrorResultModel errorResult = new ErrorResultModel();
            errorResult.setErrdes(e.getMessage());
            result = errorResult;
        }
        return result;
    }

    @MethodChinaName(cname="\u83b7\u53d6\u8fdc\u7a0b\u670d\u52a1\u5668\u914d\u7f6e")
    @RequestMapping(value={"getRemoteServerList"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public ListResultModel<List<RemoteServer>> getRemoteServerList() {
        ListResultModel result = new ListResultModel();
        List hosts = new ArrayList();
        try {
            DevUserConfig userConfig = this.getClient().getUserConfig();
            hosts = userConfig.getRemoteServers();
            result.setData(hosts);
        }
        catch (JDSException e) {
            e.printStackTrace();
            ErrorListResultModel errorResult = new ErrorListResultModel();
            errorResult.setErrdes(e.getMessage());
            result = errorResult;
        }
        return result;
    }

    @MethodChinaName(cname="\u66f4\u65b0\u8fdc\u7a0b\u670d\u52a1\u5668\u914d\u7f6e")
    @RequestMapping(value={"updateRemoteServer"}, method={RequestMethod.POST})
    @ResponseBody
    public ResultModel<RemoteServer> updateRemoteServer(@RequestBody RemoteServer server) {
        ResultModel result = new ResultModel();
        try {
            DevUserConfig userConfig = this.getClient().getUserConfig();
            String serverId = server.getServerId();
            if (serverId == null || serverId.equals("")) {
                serverId = UUID.createUUID().toString();
                server.setServerId(serverId);
                userConfig.getRemoteServers().add(server);
            } else {
                RemoteServer proxyHost = userConfig.getRemoteServerById(serverId);
                if (proxyHost != null) {
                    BeanMap.create((Object)proxyHost).putAll((Map)BeanMap.create((Object)server));
                } else {
                    userConfig.getRemoteServers().add(server);
                }
            }
            this.getClient().updateUserConfig(userConfig);
        }
        catch (JDSException e) {
            e.printStackTrace();
            ErrorResultModel errorResult = new ErrorResultModel();
            errorResult.setErrdes(e.getMessage());
            result = errorResult;
        }
        return result;
    }

    @MethodChinaName(cname="\u6e05\u7a7a\u8fdc\u7a0b\u670d\u52a1\u5668\u914d\u7f6e")
    @RequestMapping(value={"clearRemoteServers"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public ResultModel<Boolean> clearRemoteServers() {
        ResultModel result = new ResultModel();
        try {
            DevUserConfig userConfig = this.getClient().getUserConfig();
            userConfig.setRemoteServers(new ArrayList());
            this.getClient().updateUserConfig(userConfig);
            result.setData((Object)true);
        }
        catch (JDSException e) {
            e.printStackTrace();
            ErrorResultModel errorResult = new ErrorResultModel();
            errorResult.setErrdes(e.getMessage());
            result = errorResult;
        }
        return result;
    }

    public ESDClient getClient() throws JDSException {
        ESDClient client = ESDFacrory.getESDClient();
        return client;
    }
}

