/*
 * Decompiled with CFR 0.152.
 */
package com.ds.esd.admin.plugins.service;

import com.ds.common.JDSException;
import com.ds.common.database.ProfiledConnectionEntry;
import com.ds.common.database.metadata.ColInfo;
import com.ds.common.database.metadata.MetadataFactory;
import com.ds.common.database.metadata.SqlExcuteInfo;
import com.ds.common.database.metadata.SqlType;
import com.ds.common.database.metadata.TableInfo;
import com.ds.common.util.StringUtility;
import com.ds.config.ErrorListResultModel;
import com.ds.config.ErrorResultModel;
import com.ds.config.ListResultModel;
import com.ds.config.ResultModel;
import com.ds.enums.db.MethodChinaName;
import com.ds.esd.admin.plugins.fdt.node.UIColNode;
import com.ds.esd.admin.plugins.fdt.node.UITableNode;
import com.ds.esd.admin.plugins.fdt.node.UITopNode;
import com.ds.esd.admin.plugins.service.TableService;
import com.ds.esd.client.ESDClient;
import com.ds.esd.client.ESDFacrory;
import com.ds.esd.client.ProjectVersion;
import com.ds.esd.project.config.DataBaseConfig;
import com.ds.web.util.PageUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/admin/fdt/magager/"})
@MethodChinaName(cname="\u6570\u636e\u5e93\u8868\u64cd\u4f5c")
public class DBManagerService
implements TableService {
    @Override
    @MethodChinaName(cname="\u5220\u9664\u6570\u636e\u5e93\u8868")
    @RequestMapping(method={RequestMethod.POST}, value={"DropTable"})
    @ResponseBody
    public ResultModel<Boolean> dropTable(String name, String configKey) {
        ResultModel result = new ResultModel();
        try {
            String[] tableNameArr = StringUtility.split((String)name, (String)";");
            MetadataFactory factory = this.getClient().getDbFactory(configKey);
            factory.dropTable(Arrays.asList(tableNameArr));
        }
        catch (Exception e) {
            e.printStackTrace();
            ErrorResultModel errorResult = new ErrorResultModel();
            errorResult.setErrdes(e.getMessage());
            result = errorResult;
        }
        return result;
    }

    @Override
    @MethodChinaName(cname="\u7f16\u8f91\u5e93\u8868\u4fe1\u606f")
    @RequestMapping(method={RequestMethod.POST}, value={"EditTable"})
    @ResponseBody
    public ResultModel<Boolean> editTable(@RequestBody TableInfo tableInfo) {
        ResultModel result = new ResultModel();
        try {
            ArrayList<TableInfo> tableList = new ArrayList<TableInfo>();
            tableList.add(tableInfo);
            String configKey = tableInfo.getConfigKey();
            if (configKey == null || configKey.equals("")) {
                configKey = tableInfo.getUrl();
            }
            MetadataFactory factory = this.getClient().getDbFactory(tableInfo.getConfigKey());
            factory.modifyTableCnname(tableList);
        }
        catch (Exception e) {
            e.printStackTrace();
            ErrorResultModel errorResult = new ErrorResultModel();
            errorResult.setErrdes(e.getMessage());
            result = errorResult;
        }
        return result;
    }

    @Override
    @MethodChinaName(cname="\u6dfb\u52a0\u6570\u636e\u5e93\u8868")
    @RequestMapping(method={RequestMethod.POST}, value={"AddTable"})
    @ResponseBody
    public ResultModel<Boolean> addTable(@RequestBody TableInfo tableInfo) {
        ResultModel result = new ResultModel();
        try {
            String configKey = tableInfo.getConfigKey();
            if (configKey == null || configKey.equals("")) {
                configKey = tableInfo.getUrl();
            }
            MetadataFactory factory = this.getClient().getDbFactory(configKey);
            factory.createTableByInfo(tableInfo);
        }
        catch (Exception e) {
            ErrorResultModel errorResult = new ErrorResultModel();
            errorResult.setErrdes(e.getMessage());
            result = errorResult;
        }
        return result;
    }

    @Override
    @MethodChinaName(cname="\u6dfb\u52a0\u5217")
    @RequestMapping(method={RequestMethod.POST}, value={"AddCol"})
    @ResponseBody
    public ResultModel<Boolean> addCol(@RequestBody ColInfo col) {
        ResultModel result = new ResultModel();
        try {
            ArrayList<ColInfo> cols = new ArrayList<ColInfo>();
            cols.add(col);
            String configKey = col.getConfigKey();
            if (configKey == null || configKey.equals("")) {
                configKey = col.getUrl();
            }
            MetadataFactory factory = this.getClient().getDbFactory(configKey);
            factory.modifyTableCols(col.getTablename(), cols);
        }
        catch (Exception e) {
            ErrorResultModel errorResult = new ErrorResultModel();
            errorResult.setErrdes(e.getMessage());
            result = errorResult;
        }
        return result;
    }

    @Override
    @MethodChinaName(cname="\u83b7\u53d6\u6240\u6709\u5217")
    @RequestMapping(method={RequestMethod.POST}, value={"GetAllCollByTableName"})
    @ResponseBody
    public ListResultModel<List<ColInfo>> getAllCollByTableName(String tablename, String configKey) {
        ListResultModel result = new ListResultModel();
        try {
            MetadataFactory factory = this.getClient().getDbFactory(configKey);
            List cols = factory.getTableInfo(tablename).getColList();
            result = PageUtil.getDefaultPageList((List)cols);
        }
        catch (Exception e) {
            ErrorListResultModel errorResult = new ErrorListResultModel();
            errorResult.setErrdes(e.getMessage());
            result = errorResult;
        }
        return result;
    }

    @Override
    @MethodChinaName(cname="\u83b7\u53d6\u6240\u6709\u6570\u636e\u5e93\u8868")
    @RequestMapping(method={RequestMethod.POST}, value={"GetAllTableByName"})
    @ResponseBody
    public ListResultModel<List<TableInfo>> getAllTableByName(String simpleName, String configKey) {
        ListResultModel result = new ListResultModel();
        List tables = null;
        try {
            MetadataFactory factory = this.getClient().getDbFactory(configKey);
            tables = factory.getTableInfos(simpleName);
            result = PageUtil.getDefaultPageList((List)tables);
        }
        catch (Exception e) {
            ErrorListResultModel errorResult = new ErrorListResultModel();
            errorResult.setErrdes(e.getMessage());
            result = errorResult;
        }
        return result;
    }

    @Override
    @MethodChinaName(cname="\u83b7\u53d6\u6240\u6709\u6570\u636e\u5e93\u8868")
    @RequestMapping(method={RequestMethod.POST}, value={"getProjectTables"})
    @ResponseBody
    public ListResultModel<List<TableInfo>> getProjectTables(String configName, @PathVariable String projectName) {
        ListResultModel result = new ListResultModel();
        try {
            ProjectVersion version = this.getClient().getProjectVersionByName(projectName);
            DataBaseConfig dataBaseConfig = version.getProject().getConfig().getDataBaseConfigBykey(configName);
            if (dataBaseConfig == null) {
                throw new JDSException(" \u6570\u636e\u5e93\u914d\u7f6e\u9519\u8bef");
            }
            List tableNames = dataBaseConfig.getTableName();
            MetadataFactory factory = this.getClient().getDbFactory(configName);
            ArrayList<TableInfo> projecttables = new ArrayList<TableInfo>();
            List tables = factory.getTableInfos(null);
            for (TableInfo table : tables) {
                if (tableNames != null && !tableNames.contains(table.getName())) continue;
                projecttables.add(table);
            }
            result = PageUtil.getDefaultPageList(projecttables);
        }
        catch (Exception e) {
            ErrorListResultModel errorResult = new ErrorListResultModel();
            errorResult.setErrdes(e.getMessage());
            result = errorResult;
        }
        return result;
    }

    @Override
    @MethodChinaName(cname="\u83b7\u53d6\u6570\u636e\u5e93\u5206\u7c7b\u8282\u70b9")
    @RequestMapping(value={"GetDbTrees"}, method={RequestMethod.POST, RequestMethod.GET})
    @ResponseBody
    public ListResultModel<List<UITopNode>> GetDbTrees(String projectName) {
        ListResultModel result = new ListResultModel();
        ArrayList<UITopNode> tableNodes = new ArrayList<UITopNode>();
        try {
            String[] nameStrs;
            for (String text : nameStrs = new String[]{"BPM", "FDT", "RO", "VFS", "HA", "ADMIN", "RT", "TDA"}) {
                UITopNode simpNode = new UITopNode(text + "_", text, projectName, "console");
                tableNodes.add(simpNode);
            }
            result.setData(tableNodes);
        }
        catch (Exception e) {
            ErrorListResultModel errorResult = new ErrorListResultModel();
            errorResult.setErrdes(e.getMessage());
            result = errorResult;
        }
        return result;
    }

    @Override
    @MethodChinaName(cname="\u83b7\u53d6\u6570\u636e\u5e93\u6811\u5f62\u5b9e\u4f8b\u6570\u636e")
    @RequestMapping(value={"GetTableTrees"}, method={RequestMethod.POST, RequestMethod.GET})
    @ResponseBody
    public ListResultModel<List<UITableNode>> getTableTrees(String text, String configKey, @PathVariable String projectName) {
        ListResultModel result = new ListResultModel();
        ArrayList<UITableNode> tableNodes = new ArrayList<UITableNode>();
        try {
            ProjectVersion version = this.getClient().getProjectVersionByName(projectName);
            DataBaseConfig dataBaseConfig = version.getProject().getConfig().getDataBaseConfigBykey(configKey);
            if (dataBaseConfig == null) {
                throw new JDSException(" \u6570\u636e\u5e93\u914d\u7f6e\u9519\u8bef");
            }
            if (text == null) {
                text = dataBaseConfig.getSimpleName();
            }
            List tableNames = dataBaseConfig.getTableName();
            MetadataFactory factory = this.getClient().getDbFactory(configKey);
            List tables = factory.getTableInfos(text);
            for (TableInfo table : tables) {
                if (tableNames != null && !tableNames.contains(table.getName())) continue;
                UITableNode tabelui = new UITableNode(table);
                tableNodes.add(tabelui);
            }
            result.setData(tableNodes);
        }
        catch (Exception e) {
            ErrorListResultModel errorResult = new ErrorListResultModel();
            errorResult.setErrdes(e.getMessage());
            result = errorResult;
        }
        return result;
    }

    @Override
    @MethodChinaName(cname="\u83b7\u53d6\u5217\u4fe1\u606f\u6811\u5f62\u5b9e\u4f8b\u6570\u636e")
    @RequestMapping(method={RequestMethod.POST, RequestMethod.GET}, value={"GetColTree"})
    @ResponseBody
    public ListResultModel<List<UIColNode>> getColTree(String tableName, String configKey) {
        ListResultModel result = new ListResultModel();
        try {
            ArrayList<UIColNode> colNodes = new ArrayList<UIColNode>();
            MetadataFactory factory = this.getClient().getDbFactory(configKey);
            List cols = factory.getTableInfo(tableName).getColList();
            for (ColInfo col : cols) {
                colNodes.add(new UIColNode(col));
            }
            result.setData(colNodes);
        }
        catch (Exception e) {
            ErrorListResultModel errorResult = new ErrorListResultModel();
            errorResult.setErrdes(e.getMessage());
            result = errorResult;
        }
        return result;
    }

    @Override
    @MethodChinaName(cname="SQl\u6267\u884c\u76d1\u63a7")
    @RequestMapping(method={RequestMethod.GET}, value={"getSqlCountInfo"})
    @ResponseBody
    public ListResultModel<List<SqlExcuteInfo>> getSqlCountInfo(String configKey) {
        ListResultModel result = new ListResultModel();
        try {
            MetadataFactory factory = this.getClient().getDbFactory(configKey);
            result.setData((Object)factory.getSqlCountInfo());
        }
        catch (JDSException e) {
            ErrorListResultModel errorResult = new ErrorListResultModel();
            errorResult.setErrdes(e.getMessage());
            result = errorResult;
        }
        return result;
    }

    @Override
    @MethodChinaName(cname="SQl\u6267\u884c\u8be6\u7ec6\u4fe1\u606f")
    @RequestMapping(method={RequestMethod.GET}, value={"getSqlExcuteInfos"})
    @ResponseBody
    public ListResultModel<List<ProfiledConnectionEntry>> getSqlExcuteInfos(String configKey, SqlType type) {
        ListResultModel resultModel = new ListResultModel();
        try {
            MetadataFactory factory = this.getClient().getDbFactory(configKey);
            resultModel = PageUtil.getDefaultPageList((List)factory.getSqlExcuteInfos(type));
        }
        catch (JDSException e) {
            ErrorListResultModel errorResult = new ErrorListResultModel();
            errorResult.setErrdes(e.getMessage());
            resultModel = errorResult;
        }
        return resultModel;
    }

    @Override
    @MethodChinaName(cname="\u5f00\u542f\u76d1\u63a7")
    @RequestMapping(method={RequestMethod.GET}, value={"startSqlMonitor"})
    @ResponseBody
    public ResultModel<Boolean> startSqlMonitor(String configKey) {
        ResultModel resultModel = new ResultModel();
        try {
            MetadataFactory factory = this.getClient().getDbFactory(configKey);
            factory.startSqlMonitor();
        }
        catch (JDSException e) {
            ErrorResultModel errorResult = new ErrorResultModel();
            errorResult.setErrdes(e.getMessage());
            resultModel = errorResult;
        }
        return resultModel;
    }

    @Override
    @MethodChinaName(cname="\u505c\u6b62\u76d1\u63a7")
    @RequestMapping(method={RequestMethod.GET}, value={"stopSqlMonitor"})
    @ResponseBody
    public ResultModel<Boolean> stopSqlMonitor(String configKey) {
        ResultModel resultModel = new ResultModel();
        try {
            MetadataFactory factory = this.getClient().getDbFactory(configKey);
            factory.stopSqlMonitor();
        }
        catch (JDSException e) {
            ErrorResultModel errorResult = new ErrorResultModel();
            errorResult.setErrdes(e.getMessage());
            resultModel = errorResult;
        }
        return resultModel;
    }

    @Override
    @MethodChinaName(cname="\u91cdSQL\u76d1\u63a7")
    @RequestMapping(method={RequestMethod.GET}, value={"resetStatistics"})
    @ResponseBody
    public ResultModel<Boolean> resetStatistics(String configKey) {
        ResultModel resultModel = new ResultModel();
        try {
            MetadataFactory factory = this.getClient().getDbFactory(configKey);
            factory.resetStatistics();
        }
        catch (JDSException e) {
            ErrorResultModel errorResult = new ErrorResultModel();
            errorResult.setErrdes(e.getMessage());
            resultModel = errorResult;
        }
        return resultModel;
    }

    @Override
    @MethodChinaName(cname="\u521b\u5efa\u8868")
    @RequestMapping(method={RequestMethod.POST}, value={"CreateTable"})
    @ResponseBody
    public ResultModel<Boolean> createTable(@RequestBody TableInfo info) {
        ResultModel result = new ResultModel();
        try {
            MetadataFactory factory = this.getClient().getDbFactory(info.getConfigKey());
            factory.createTableByInfo(info);
        }
        catch (Exception e) {
            ErrorResultModel errorResult = new ErrorResultModel();
            errorResult.setErrdes(e.getMessage());
            result = errorResult;
        }
        return result;
    }

    @Override
    @MethodChinaName(cname="\u83b7\u53d6\u6240\u6709\u5e93\u8868")
    @RequestMapping(method={RequestMethod.POST}, value={"getAllTableTrees"})
    @ResponseBody
    public ListResultModel<List<UITopNode>> getAllTableTrees(String text, String configKey, String pattern) {
        ArrayList tableNodes = new ArrayList();
        ListResultModel resultModel = new ListResultModel();
        MetadataFactory factory = null;
        try {
            factory = this.getClient().getDbFactory(configKey);
            ArrayList<UITopNode> toptableNodes = new ArrayList<UITopNode>();
            UITopNode simpNode = new UITopNode("All_", "\u6240\u6709\u5e93\u8868", null, configKey);
            List tables = factory.getTableInfos(pattern);
            for (TableInfo tableInfo : tables) {
                simpNode.addSub(new UITableNode(tableInfo));
            }
            toptableNodes.add(simpNode);
            resultModel.setData(toptableNodes);
        }
        catch (Exception e) {
            ErrorListResultModel errorResult = new ErrorListResultModel();
            errorResult.setErrdes(e.getMessage());
            resultModel = errorResult;
        }
        return resultModel;
    }

    public ESDClient getClient() {
        ESDClient client = null;
        try {
            client = ESDFacrory.getESDClient();
        }
        catch (JDSException e) {
            e.printStackTrace();
        }
        return client;
    }
}

