/*
 * Decompiled with CFR 0.152.
 */
package com.ds.esd.admin.plugins.service;

import com.ds.common.JDSException;
import com.ds.common.util.StringUtility;
import com.ds.config.ErrorListResultModel;
import com.ds.config.ErrorResultModel;
import com.ds.config.ListResultModel;
import com.ds.config.ResultModel;
import com.ds.enums.db.MethodChinaName;
import com.ds.esd.admin.node.XUIFile;
import com.ds.esd.client.ESDClient;
import com.ds.esd.client.ESDFacrory;
import com.ds.esd.client.Project;
import com.ds.esd.client.ProjectVersion;
import com.ds.esd.project.config.ProjectConfig;
import com.ds.esd.project.enums.ProjectDefAccess;
import com.ds.esd.tool.module.EUModule;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/admin/plugs/component/"})
@MethodChinaName(cname="\u6269\u5c55\u7ec4\u4ef6\u670d\u52a1")
public class ComponentService {
    @MethodChinaName(cname="\u83b7\u53d6\u6269\u5c55\u7ec4\u4ef6\u670d\u52a1")
    @RequestMapping(value={"getExtCom"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public ListResultModel<Set<EUModule>> getExtCom(@PathVariable String projectName) {
        ListResultModel result = new ListResultModel();
        Set modulesConfigs = new HashSet();
        try {
            ProjectVersion projectVersion = this.getClient().getProjectVersionByName(projectName);
            modulesConfigs = projectVersion.getAllModule();
            result.setData(modulesConfigs);
        }
        catch (JDSException e) {
            e.printStackTrace();
            ErrorListResultModel errorResult = new ErrorListResultModel();
            errorResult.setErrdes(e.getMessage());
            result = errorResult;
        }
        return result;
    }

    @MethodChinaName(cname="\u6dfb\u52a0\u7ec4\u4ef6")
    @RequestMapping(value={"addExtCom"}, method={RequestMethod.POST})
    @ResponseBody
    public ResultModel<Boolean> addComponent(String projectName, String id) {
        ResultModel result = new ResultModel();
        try {
            ProjectVersion version = this.getClient().getProjectVersionByName(projectName);
            String[] ids = StringUtility.split((String)id, (String)";");
            ProjectConfig config = version.getProject().getConfig();
            List extcomIds = config.getExtcoms();
            for (String apiId : ids) {
                if (extcomIds.contains(apiId)) continue;
                extcomIds.add(apiId);
            }
            config.setExtcoms(extcomIds);
            version.updateConfig(config);
        }
        catch (JDSException e) {
            result = new ErrorResultModel();
            ((ErrorResultModel)result).setErrcode(100);
            ((ErrorResultModel)result).setErrdes(e.getMessage());
        }
        return result;
    }

    @MethodChinaName(cname="\u83b7\u53d6\u7ec4\u4ef6\u5de5\u7a0b")
    @RequestMapping(value={"getExtComTreeProject"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public ListResultModel<List<XUIFile>> getExtComTreeProject() {
        ListResultModel result = new ListResultModel();
        ArrayList<XUIFile> xuiFiles = new ArrayList<XUIFile>();
        ArrayList folders = new ArrayList();
        try {
            List projects = this.getClient().getAllProject(ProjectDefAccess.ExtCom);
            for (Project project : projects) {
                Set modules = null;
                ProjectVersion projectVersion = project.getActiveProjectVersion();
                try {
                    modules = projectVersion.getAllModule();
                }
                catch (JDSException e) {
                    e.printStackTrace();
                }
                if (modules == null || modules.size() <= 0) continue;
                xuiFiles.add(new XUIFile(projectVersion));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            ErrorListResultModel errorResult = new ErrorListResultModel();
            errorResult.setErrdes(e.getMessage());
            result = errorResult;
        }
        result.setData(xuiFiles);
        return result;
    }

    @MethodChinaName(cname="\u83b7\u53d6\u901a\u7528\u7ec4\u4ef6\u5de5\u7a0b")
    @RequestMapping(value={"getComTreeProject"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public ListResultModel<List<XUIFile>> getComTreeProject() {
        ListResultModel result = new ListResultModel();
        ArrayList<XUIFile> xuiFiles = new ArrayList<XUIFile>();
        ArrayList folders = new ArrayList();
        try {
            List projects = this.getClient().getAllProject(ProjectDefAccess.Component);
            for (Project project : projects) {
                Set modules = null;
                ProjectVersion projectVersion = project.getActiveProjectVersion();
                try {
                    modules = projectVersion.getAllModule();
                }
                catch (JDSException e) {
                    e.printStackTrace();
                }
                if (modules == null || modules.size() <= 0) continue;
                xuiFiles.add(new XUIFile(projectVersion));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            ErrorListResultModel errorResult = new ErrorListResultModel();
            errorResult.setErrdes(e.getMessage());
            result = errorResult;
        }
        result.setData(xuiFiles);
        return result;
    }

    @MethodChinaName(cname="\u5220\u9664\u7ec4\u4ef6")
    @RequestMapping(value={"delComponent"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public ResultModel<Boolean> delComponent(String projectName, String id) {
        ResultModel result = new ResultModel();
        List fontConfigIds = new ArrayList();
        try {
            Project project = this.getClient().getProjectByName(projectName);
            fontConfigIds = project.getConfig().getFonts();
            fontConfigIds.remove(id);
            this.getClient().updateProjectConfig(project.getId(), project.getConfig());
        }
        catch (JDSException e) {
            e.printStackTrace();
            ErrorResultModel errorResult = new ErrorResultModel();
            errorResult.setErrdes(e.getMessage());
            errorResult.setErrcode(e.getErrorCode());
            result = errorResult;
        }
        return result;
    }

    @MethodChinaName(cname="\u83b7\u53d6\u7ec4\u4ef6")
    @RequestMapping(value={"getProjectExtComs"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public ListResultModel<List<EUModule>> getProjectComponents(String projectName) {
        ListResultModel result = new ListResultModel();
        try {
            Project project = this.getClient().getProjectByName(projectName);
            List fontConfigs = project.getComponents();
            result.setData((Object)fontConfigs);
        }
        catch (JDSException e) {
            e.printStackTrace();
        }
        return result;
    }

    public ESDClient getClient() throws JDSException {
        ESDClient client = ESDFacrory.getESDClient();
        return client;
    }
}

