/*
 * Decompiled with CFR 0.152.
 */
package com.ds.esd.admin.plugins.service;

import com.ds.cluster.ServerNode;
import com.ds.common.JDSException;
import com.ds.common.logging.Log;
import com.ds.common.logging.LogFactory;
import com.ds.config.ErrorListResultModel;
import com.ds.config.ListResultModel;
import com.ds.enums.db.MethodChinaName;
import com.ds.esd.client.ESDClient;
import com.ds.esd.client.ESDFacrory;
import com.ds.esd.client.Project;
import com.ds.esd.client.ProjectVersion;
import com.ds.esd.editor.enums.PackageType;
import com.ds.esd.plugins.api.enums.APIType;
import com.ds.esd.plugins.api.node.APIComponentNode;
import com.ds.esd.plugins.api.node.APIPaths;
import com.ds.esd.plugins.api.node.XUIAPIConfig;
import com.ds.esd.tool.module.EUModule;
import com.ds.esd.tool.ui.module.ModuleComponent;
import com.ds.server.JDSServer;
import com.ds.web.util.PageUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/RAD/{projectName}/api/"})
public class APIService {
    private static final Log logger = LogFactory.getLog((String)"JDS", APIService.class);

    @ResponseBody
    @RequestMapping(value={"getPageServiceToolBox"}, method={RequestMethod.POST, RequestMethod.GET})
    public ListResultModel<List<APIComponentNode>> getPageServiceToolBox(String pattern, String className, @PathVariable String projectName) {
        ListResultModel result = new ListResultModel();
        Project project = null;
        try {
            if (className != null && !className.equals("")) {
                project = this.getClient().getProjectByName(projectName);
                EUModule module = this.getClient().getModule(className, projectName);
                ModuleComponent moduleComponent = module.getComponent();
                ArrayList<APIComponentNode> extModuleList = new ArrayList<APIComponentNode>();
                List extCls = moduleComponent.getRequired();
                extModuleList.add(new APIComponentNode(moduleComponent, pattern));
                for (String extClsName : extCls) {
                    EUModule extModule = this.getClient().getModule(extClsName, projectName);
                    if (extModule == null) continue;
                    extModuleList.add(new APIComponentNode(extModule.getComponent(), pattern));
                }
                result.setData(extModuleList);
            }
        }
        catch (JDSException e) {
            result = new ErrorListResultModel();
            ((ErrorListResultModel)result).setErrcode(100);
            ((ErrorListResultModel)result).setErrdes(e.getMessage());
        }
        return result;
    }

    @ResponseBody
    @RequestMapping(value={"getProjectServiceToolBox"}, method={RequestMethod.POST, RequestMethod.GET})
    public ListResultModel<List<APIComponentNode>> getProjectServiceToolBox(String pattern, @PathVariable String projectName) {
        ListResultModel result = new ListResultModel();
        ProjectVersion projectVersion = null;
        try {
            projectVersion = this.getClient().getProjectVersionByName(projectName);
            APIComponentNode projectNode = new APIComponentNode(projectVersion, pattern, PackageType.local);
            List sub = projectNode.getSub();
            Collections.sort(sub, new Comparator<APIComponentNode>(){

                @Override
                public int compare(APIComponentNode o1, APIComponentNode o2) {
                    return o1.getPath().toLowerCase().compareTo(o1.getPath().toLowerCase());
                }
            });
            result.setData((Object)sub);
        }
        catch (JDSException e) {
            result = new ErrorListResultModel();
            ((ErrorListResultModel)result).setErrcode(100);
            ((ErrorListResultModel)result).setErrdes(e.getMessage());
        }
        return result;
    }

    @ResponseBody
    @RequestMapping(value={"getLocalServiceToolBox"}, method={RequestMethod.POST, RequestMethod.GET})
    public ListResultModel<List<APIComponentNode>> getLocalServiceToolBox(String pattern, @PathVariable String projectName) {
        ListResultModel result = new ListResultModel();
        Project project = null;
        try {
            project = this.getClient().getProjectByName(projectName);
            List apis = project.getApiFilter();
            List<APIComponentNode> configs = this.getLocalComponentService(pattern, apis);
            result.setData(configs);
        }
        catch (JDSException e) {
            result = new ErrorListResultModel();
            ((ErrorListResultModel)result).setErrcode(100);
            ((ErrorListResultModel)result).setErrdes(e.getMessage());
        }
        return result;
    }

    @MethodChinaName(cname="\u83b7\u53d6\u914d\u7f6e")
    @RequestMapping(value={"getAPIConfig"}, method={RequestMethod.POST})
    @ResponseBody
    public ListResultModel<List<APIComponentNode>> getAPIConfig(String projectName, String id) {
        ListResultModel result = new ListResultModel();
        try {
            ESDClient client = ESDFacrory.getESDClient();
            ProjectVersion service = client.getProjectVersionByName(projectName);
            List ids = service.getProject().getConfig().getApiFilter();
            ArrayList<APIComponentNode> configs = new ArrayList<APIComponentNode>();
            List<APIComponentNode> componentNodes = this.getLocalComponentService(null, ids);
            for (APIComponentNode componentNode : componentNodes) {
                for (APIComponentNode sub : componentNode.getSub()) {
                    if (!ids.contains(sub.getId())) continue;
                    configs.add(sub);
                }
            }
            result = PageUtil.getDefaultPageList(configs);
        }
        catch (JDSException e) {
            result = new ErrorListResultModel();
            ((ErrorListResultModel)result).setErrcode(100);
            ((ErrorListResultModel)result).setErrdes(e.getMessage());
        }
        return result;
    }

    public List<APIComponentNode> getLocalComponentService(String pattern, List<String> apiIds) throws JDSException {
        ArrayList<APIComponentNode> configs = new ArrayList<APIComponentNode>();
        long time = System.currentTimeMillis();
        List paths = this.getClient().getAPITopPaths(pattern, APIType.userdef);
        for (APIPaths path : paths) {
            APIComponentNode topAPI = new APIComponentNode(path, true, pattern, apiIds);
            if (topAPI.getSub() == null || topAPI.getSub().size() <= 0) continue;
            configs.add(topAPI);
        }
        Arrays.sort(configs.toArray());
        return configs;
    }

    @ResponseBody
    @RequestMapping(value={"getRemoteServiceByKey"}, method={RequestMethod.POST, RequestMethod.GET})
    public ListResultModel<List<APIComponentNode>> getRemoteServiceService(String serverId, String pattern, String projectName) {
        ListResultModel result = new ListResultModel();
        ServerNode serverNode = JDSServer.getClusterClient().getServerNodeById(serverId);
        ArrayList componentNodes = new ArrayList();
        Set beans = serverNode.getServices();
        Project project = null;
        try {
            project = this.getClient().getProjectByName(projectName);
            List filters = project.getApiFilter();
            APIComponentNode serverAPI = new APIComponentNode(this.getClient().getAPIPaths(serverId + ":/"), true, pattern, filters);
            if (serverAPI != null && serverAPI.getSub() != null) {
                componentNodes.addAll(serverAPI.getSub());
            }
        }
        catch (JDSException e) {
            result = new ErrorListResultModel();
            ((ErrorListResultModel)result).setErrcode(100);
            ((ErrorListResultModel)result).setErrdes(e.getMessage());
        }
        Arrays.sort(componentNodes.toArray());
        result.setData(componentNodes);
        return result;
    }

    @ResponseBody
    @RequestMapping(value={"getAPIService"}, method={RequestMethod.POST, RequestMethod.GET})
    public ListResultModel<List<XUIAPIConfig>> getAPIService(String pattern, @PathVariable String projectName) {
        ListResultModel result = new ListResultModel();
        List services = new ArrayList();
        try {
            services = this.getClient().searchLocalService(projectName, pattern);
            result.setData(services);
        }
        catch (JDSException e) {
            result = new ErrorListResultModel();
            ((ErrorListResultModel)result).setErrcode(100);
            ((ErrorListResultModel)result).setErrdes(e.getMessage());
        }
        return result;
    }

    @ResponseBody
    @RequestMapping(value={"getAllServerToolBox"}, method={RequestMethod.POST, RequestMethod.GET})
    public ListResultModel<List<APIComponentNode>> getRemoteServiceToolBox(String pattern, String projectName) {
        ListResultModel module = new ListResultModel();
        ArrayList<APIComponentNode> servers = new ArrayList<APIComponentNode>();
        List serviceBeans = JDSServer.getClusterClient().getAllServer();
        for (ServerNode bean : serviceBeans) {
            if (bean.getServices().size() <= 0) continue;
            APIComponentNode serverApiNode = new APIComponentNode(bean);
            servers.add(serverApiNode);
        }
        module.setData(servers);
        return module;
    }

    public ESDClient getClient() throws JDSException {
        ESDClient client = ESDFacrory.getESDClient();
        return client;
    }
}

